/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class TofuFishModel
extends EntityModel<LivingEntityRenderState> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftFin;
    private final ModelPart rightFin;
    private final ModelPart tailfin;

    public TofuFishModel(ModelPart root) {
        super(root);
        this.root = root;
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.leftFin = root.getChild("leftFin");
        this.rightFin = root.getChild("rightFin");
        this.tailfin = root.getChild("tailfin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.5f, -6.0f, 1.0f, 3.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(22, 0).mirror().addBox(0.0f, -7.0f, 1.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(22, 0).mirror().addBox(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)-5.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-1.5f, -3.0f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)22.0f, (float)-5.0f));
        PartDefinition leftFin = partdefinition.addOrReplaceChild("leftFin", CubeListBuilder.create().texOffs(14, 13).mirror().addBox(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.5f, (float)23.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition rightFin = partdefinition.addOrReplaceChild("rightFin", CubeListBuilder.create().texOffs(14, 13).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)23.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition tailfin = partdefinition.addOrReplaceChild("tailfin", CubeListBuilder.create().texOffs(0, 21).mirror().addBox(0.0f, -6.0f, 0.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(LivingEntityRenderState entity) {
        float f = 1.0f;
        if (!entity.isInWater) {
            f = 1.5f;
        }
        this.tailfin.yRot = -f * 0.45f * Mth.sin((float)(0.6f * entity.walkAnimationSpeed));
        this.rightFin.zRot = -0.2f + 0.4f * Mth.sin((float)(entity.ageInTicks * 0.2f));
        this.leftFin.zRot = 0.2f - 0.4f * Mth.sin((float)(entity.ageInTicks * 0.2f));
    }
}

