/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.render.blockentity;

import baguchi.tofucraft.block.FoodPlateBlock;
import baguchi.tofucraft.blockentity.FoodPlateBlockEntity;
import baguchi.tofucraft.client.render.blockentity.state.FoodPlateRenderState;
import baguchi.tofucraft.registry.TofuBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class FoodPlateRender
implements BlockEntityRenderer<FoodPlateBlockEntity, FoodPlateRenderState> {
    private final RandomSource random = RandomSource.create();
    private ItemModelResolver itemModelResolver;

    public FoodPlateRender(BlockEntityRendererProvider.Context p_174114_) {
        this.itemModelResolver = p_174114_.itemModelResolver();
    }

    public FoodPlateRender() {
    }

    public void renderInHand(FoodPlateRenderState foodPlateRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector) {
        float f = 90.0f;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.1f, 0.0f);
        BlockState state = ((Block)TofuBlocks.FOODPLATE.get()).defaultBlockState();
        submitNodeCollector.submitBlock(poseStack, state, foodPlateRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
        if (!foodPlateRenderState.plateItem.isEmpty()) {
            poseStack.pushPose();
            this.renderPlacedItem(foodPlateRenderState, poseStack, submitNodeCollector);
            poseStack.popPose();
        }
    }

    public int getRenderAmount(ItemStack p_115043_) {
        int i = 1;
        if (p_115043_.getCount() > 48) {
            i = 5;
        } else if (p_115043_.getCount() > 32) {
            i = 4;
        } else if (p_115043_.getCount() > 16) {
            i = 3;
        } else if (p_115043_.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    public void renderItemLayingDown(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.translate(0.5, 0.07, 0.5);
        float f = -direction.toYRot();
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f));
        matrixStackIn.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
    }

    public void renderBlock(PoseStack matrixStackIn, Direction direction, boolean candle) {
        float f = -direction.toYRot();
        matrixStackIn.translate(0.5, 0.0, 0.5);
        if (!candle) {
            matrixStackIn.scale(0.6f, 0.6f, 0.6f);
        }
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f));
        matrixStackIn.translate(-0.5, 0.0, -0.5);
    }

    public FoodPlateRenderState createRenderState() {
        return new FoodPlateRenderState();
    }

    public void extractRenderState(FoodPlateBlockEntity foodPlateBlockEntity, FoodPlateRenderState foodPlateRenderState, float p_446851_, Vec3 p_445788_, @Nullable ModelFeatureRenderer.CrumblingOverlay p_446944_) {
        super.extractRenderState((BlockEntity)foodPlateBlockEntity, (BlockEntityRenderState)foodPlateRenderState, p_446851_, p_445788_, p_446944_);
        this.itemModelResolver.updateForTopItem(foodPlateRenderState.plateItem, foodPlateBlockEntity.getStoredItem(), ItemDisplayContext.GROUND, null, null, 0);
        foodPlateRenderState.plateState = Block.byItem((Item)foodPlateBlockEntity.getStoredItem().getItem()).defaultBlockState();
        foodPlateRenderState.candle = foodPlateBlockEntity.getStoredItem().is(ItemTags.CANDLES);
        foodPlateRenderState.cake = Block.byItem((Item)foodPlateBlockEntity.getStoredItem().getItem()) instanceof CakeBlock;
        foodPlateRenderState.fire = foodPlateBlockEntity.isFire();
        foodPlateRenderState.renderAmount = this.getRenderAmount(foodPlateBlockEntity.getStoredItem());
        foodPlateRenderState.direction = (Direction)foodPlateBlockEntity.getBlockState().getValue(FoodPlateBlock.FACING);
    }

    public void submit(FoodPlateRenderState foodPlateRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        this.random.setSeed(187L);
        this.renderPlacedItem(foodPlateRenderState, poseStack, submitNodeCollector);
    }

    private void renderPlacedItem(FoodPlateRenderState foodPlateRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector) {
        for (int k = 0; k < foodPlateRenderState.renderAmount; ++k) {
            if ((foodPlateRenderState.candle || foodPlateRenderState.cake) && foodPlateRenderState.plateState != null) {
                poseStack.pushPose();
                this.renderBlock(poseStack, foodPlateRenderState.direction, foodPlateRenderState.candle);
                BlockState state = foodPlateRenderState.plateState;
                if (foodPlateRenderState.candle) {
                    state = (BlockState)state.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(foodPlateRenderState.fire));
                }
                submitNodeCollector.submitBlock(poseStack, state, foodPlateRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poseStack.popPose();
                continue;
            }
            if (foodPlateRenderState.plateItem.isEmpty()) continue;
            poseStack.pushPose();
            if (k > 0) {
                float f12 = this.random.nextFloat() * 0.15f * 0.5f;
                float f14 = this.random.nextFloat() * 0.15f * 0.5f;
                poseStack.translate(f12, (float)k * 0.1f * 0.5f, f14);
            }
            this.renderItemLayingDown(poseStack, foodPlateRenderState.direction);
            foodPlateRenderState.plateItem.submit(poseStack, submitNodeCollector, foodPlateRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }
}

