/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.screen;

import baguchi.tofucraft.client.recipe.TFCraftingTableRecipeBookComponent;
import baguchi.tofucraft.inventory.TFCraftingTableMenu;
import baguchi.tofucraft.mixin.client.AbstractRecipeBookScreenAccessor;
import baguchi.tofucraft.registry.TofuFluids;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.data.AtlasIds;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix3x2fStack;

public class TfCraftingTableScreen
extends AbstractRecipeBookScreen<TFCraftingTableMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/tf_crafting_table.png");
    private static final Rectangle PROGRESS_ARROW = new Rectangle(89, 34, 24, 17);
    private boolean needRefresh;
    private int needRefreshTimer;

    public TfCraftingTableScreen(TFCraftingTableMenu screenContainer, Inventory inv, Component titleIn) {
        super((RecipeBookMenu)screenContainer, (RecipeBookComponent)new TFCraftingTableRecipeBookComponent(screenContainer), inv, titleIn);
    }

    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 5, this.height / 2 - 49);
    }

    public void setNeedRefresh() {
        this.needRefreshTimer = 30;
        this.needRefresh = true;
    }

    protected void init() {
        super.init();
        if (((TFCraftingTableMenu)this.menu).blockEntity.getRecipeDisplay() != null) {
            this.fillGhostRecipe(((TFCraftingTableMenu)this.menu).blockEntity.getRecipeDisplay());
        }
    }

    public void containerTick() {
        super.containerTick();
        if (this.needRefresh && --this.needRefreshTimer <= 0) {
            this.needRefresh = false;
            if (((TFCraftingTableMenu)this.menu).blockEntity.getRecipeDisplay() != null) {
                this.fillGhostRecipe(((TFCraftingTableMenu)this.menu).blockEntity.getRecipeDisplay());
            }
        }
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft == null) {
            return;
        }
        gui.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int heightInd = (int)(44.0f * (float)((TFCraftingTableMenu)this.menu).getTFEnergy() / (float)((TFCraftingTableMenu)this.menu).getTFMaxEnergy());
        if (heightInd > 0) {
            TfCraftingTableScreen.renderFluidStack(gui, gui.pose(), this.leftPos + 158, this.topPos + 69, 10, heightInd, (Fluid)TofuFluids.SOYMILK.get());
        }
        int l = ((TFCraftingTableMenu)this.menu).getCookProgressionScaled();
        gui.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, this.leftPos + TfCraftingTableScreen.PROGRESS_ARROW.x, this.topPos + TfCraftingTableScreen.PROGRESS_ARROW.y, 176.0f, 15.0f, l + 1, TfCraftingTableScreen.PROGRESS_ARROW.height, 256, 256);
    }

    public static void renderFluidStack(GuiGraphics guiGraphics, Matrix3x2fStack stack, int xPosition, int yPosition, int desiredWidth, int desiredHeight, Fluid fluid) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).getSprite(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
        int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int xTileCount = desiredWidth / 16;
        int xRemainder = desiredWidth - xTileCount * 16;
        int yTileCount = desiredHeight / 16;
        int yRemainder = desiredHeight - yTileCount * 16;
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, xPosition, yPosition - desiredHeight, desiredWidth, desiredHeight, color);
    }

    protected void renderSlots(GuiGraphics p_376313_) {
        ((AbstractRecipeBookScreenAccessor)((Object)this)).getRecipeBookComponent().renderGhostRecipe(p_376313_, this.isBiggerResultSlot());
        for (Slot slot : ((TFCraftingTableMenu)this.menu).slots) {
            if (!slot.isActive()) continue;
            this.renderSlot(p_376313_, slot);
        }
    }
}

