/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.data.generator;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.registry.TofuBannerPatterns;
import baguchi.tofucraft.registry.TofuPoiTypes;
import baguchi.tofucraft.registry.TofuSounds;
import baguchi.tofucraft.registry.TofuTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.KeyTagProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.entity.BannerPattern;

public class CustomTagGenerator {

    public static class SoundEventTagGenerator
    extends KeyTagProvider<SoundEvent> {
        public SoundEventTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, Registries.SOUND_EVENT, provider, "tofucraft");
        }

        protected void addTags(HolderLookup.Provider p_256380_) {
            this.tag(TofuTags.SoundEvents.BOSS_MUSIC).add((Object)TofuSounds.TOFU_DUNGEON_BGM.getKey());
        }
    }

    public static class PoiTypeTagGenerator
    extends KeyTagProvider<PoiType> {
        public PoiTypeTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, Registries.POINT_OF_INTEREST_TYPE, provider, "tofucraft");
        }

        protected void addTags(HolderLookup.Provider p_256380_) {
            this.tag(TofuTags.PoiTypes.TOFU_VILLAGE).add(TofuPoiTypes.TOFUNIAN_STATUE);
            this.tag(PoiTypeTags.ACQUIRABLE_JOB_SITE).add(TofuPoiTypes.TOFU_CRAFTSMAN);
        }
    }

    public static class BannerPatternTagGenerator
    extends KeyTagProvider<BannerPattern> {
        public static final TagKey<BannerPattern> TOFUNIAN_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/tofunian");

        public BannerPatternTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, Registries.BANNER_PATTERN, provider, "tofucraft");
        }

        private static TagKey<BannerPattern> create(String name) {
            return TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)TofuCraftReload.prefix(name));
        }

        protected void addTags(HolderLookup.Provider p_256380_) {
            this.tag(TOFUNIAN_BANNER_PATTERN).add(TofuBannerPatterns.TOFUNIAN);
        }

        public String getName() {
            return "Tofucraft Banner Pattern Tags";
        }
    }
}

