/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity;

import baguchi.tofucraft.entity.HealInteractable;
import baguchi.tofucraft.entity.ItemBasedInteractable;
import baguchi.tofucraft.entity.ItemInteractable;
import baguchi.tofucraft.registry.TofuBiomes;
import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuParticleTypes;
import baguchi.tofucraft.registry.TofuTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class TofuPig
extends Pig
implements ItemInteractable {
    private static final Ingredient FOOD_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TofuItems.LEEK.get(), Items.CARROT});
    private static final EntityDataAccessor<Integer> DATA_HEALING_TIME = SynchedEntityData.defineId(TofuPig.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ItemBasedInteractable healilng;
    private static final EntityDataAccessor<String> TOFUPIG_TYPE = SynchedEntityData.defineId(TofuPig.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public TofuPig(EntityType<? extends TofuPig> p_29462_, Level p_29463_) {
        super(p_29462_, p_29463_);
        this.healilng = new HealInteractable(this.entityData, DATA_HEALING_TIME);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, itemstack -> itemstack.is(TofuTags.Items.TOFU_PIG_FOOD), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public static boolean checkTofuAnimalSpawnRules(EntityType<? extends Animal> p_27578_, LevelAccessor p_27579_, EntitySpawnReason p_27580_, BlockPos p_27581_, RandomSource p_27582_) {
        return p_27579_.getBlockState(p_27581_.below()).is(TofuTags.Blocks.TOFU_TERRAIN) && p_27579_.getRawBrightness(p_27581_, 0) > 8;
    }

    public InteractionResult mobInteract(Player p_28298_, InteractionHand p_28299_) {
        ItemStack var3 = p_28298_.getItemInHand(p_28299_);
        if (var3.is((Item)TofuItems.TOFUMETAL.get()) && !this.isBaby() && this.getTofuPigType().equals((Object)TofuPigType.NORMAL)) {
            p_28298_.playSound(SoundEvents.ANVIL_USE, 1.0f, 1.0f);
            var3.shrink(1);
            this.setTofuPigType(TofuPigType.METAL);
            return InteractionResult.SUCCESS;
        }
        if (var3.is((Item)TofuItems.TOFUGRILLED.get()) && !this.isBaby() && this.getTofuPigType().equals((Object)TofuPigType.NORMAL)) {
            p_28298_.playSound((SoundEvent)SoundEvents.GENERIC_EAT.value(), 1.0f, 1.0f);
            var3.shrink(1);
            this.setTofuPigType(TofuPigType.GRILLED);
            return InteractionResult.SUCCESS;
        }
        if (var3.is((Item)TofuItems.TOFUZUNDA.get()) && !this.isBaby() && this.getTofuPigType().equals((Object)TofuPigType.NORMAL)) {
            p_28298_.playSound((SoundEvent)SoundEvents.GENERIC_EAT.value(), 1.0f, 1.0f);
            var3.shrink(1);
            this.setTofuPigType(TofuPigType.ZUNDA);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_28298_, p_28299_);
    }

    @javax.annotation.Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)entity;
            if (this.getTofuPigType() == TofuPigType.ZUNDA && (player.getMainHandItem().is((Item)TofuItems.ZUNDAMUSHROOM_ON_A_STICK.get()) || player.getOffhandItem().is((Item)TofuItems.ZUNDAMUSHROOM_ON_A_STICK.get()))) {
                return player;
            }
            if (player.getMainHandItem().is(Items.CARROT_ON_A_STICK) || player.getOffhandItem().is(Items.CARROT_ON_A_STICK)) {
                return player;
            }
        }
        return null;
    }

    public void thunderHit(ServerLevel p_29473_, LightningBolt p_29474_) {
        if (this.getTofuPigType() == TofuPigType.NORMAL) {
            this.setTofuPigType(TofuPigType.ZUNDA);
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_146748_, @Nullable SpawnGroupData p_146749_) {
        if (p_146746_.getBiome(this.blockPosition()).is(TofuBiomes.ZUNDA_FOREST)) {
            this.setTofuPigType(TofuPigType.ZUNDA);
        }
        return super.finalizeSpawn(p_146746_, p_146747_, p_146748_, p_146749_);
    }

    public boolean isActivated() {
        return this.healilng.on;
    }

    public void tick() {
        if (this.isActivated() && this.getTofuPigType() == TofuPigType.ZUNDA) {
            this.healEffect();
            this.healilng.deActive();
        }
        super.tick();
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource source, float damage) {
        if (this.getTofuPigType() == TofuPigType.METAL) {
            damage = (float)((double)damage * 0.5);
        } else if (this.getTofuPigType() == TofuPigType.GRILLED && source.is(DamageTypeTags.IS_FIRE)) {
            return false;
        }
        return super.hurtServer(serverLevel, source, damage);
    }

    public void setTofuPigType(TofuPigType type) {
        this.entityData.set(TOFUPIG_TYPE, (Object)type.name());
    }

    public TofuPigType getTofuPigType() {
        return TofuPigType.get((String)this.entityData.get(TOFUPIG_TYPE));
    }

    @Override
    public boolean canHeal() {
        return this.healilng.active(this.getRandom());
    }

    private void healEffect() {
        float radius = 5.0f;
        AABB box = new AABB(this.getX() - (double)radius, this.getY() - 1.0, this.getZ() - (double)radius, this.getX() + (double)radius, this.getY() + 3.0, this.getZ() + (double)radius);
        List hitEntities = this.level().getEntitiesOfClass(LivingEntity.class, box);
        for (LivingEntity hitEntity : hitEntities) {
            if (hitEntity.level().isClientSide()) continue;
            hitEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200));
        }
        if (this.level().isClientSide()) {
            int count = 20;
            for (int i = 1; i <= count; ++i) {
                double yaw = (float)i * 365.0f / (float)count;
                double speed = 0.5;
                double xSpeed = speed * Math.cos(Math.toRadians(yaw));
                double zSpeed = speed * Math.sin(Math.toRadians(yaw));
                this.level().addParticle((ParticleOptions)TofuParticleTypes.ZUNDA_CLOUD.get(), this.getX(), this.getY(), this.getZ(), xSpeed, 0.0, zSpeed);
            }
        }
    }

    public TofuPig getBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_) {
        TofuPig tofuPig = (TofuPig)TofuEntityTypes.TOFUPIG.get().create((Level)p_148890_, EntitySpawnReason.BREEDING);
        if (tofuPig != null) {
            TofuPigType variant = this.random.nextBoolean() ? this.getTofuPigType() : ((TofuPig)p_148891_).getTofuPigType();
            tofuPig.setTofuPigType(variant);
        }
        return tofuPig;
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("TofuPigType", this.getTofuPigType().name());
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.setTofuPigType(TofuPigType.get(compound.getStringOr("TofuPigType", "")));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_29480_) {
        if (DATA_HEALING_TIME.equals(p_29480_) && this.level().isClientSide()) {
            this.healilng.onSynced();
        }
        super.onSyncedDataUpdated(p_29480_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TOFUPIG_TYPE, (Object)"NORMAL");
        builder.define(DATA_HEALING_TIME, (Object)0);
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(TofuTags.Items.TOFU_PIG_FOOD);
    }

    public static enum TofuPigType {
        NORMAL,
        METAL,
        GRILLED,
        ZUNDA;


        public static TofuPigType get(String nameIn) {
            for (TofuPigType role : TofuPigType.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return NORMAL;
        }
    }
}

