/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.loot;

import baguchi.tofucraft.registry.TofuEffects;
import baguchi.tofucraft.registry.TofuItems;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class ZundaModifier
extends LootModifier {
    public static final Supplier<MapCodec<ZundaModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> ZundaModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ZundaModifier::new)));

    protected ZundaModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LivingEntity living;
        Object object;
        ArrayList seeds = Lists.newArrayList();
        if (context.hasParameter(LootContextParams.THIS_ENTITY) && context.hasParameter(LootContextParams.ATTACKING_ENTITY) && context.hasParameter(LootContextParams.DAMAGE_SOURCE) && (object = context.getParameter(LootContextParams.THIS_ENTITY)) instanceof LivingEntity && (living = (LivingEntity)object).hasEffect(TofuEffects.ZUNDAFIED)) {
            if (living instanceof Creeper) {
                Creeper creeper = (Creeper)living;
                seeds.add(new ItemStack(TofuItems.UNSTABLE_ZUNDAMA, 1 + context.getRandom().nextInt(1)));
            } else if (living instanceof Slime) {
                Slime slime = (Slime)living;
                seeds.add(new ItemStack(TofuItems.ZUNDAMA, slime.getSize()));
            } else {
                seeds.add(new ItemStack((ItemLike)TofuItems.ZUNDA.get(), (int)(1.0f + living.getMaxHealth() / 30.0f)));
            }
        }
        if (!seeds.isEmpty()) {
            seeds.forEach(item -> generatedLoot.add(item));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

