/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.registry;

import baguchi.bagus_lib.world.processor.BaseProcessor;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuTags;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class TofuStructures {
    public static final ResourceKey<Structure> TOFU_CASTLE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_castle"));
    public static final ResourceKey<Structure> TOFU_VILLAGE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village"));
    public static final ResourceKey<Structure> ZUNDA_TOFU_VILLAGE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"zunda_tofu_village"));
    public static final ResourceKey<Structure> TOFU_RUINS = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_ruins"));
    public static final ResourceKey<Structure> TOFU_MINESHAFT = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_mineshaft"));
    public static final ResourceKey<StructureSet> TOFU_CASTLE_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_castle"));
    public static final ResourceKey<StructureSet> TOFU_VILLAGE_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village"));
    public static final ResourceKey<StructureSet> TOFU_RUINS_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_ruins"));
    public static final ResourceKey<StructureSet> TOFU_MINESHAFT_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_mineshaft"));
    public static final ResourceKey<StructureTemplatePool> TOFU_CASTLE_MAIN = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_castle/main"));
    public static final ResourceKey<StructureTemplatePool> TOFU_CASTLE_MAIN_2 = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_castle/main2"));
    public static final ResourceKey<StructureTemplatePool> TOFU_CASTLE_BRIDGE = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_castle/bridge"));
    public static final ResourceKey<StructureTemplatePool> TOFU_CASTLE_REWARD_BRIDGE = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_castle/reward_bridge"));
    public static final ResourceKey<StructureTemplatePool> TOFU_CASTLE_TOFU_GANDLEM = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_castle/mob/tofu_gandlem"));
    public static final ResourceKey<StructureTemplatePool> TOFU_VILLAGE_STREETS = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village/plains/streets"));
    public static final ResourceKey<StructureTemplatePool> TOFU_VILLAGE_HOUSE = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village/plains/house"));
    public static final ResourceKey<StructureTemplatePool> TOFU_VILLAGE_TOWN_CENTERS = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village/plains/town_centers"));
    public static final ResourceKey<StructureTemplatePool> ZUNDA_TOFU_VILLAGE_STREETS = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village/zunda/streets"));
    public static final ResourceKey<StructureTemplatePool> ZUNDA_TOFU_VILLAGE_HOUSE = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village/zunda/house"));
    public static final ResourceKey<StructureTemplatePool> ZUNDA_TOFU_VILLAGE_TOWN_CENTERS = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village/zunda/town_centers"));
    public static final ResourceKey<StructureTemplatePool> TOFUNIAN = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_village/tofunian"));
    public static final ResourceKey<StructureTemplatePool> TOFU_MINESHAFT_ROADS = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_mineshaft/roads"));
    public static final ResourceKey<StructureTemplatePool> TOFU_MINESHAFT_CENTERS = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_mineshaft/centers"));
    public static final ResourceKey<StructureTemplatePool> TOFU_RUINS_START = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_ruins"));
    public static final ResourceKey<StructureProcessorList> TOFU_PLAIN_VILLAGE_ROAD = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_plain_village_road"));
    public static final ResourceKey<StructureProcessorList> ZUNDA_FOREST_VILLAGE_ROAD = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"zunda_forest_village_road"));
    public static final ResourceKey<StructureProcessorList> TOFU_MINESHAFT_PROCESSOR = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_mineshaft"));

    public static void bootstrapStructures(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(TOFU_CASTLE, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(TofuTags.Biomes.TOFU_CASTLE)).spawnOverrides(Arrays.stream(MobCategory.values()).collect(Collectors.toMap(p_236555_ -> p_236555_, p_236551_ -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedList.builder().build())))).generationStep(GenerationStep.Decoration.SURFACE_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)pools.getOrThrow(TOFU_CASTLE_MAIN), Optional.empty(), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), new JigsawStructure.MaxDistance(80), List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
        context.register(TOFU_VILLAGE, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(TofuTags.Biomes.TOFU_VILLAGE)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)pools.getOrThrow(TOFU_VILLAGE_TOWN_CENTERS), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(ZUNDA_TOFU_VILLAGE, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(TofuTags.Biomes.ZUNDA_TOFU_VILLAGE)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)pools.getOrThrow(ZUNDA_TOFU_VILLAGE_TOWN_CENTERS), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(TOFU_RUINS, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(TofuTags.Biomes.TOFU_RUINS)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)pools.getOrThrow(TOFU_RUINS_START), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(TOFU_MINESHAFT, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(TofuTags.Biomes.TOFU_MINESHAFT)).terrainAdapation(TerrainAdjustment.NONE).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).build(), (Holder)pools.getOrThrow(TOFU_MINESHAFT_CENTERS), 12, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)16)), false));
    }

    public static void bootstrapSets(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        context.register(TOFU_CASTLE_SET, (Object)new StructureSet((Holder)structures.getOrThrow(TOFU_CASTLE), (StructurePlacement)new RandomSpreadStructurePlacement(34, 6, RandomSpreadType.LINEAR, 16324620)));
        context.register(TOFU_VILLAGE_SET, (Object)new StructureSet(List.of(StructureSet.entry((Holder)structures.getOrThrow(TOFU_VILLAGE), (int)1), StructureSet.entry((Holder)structures.getOrThrow(ZUNDA_TOFU_VILLAGE), (int)1)), (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.LINEAR, 16324620)));
        context.register(TOFU_RUINS_SET, (Object)new StructureSet((Holder)structures.getOrThrow(TOFU_RUINS), (StructurePlacement)new RandomSpreadStructurePlacement(28, 8, RandomSpreadType.LINEAR, 83469867)));
        context.register(TOFU_MINESHAFT_SET, (Object)new StructureSet((Holder)structures.getOrThrow(TOFU_MINESHAFT), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.LEGACY_TYPE_3, 0.001f, 0, Optional.empty(), 1, 0, RandomSpreadType.LINEAR)));
    }

    public static void bootstrapPools(BootstrapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPool = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        context.register(TOFU_VILLAGE_TOWN_CENTERS, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/town_centers/rest_place")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_VILLAGE_HOUSE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/house/hut_1")), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/house/farmlands")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/house/smithing_hut")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/house/water_space")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/house/smithing_hut_2")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/house/water_space_2")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_VILLAGE_STREETS, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/streets/road_1"), (Holder)processors.getOrThrow(TOFU_PLAIN_VILLAGE_ROAD)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/streets/road_2"), (Holder)processors.getOrThrow(TOFU_PLAIN_VILLAGE_ROAD)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/streets/road_3"), (Holder)processors.getOrThrow(TOFU_PLAIN_VILLAGE_ROAD)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/streets/road_4"), (Holder)processors.getOrThrow(TOFU_PLAIN_VILLAGE_ROAD)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/streets/road_5"), (Holder)processors.getOrThrow(TOFU_PLAIN_VILLAGE_ROAD)), (Object)3), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/plains/streets/road_6"), (Holder)processors.getOrThrow(TOFU_PLAIN_VILLAGE_ROAD)), (Object)3)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        context.register(ZUNDA_TOFU_VILLAGE_TOWN_CENTERS, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/town_centers/rest_place")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(ZUNDA_TOFU_VILLAGE_STREETS, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/streets/road_1"), (Holder)processors.getOrThrow(ZUNDA_FOREST_VILLAGE_ROAD)), (Object)3), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/streets/road_2"), (Holder)processors.getOrThrow(ZUNDA_FOREST_VILLAGE_ROAD)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/streets/road_3"), (Holder)processors.getOrThrow(ZUNDA_FOREST_VILLAGE_ROAD)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/streets/road_4"), (Holder)processors.getOrThrow(ZUNDA_FOREST_VILLAGE_ROAD)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/streets/road_5"), (Holder)processors.getOrThrow(ZUNDA_FOREST_VILLAGE_ROAD)), (Object)3), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/streets/road_6"), (Holder)processors.getOrThrow(ZUNDA_FOREST_VILLAGE_ROAD)), (Object)3)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        context.register(ZUNDA_TOFU_VILLAGE_HOUSE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/house/hut_1")), (Object)4), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/house/hut_2")), (Object)2), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/house/farmlands")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/house/smithing_hut")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/house/water_space")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/house/smithing_hut_2")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.legacy((String)TofuStructures.name("tofu_village/zunda/house/water_space_2")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFUNIAN, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_village/tofunian")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_MINESHAFT_CENTERS, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_mineshaft/center")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_MINESHAFT_ROADS, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_mineshaft/roads/road_1"), (Holder)processors.getOrThrow(TOFU_MINESHAFT_PROCESSOR)), (Object)3), (Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_mineshaft/roads/road_2"), (Holder)processors.getOrThrow(TOFU_MINESHAFT_PROCESSOR)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_mineshaft/roads/road_3"), (Holder)processors.getOrThrow(TOFU_MINESHAFT_PROCESSOR)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_mineshaft/roads/road_chest"), (Holder)processors.getOrThrow(TOFU_MINESHAFT_PROCESSOR)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_RUINS_START, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_ruins/tofu_world/portal_01")), (Object)3), (Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_ruins/tofu_world/portal_02")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_CASTLE_MAIN, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_castle/tofucastle_main")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_CASTLE_MAIN_2, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_castle/tofucastle_main_2")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_CASTLE_BRIDGE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_castle/bridge/tofucastle_brokenbridge")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_CASTLE_REWARD_BRIDGE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_castle/bridge/tofucastle_reward_bridge")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(TOFU_CASTLE_TOFU_GANDLEM, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)TofuStructures.name("tofu_castle/mob/tofu_gandlem")), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapProcessors(BootstrapContext<StructureProcessorList> context) {
        context.register(TOFU_PLAIN_VILLAGE_ROAD, (Object)new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)TofuBlocks.ISHITOFU_BRICK.get()), (RuleTest)new BlockMatchTest((Block)TofuBlocks.SOYMILK.get()), ((Block)TofuBlocks.LEEK_PLANKS.get()).defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)TofuBlocks.ISHITOFU_BRICK.get(), 0.2f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)TofuBlocks.TOFU_TERRAIN.get()).defaultBlockState()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)TofuBlocks.TOFU_TERRAIN.get()), (RuleTest)new BlockMatchTest((Block)TofuBlocks.SOYMILK.get()), ((Block)TofuBlocks.SOYMILK.get()).defaultBlockState()))))));
        context.register(ZUNDA_FOREST_VILLAGE_ROAD, (Object)new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)TofuBlocks.ZUNDATOFU_BRICK.get()), (RuleTest)new BlockMatchTest((Block)TofuBlocks.SOYMILK.get()), ((Block)TofuBlocks.TOFU_STEM_PLANKS.get()).defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)TofuBlocks.ZUNDATOFU_BRICK.get(), 0.2f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)TofuBlocks.TOFU_TERRAIN.get()).defaultBlockState()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)TofuBlocks.TOFU_TERRAIN.get()), (RuleTest)new BlockMatchTest((Block)TofuBlocks.SOYMILK.get()), ((Block)TofuBlocks.SOYMILK.get()).defaultBlockState()))))));
        context.register(TOFU_MINESHAFT_PROCESSOR, (Object)new StructureProcessorList((List)ImmutableList.of((Object)new BaseProcessor((Block)TofuBlocks.TOFU_STEM.get(), (Block)TofuBlocks.LEEK_STEM.get()))));
    }

    private static String name(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)name).toString();
    }
}

