/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft;

import baguchan.tofucraft.api.tfenergy.IEnergyContained;
import baguchan.tofucraft.attachment.SoyHealthAttachment;
import baguchan.tofucraft.attachment.TofuLivingAttachment;
import baguchan.tofucraft.block.utils.SoymilkCauldronBlock;
import baguchan.tofucraft.item.armor.BreakableTofuBootsItem;
import baguchan.tofucraft.registry.TofuAdvancements;
import baguchan.tofucraft.registry.TofuAttachments;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuDataComponents;
import baguchan.tofucraft.registry.TofuDimensions;
import baguchan.tofucraft.registry.TofuEffects;
import baguchan.tofucraft.registry.TofuEnchantments;
import baguchan.tofucraft.registry.TofuItemTier;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuPoiTypes;
import baguchan.tofucraft.registry.TofuStructures;
import baguchan.tofucraft.registry.TofuTags;
import baguchan.tofucraft.utils.ContainerUtils;
import baguchan.tofucraft.utils.JigsawHelper;
import baguchan.tofucraft.utils.TofuDiamondToolUtil;
import baguchan.tofucraft.world.TofuData;
import baguchan.tofucraft.world.TofuLevelData;
import baguchan.tofucraft.world.TravelerTofunianSpawner;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.SelectMusicEvent;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.village.VillageSiegeEvent;

@EventBusSubscriber(modid="tofucraft")
public class CommonEvents {
    private static final Map<ServerLevel, TravelerTofunianSpawner> TRAVELER_TOFUNIAN_SPAWNER_MAP = new HashMap<ServerLevel, TravelerTofunianSpawner>();

    @SubscribeEvent
    public static void onUpdate(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        SoyHealthAttachment soyHealth = (SoyHealthAttachment)entity.getData(TofuAttachments.SOY_HEALTH);
        if (!entity.level().isClientSide() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            soyHealth.tick(livingEntity);
        }
        TofuLivingAttachment tofuLivingAttachment = (TofuLivingAttachment)entity.getData(TofuAttachments.TOFU_LIVING);
        tofuLivingAttachment.tick(entity);
    }

    @SubscribeEvent
    public static void onMusicPlayed(SelectMusicEvent event) {
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
            Holder biome = Minecraft.getInstance().player.level().getBiome(Minecraft.getInstance().player.blockPosition());
            if (Minecraft.getInstance().level.dimension() == TofuDimensions.tofu_world) {
                event.setMusic(((Biome)biome.value()).getBackgroundMusic().orElse(Musics.GAME));
            }
        }
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level p_41436_, Player p_41437_, ClipContext.Fluid p_41438_) {
        Vec3 vec3 = p_41437_.getEyePosition();
        Vec3 vec31 = vec3.add(p_41437_.calculateViewVector(p_41437_.getXRot(), p_41437_.getYRot()).scale(p_41437_.blockInteractionRange()));
        return p_41436_.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, (Entity)p_41437_));
    }

    @SubscribeEvent
    public static void onUsedEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        Entity entity = event.getTarget();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            if (stack.is((Item)TofuItems.SALT.get())) {
                horse.addEffect(new MobEffectInstance(TofuEffects.SALT_BOOST, 3600));
                if (!event.getEntity().isCreative()) {
                    stack.shrink(1);
                }
                horse.eating();
                horse.gameEvent((Holder)GameEvent.EAT);
                horse.playSound(SoundEvents.HORSE_EAT);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockUsed(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemstack2;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        if (stack.is((Item)TofuItems.BUCKET_SOYMILK.get()) && stack.is((Item)TofuItems.BUCKET_SOYMILK.get()) && level.getBlockState(event.getPos()).is(Blocks.CAULDRON)) {
            level.setBlock(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_CAULDRON.get())).defaultBlockState(), 2);
            event.getEntity().playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.BUCKET);
            if (!event.getEntity().isCreative()) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                event.getEntity().setItemInHand(event.getHand(), itemstack2);
            } else if (!event.getEntity().isCreative() && !event.getEntity().getInventory().add(itemstack2)) {
                event.getEntity().drop(itemstack2, false);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (stack.is((Item)TofuItems.BUCKET_SOYMILK_NETHER.get()) && level.getBlockState(event.getPos()).is(Blocks.CAULDRON)) {
            level.setBlock(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_NETHER_CAULDRON.get())).defaultBlockState(), 2);
            event.getEntity().playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.BUCKET);
            if (!event.getEntity().isCreative()) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                event.getEntity().setItemInHand(event.getHand(), itemstack2);
            } else if (!event.getEntity().isCreative() && !event.getEntity().getInventory().add(itemstack2)) {
                event.getEntity().drop(itemstack2, false);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (stack.is((Item)TofuItems.BUCKET_SOYMILK_SOUL.get()) && level.getBlockState(event.getPos()).is(Blocks.CAULDRON)) {
            level.setBlock(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_SOUL_CAULDRON.get())).defaultBlockState(), 2);
            event.getEntity().playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.BUCKET);
            if (!event.getEntity().isCreative()) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                event.getEntity().setItemInHand(event.getHand(), itemstack2);
            } else if (!event.getEntity().isCreative() && !event.getEntity().getInventory().add(itemstack2)) {
                event.getEntity().drop(itemstack2, false);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockExplosion(ExplosionEvent.Detonate event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world = event.getLevel();
        if (world instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().registryOrThrow(Registries.STRUCTURE).get(TofuStructures.TOFU_CASTLE)) != null) {
            TofuData data = TofuData.get((Level)serverLevel);
            Vec3 center = event.getExplosion().center();
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(new BlockPos((int)center.x, (int)center.y, (int)center.z), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox())) {
                event.getAffectedBlocks().clear();
            }
        }
    }

    @SubscribeEvent
    public static void onBreakingSpeed(PlayerEvent.BreakSpeed event) {
        ItemEnchantments enchantments;
        ItemStack stack = event.getEntity().getMainHandItem();
        if (stack.is(TofuTags.Items.TOFU_DIAMOND_MINEABLE_ENCHANTABLE) && (enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)) != null) {
            event.setNewSpeed(event.getOriginalSpeed() / ((float)enchantments.getLevel((Holder)event.getEntity().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(TofuEnchantments.BATCH)) + 1.25f));
        }
    }

    @SubscribeEvent
    public static void onBlockDestroyByEntity(LivingDestroyBlockEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world = event.getEntity().level();
        if (world instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().registryOrThrow(Registries.STRUCTURE).get(TofuStructures.TOFU_CASTLE)) != null) {
            TofuData data = TofuData.get((Level)serverLevel);
            Vec3 center = event.getEntity().position();
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(new BlockPos((int)center.x, (int)center.y, (int)center.z), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockGriefing(EntityMobGriefingEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Entity entity = event.getEntity();
        Level world = event.getEntity().level();
        if (world instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().registryOrThrow(Registries.STRUCTURE).get(TofuStructures.TOFU_CASTLE)) != null) {
            TofuData data = TofuData.get((Level)serverLevel);
            Vec3 center = event.getEntity().position();
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(new BlockPos((int)center.x, (int)center.y, (int)center.z), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox())) {
                event.setCanGrief(false);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreaked(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world;
        if (event.getPlayer() instanceof ServerPlayer && (world = event.getPlayer().level()) instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().registryOrThrow(Registries.STRUCTURE).get(TofuStructures.TOFU_CASTLE)) != null) {
            ServerPlayer player;
            TofuData data = TofuData.get((Level)serverLevel);
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(event.getPos(), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox()) && !(player = (ServerPlayer)event.getPlayer()).isCreative() && !(event.getState().getBlock() instanceof TorchBlock)) {
                player.displayClientMessage((Component)Component.translatable((String)"tofucraft.need_defeat_boss"), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world;
        if (event.getEntity() instanceof ServerPlayer && (world = event.getEntity().level()) instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().registryOrThrow(Registries.STRUCTURE).get(TofuStructures.TOFU_CASTLE)) != null) {
            ServerPlayer player;
            TofuData data = TofuData.get((Level)serverLevel);
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(event.getPos(), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox()) && !(player = (ServerPlayer)event.getEntity()).isCreative() && !(event.getState().getBlock() instanceof TorchBlock)) {
                player.displayClientMessage((Component)Component.translatable((String)"tofucraft.need_defeat_boss"), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(FinalizeSpawnEvent event) {
        Optional optional;
        Mob livingEntity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        if (livingEntity instanceof Enemy && event.getSpawnType() != MobSpawnType.SPAWNER && event.getSpawnType() != MobSpawnType.TRIAL_SPAWNER && event.getSpawnType() != MobSpawnType.EVENT && event.getSpawnType() != MobSpawnType.BREEDING && event.getSpawnType() != MobSpawnType.PATROL && level instanceof ServerLevel && (optional = ((ServerLevel)level).getPoiManager().findClosest(p_184069_ -> p_184069_.is(TofuPoiTypes.MORIJIO), p_184055_ -> true, livingEntity.blockPosition(), 32, PoiManager.Occupancy.ANY)).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCheckZombieSiege(VillageSiegeEvent event) {
        Optional optional;
        Vec3 vec3 = event.getAttemptedSpawnPos();
        Level level = event.getLevel();
        if (level instanceof ServerLevel && (optional = ((ServerLevel)level).getPoiManager().findClosest(p_184069_ -> p_184069_.is(TofuPoiTypes.MORIJIO), p_184055_ -> true, BlockPos.containing((Position)vec3), 32, PoiManager.Occupancy.ANY)).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).dimensionTypeRegistration().is(TofuDimensions.tofu_world.location())) {
            TofuLevelData levelData = new TofuLevelData(level.getServer().getWorldData(), level.getServer().getWorldData().overworldData());
            level.serverLevelData = levelData;
            level.levelData = levelData;
        }
    }

    @SubscribeEvent
    public static void onServerTick(LevelTickEvent.Post tick) {
        Level level;
        if (!tick.getLevel().isClientSide && (level = tick.getLevel()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            TRAVELER_TOFUNIAN_SPAWNER_MAP.computeIfAbsent(serverWorld, k -> new TravelerTofunianSpawner(serverWorld));
            TravelerTofunianSpawner spawner = TRAVELER_TOFUNIAN_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerStartedEvent event) {
        JigsawHelper.registerJigsaw(event.getServer(), ResourceLocation.parse((String)"minecraft:village/plains/houses"), ResourceLocation.parse((String)"tofucraft:village/tofu_craftsman_house_plains_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), ResourceLocation.parse((String)"minecraft:village/taiga/houses"), ResourceLocation.parse((String)"tofucraft:village/tofu_craftsman_house_taiga_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), ResourceLocation.parse((String)"minecraft:village/savanna/houses"), ResourceLocation.parse((String)"tofucraft:village/tofu_craftsman_house_savanna_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), ResourceLocation.parse((String)"minecraft:village/snowy/houses"), ResourceLocation.parse((String)"tofucraft:village/tofu_craftsman_house_snowy_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), ResourceLocation.parse((String)"minecraft:village/desert/houses"), ResourceLocation.parse((String)"tofucraft:village/tofu_craftsman_house_desert_1"), 10);
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        if (!event.isWasDeath()) {
            SoyHealthAttachment soyHealth = (SoyHealthAttachment)oldPlayer.getData(TofuAttachments.SOY_HEALTH);
            SoyHealthAttachment soyHealth2 = (SoyHealthAttachment)newPlayer.getData(TofuAttachments.SOY_HEALTH);
            soyHealth2.deserializeNBT((HolderLookup.Provider)newPlayer.level().registryAccess(), soyHealth.serializeNBT((HolderLookup.Provider)newPlayer.level().registryAccess()));
        }
    }

    @SubscribeEvent
    public static void onFall(LivingDamageEvent.Post event) {
        Item item;
        float damage = event.getNewDamage();
        LivingEntity entity = event.getEntity();
        ItemStack feet = entity.getItemBySlot(EquipmentSlot.FEET);
        if (event.getSource().is(DamageTypeTags.IS_FALL) && (item = feet.getItem()) instanceof BreakableTofuBootsItem) {
            BreakableTofuBootsItem bootsItem = (BreakableTofuBootsItem)item;
            int unstability = (Integer)feet.getOrDefault((DataComponentType)TofuDataComponents.UNSTABILITY.get(), (Object)0);
            if (damage + (float)unstability < (float)((Integer)feet.getOrDefault((DataComponentType)TofuDataComponents.MAX_FALL_DURABILITY.get(), (Object)0)).intValue()) {
                feet.set((DataComponentType)TofuDataComponents.UNSTABILITY.get(), (Object)(Mth.ceil((float)(damage + 1.0f)) + unstability));
            } else {
                feet.hurtAndBreak(10, entity, EquipmentSlot.FEET);
                entity.playSound(SoundEvents.SLIME_BLOCK_FALL);
            }
            if (entity.isAlive() && damage >= 10.0f && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TofuAdvancements.NARROW_ESCAPE_TRIGGER.get().trigger(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.isDamageSourceBlocked(event.getSource()) && entity.getUseItem().is((Item)TofuItems.REFLECT_TOFU_SHIELD.get())) {
            IEnergyContained energyContained;
            Entity attacker = event.getSource().getDirectEntity();
            Item item = entity.getUseItem().getItem();
            if (item instanceof IEnergyContained && (energyContained = (IEnergyContained)item).getEnergy(entity.getUseItem()) >= 50) {
                energyContained.setEnergy(entity.getUseItem(), energyContained.getEnergy(entity.getUseItem()) - 50);
                if (attacker != null) {
                    attacker.hurt(entity.damageSources().thorns((Entity)entity), 3.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onShieldEvent(LivingShieldBlockEvent event) {
        IEnergyContained energyContained;
        Item item;
        if (event.getEntity().getUseItem().is((Item)TofuItems.REFLECT_TOFU_SHIELD.get()) && (item = event.getEntity().getUseItem().getItem()) instanceof IEnergyContained && (energyContained = (IEnergyContained)item).getEnergy(event.getEntity().getUseItem()) >= 50) {
            event.setBlockedDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onBlockModificationEvent(PlayerInteractEvent.RightClickBlock event) {
        boolean shroomlight;
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (player != null && stack.is(Items.GLASS_BOTTLE) && (shroomlight = level.getBlockState(pos).is(Blocks.SHROOMLIGHT))) {
            if (!level.isClientSide) {
                level.levelEvent(2001, pos, Block.getId((BlockState)Blocks.SHROOMLIGHT.defaultBlockState()));
            }
            player.playSound(SoundEvents.BOTTLE_FILL);
            ContainerUtils.addWithContainer(player, hand, stack, ((Item)TofuItems.SHROOM_BOTTLE.get()).getDefaultInstance(), true);
            level.removeBlock(pos, false);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onPotionEffectApplied(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.BLINDNESS && EnchantmentHelper.getEnchantmentLevel((Holder)event.getEntity().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(TofuEnchantments.EFFECT_PROTECTION), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.OOZING && EnchantmentHelper.getEnchantmentLevel((Holder)event.getEntity().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(TofuEnchantments.EFFECT_PROTECTION), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.MOVEMENT_SLOWDOWN && EnchantmentHelper.getEnchantmentLevel((Holder)event.getEntity().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(TofuEnchantments.EFFECT_PROTECTION), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.INFESTED && EnchantmentHelper.getEnchantmentLevel((Holder)event.getEntity().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(TofuEnchantments.EFFECT_PROTECTION), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.HUNGER && event.getEntity().hasEffect(TofuEffects.MISO_BOOST)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.CONFUSION && event.getEntity().hasEffect(TofuEffects.MISO_BOOST)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static boolean onBlockStartBreak(BlockEvent.BreakEvent event) {
        PickaxeItem pickaxeItem;
        ItemStack hand = event.getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
        Item item = hand.getItem();
        if (item instanceof PickaxeItem && (pickaxeItem = (PickaxeItem)item).getTier() == TofuItemTier.TOFUDIAMOND) {
            Block blockDestroyed = event.getLevel().getBlockState(event.getPos()).getBlock();
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                TofuDiamondToolUtil.onBlockStartBreak(hand, level, blockDestroyed, event.getPos(), event.getPlayer());
            }
        }
        return false;
    }
}

