/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.data.generator.recipe.builder;

import baguchan.tofucraft.recipe.TFCraftingCategory;
import baguchan.tofucraft.recipe.TFShapelessRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class TFShapelessRecipeBuilder
implements RecipeBuilder {
    private final TFCraftingCategory category;
    private final Item result;
    private final int count;
    private final ItemStack resultStack;
    private final int tf;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;

    public TFShapelessRecipeBuilder(TFCraftingCategory category, ItemLike result, int count, int tf) {
        this(category, new ItemStack(result, count), tf);
    }

    public TFShapelessRecipeBuilder(TFCraftingCategory p_250837_, ItemStack result, int tf) {
        this.category = p_250837_;
        this.result = result.getItem();
        this.count = result.getCount();
        this.resultStack = result;
        this.tf = tf;
    }

    public static TFShapelessRecipeBuilder shapeless(TFCraftingCategory category, ItemLike result) {
        return new TFShapelessRecipeBuilder(category, result, 1, 500);
    }

    public static TFShapelessRecipeBuilder shapeless(TFCraftingCategory category, ItemLike result, int count, int tf) {
        return new TFShapelessRecipeBuilder(category, result, count, tf);
    }

    public static TFShapelessRecipeBuilder shapeless(TFCraftingCategory p_252339_, ItemStack result, int tf) {
        return new TFShapelessRecipeBuilder(p_252339_, result, tf);
    }

    public TFShapelessRecipeBuilder requires(TagKey<Item> tag) {
        return this.requires(Ingredient.of(tag));
    }

    public TFShapelessRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public TFShapelessRecipeBuilder requires(ItemLike item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public TFShapelessRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public TFShapelessRecipeBuilder requires(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public TFShapelessRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public TFShapelessRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancement$builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        TFShapelessRecipe shapelessrecipe = new TFShapelessRecipe(Objects.requireNonNullElse(this.group, ""), this.category, this.resultStack, this.ingredients, this.tf);
        recipeOutput.accept(id, (Recipe)shapelessrecipe, advancement$builder.build(id.withPrefix("recipes/" + this.category.getSerializedName() + "/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

