/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.item;

import baguchan.tofucraft.attachment.TofuLivingAttachment;
import baguchan.tofucraft.registry.TofuAttachments;
import baguchan.tofucraft.registry.TofuEffects;
import baguchan.tofucraft.registry.TofuItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

public class DishItem
extends Item {
    private final boolean comfortable;
    private final boolean salt;

    public DishItem(Item.Properties p_41383_) {
        this(p_41383_, true, false);
    }

    public DishItem(Item.Properties p_41383_, boolean comfortable) {
        this(p_41383_, comfortable, false);
    }

    public DishItem(Item.Properties p_41383_, boolean comfortable, boolean salt) {
        super(p_41383_);
        this.comfortable = comfortable;
        this.salt = salt;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        FoodProperties foodProperties;
        ItemStack resultItem = super.finishUsingItem(itemStack, level, livingEntity);
        if (this.comfortable) {
            Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"comfort"));
            FoodProperties foodProperties2 = this.getFoodProperties(itemStack, livingEntity);
            if (foodProperties2 != null && effect.isPresent()) {
                livingEntity.addEffect(new MobEffectInstance((Holder)effect.get(), 600 * foodProperties2.nutrition()));
            }
        }
        if (this.salt && (foodProperties = this.getFoodProperties(itemStack, livingEntity)) != null) {
            livingEntity.addEffect(new MobEffectInstance(TofuEffects.SALT_BOOST, foodProperties.nutrition() * 20 * 60));
        }
        return resultItem;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        MobEffect effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"comfort"));
        if (effect != null) {
            p_41423_.add((Component)Component.translatable((String)"tofucraft.has_comfort").withStyle(ChatFormatting.GOLD));
        }
        if (p_41421_.is(TofuItems.YUDOFU)) {
            p_41423_.add((Component)Component.translatable((String)"tofucraft.has_soy_wolf_food").withStyle(ChatFormatting.GRAY));
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Wolf wolf;
        if (target instanceof Wolf && (wolf = (Wolf)target).isAlive() && wolf.isTame()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @EventBusSubscriber(modid="tofucraft", bus=EventBusSubscriber.Bus.GAME)
    public static class SoyFoodEvent {
        @SubscribeEvent
        public static void onSoyFoodForWolf(PlayerInteractEvent.EntityInteract event) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                if (target instanceof Wolf) {
                    Wolf wolf = (Wolf)target;
                    if (entity.isAlive() && wolf.isTame() && itemStack.is(TofuItems.YUDOFU)) {
                        if (!((TofuLivingAttachment)wolf.getData(TofuAttachments.TOFU_LIVING)).isWolfEatCooldown()) {
                            entity.heal(1.0f);
                            entity.addEffect(new MobEffectInstance(TofuEffects.SOY_HEALTHY, 3200, 1));
                            ((TofuLivingAttachment)wolf.getData(TofuAttachments.TOFU_LIVING)).setWolfEatCooldown(3200);
                            entity.level().playSound(null, target.blockPosition(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
                            if (itemStack.getCraftingRemainingItem() != ItemStack.EMPTY && !player.isCreative()) {
                                player.addItem(itemStack.getCraftingRemainingItem());
                                itemStack.shrink(1);
                            }
                            event.setCancellationResult(InteractionResult.SUCCESS);
                            event.setCanceled(true);
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"tofucraft.soy_food.cannot_give_on_wolf", (Object[])new Object[]{wolf.getName()}), true);
                            event.setCancellationResult(InteractionResult.FAIL);
                            event.setCanceled(true);
                        }
                    }
                }
            }
        }
    }
}

