/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.item;

import baguchan.tofucraft.api.tfenergy.IEnergyContained;
import baguchan.tofucraft.api.tfenergy.IEnergyInsertable;
import baguchan.tofucraft.api.tfenergy.TFEnergyData;
import baguchan.tofucraft.registry.TofuDataComponents;
import baguchan.tofucraft.registry.TofuItems;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ReflectTofuShieldItem
extends ShieldItem
implements IEnergyInsertable,
IEnergyContained {
    public ReflectTofuShieldItem(Item.Properties p_43089_) {
        super(p_43089_);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
    }

    public boolean isValidRepairItem(ItemStack p_43091_, ItemStack p_43092_) {
        return p_43092_.is((Item)TofuItems.TOFUMETAL.get()) || !p_43092_.is(ItemTags.PLANKS) && super.isValidRepairItem(p_43091_, p_43092_);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return itemAbility == ItemAbilities.SHIELD_BLOCK;
    }

    @Override
    public int fill(ItemStack inst, int energy, boolean simulate) {
        int calculated = Math.min(energy, inst.getDamageValue());
        if (!simulate) {
            if (inst.getDamageValue() > 0) {
                inst.setDamageValue(Mth.clamp((int)(inst.getDamageValue() - calculated), (int)0, (int)inst.getMaxDamage()));
                return calculated * 5;
            }
            int calculated2 = Math.min(energy, this.getEnergyMax(inst) - this.getEnergy(inst));
            this.setEnergy(inst, this.getEnergy(inst) + calculated2);
            return calculated2;
        }
        return 0;
    }

    @Override
    public int getEnergy(ItemStack inst) {
        return inst.get(TofuDataComponents.TF_ENERGY_DATA) != null ? ((TFEnergyData)inst.get(TofuDataComponents.TF_ENERGY_DATA)).storeTF() : 0;
    }

    @Override
    public int getEnergyMax(ItemStack inst) {
        return inst.get(TofuDataComponents.TF_ENERGY_DATA) != null ? ((TFEnergyData)inst.get(TofuDataComponents.TF_ENERGY_DATA)).maxTF() : 5000;
    }

    @Override
    public void setEnergy(ItemStack inst, int amount) {
        inst.set(TofuDataComponents.TF_ENERGY_DATA, (Object)new TFEnergyData(amount, this.getEnergyMax(inst)));
    }

    @Override
    public void setEnergyMax(ItemStack inst, int amount) {
        inst.set(TofuDataComponents.TF_ENERGY_DATA, (Object)new TFEnergyData(this.getEnergy(inst), amount));
    }

    private boolean getShowState(ItemStack stack) {
        return Minecraft.getInstance().player != null && !Minecraft.getInstance().player.isShiftKeyDown() && this.getEnergy(stack) != 0;
    }

    public boolean isBarVisible(ItemStack p_150899_) {
        return this.getShowState(p_150899_) || super.isBarVisible(p_150899_);
    }

    public int getDamage(ItemStack stack) {
        return super.getDamage(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getShowState(stack) ? Math.round((float)this.getEnergy(stack) / (float)this.getEnergyMax(stack) * 13.0f) : super.getBarWidth(stack);
    }

    public int getBarColor(ItemStack p_150901_) {
        return this.getShowState(p_150901_) ? Color.white.getRGB() : super.getBarColor(p_150901_);
    }

    public void appendHoverText(ItemStack p_43094_, Item.TooltipContext p_339613_, List<Component> p_43096_, TooltipFlag p_43097_) {
        super.appendHoverText(p_43094_, p_339613_, p_43096_, p_43097_);
        p_43096_.add((Component)Component.translatable((String)"tooltip.tofucraft.energy", (Object[])new Object[]{this.getEnergy(p_43094_), this.getEnergyMax(p_43094_)}));
    }
}

