/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.item;

import baguchan.tofucraft.attachment.SoyHealthAttachment;
import baguchan.tofucraft.registry.TofuAttachments;
import baguchan.tofucraft.registry.TofuEffects;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SoymilkBottleItem
extends Item {
    private final Holder<MobEffect> effect;
    private final Holder<MobEffect> secondEffect;

    public SoymilkBottleItem(Holder<MobEffect> effect, Holder<MobEffect> secondEffect, Item.Properties properties) {
        super(properties);
        this.effect = effect;
        this.secondEffect = secondEffect;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        super.finishUsingItem(stack, level, livingEntity);
        SoyHealthAttachment cap = (SoyHealthAttachment)livingEntity.getData(TofuAttachments.SOY_HEALTH);
        if (!level.isClientSide) {
            if (level.getGameTime() > cap.getRemainTick() + 12000L) {
                cap.setSoyHealthLevel(livingEntity, cap.getSoyHealthLevel() + 1, true);
                if (cap.getSoyHealthLevel() > 4) {
                    livingEntity.addEffect(new MobEffectInstance(this.getSecondEffect(), 24000, 0));
                }
                cap.setSoyHealthBaseLevel(1 + cap.getSoyHealthBaseLevel());
            }
            livingEntity.addEffect(new MobEffectInstance(TofuEffects.SOY_HEALTHY, 600 + 200 * cap.getSoyHealthLevel() + cap.getSoyHealthBaseLevel() * 40, 0));
            livingEntity.addEffect(new MobEffectInstance(this.getEffect(), 200 * cap.getSoyHealthLevel() + cap.getSoyHealthBaseLevel() * 40, 0));
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayerentity, stack);
            serverplayerentity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (stack.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (!(livingEntity instanceof Player) || !((Player)livingEntity).getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (livingEntity instanceof Player && !((Player)livingEntity).getAbilities().instabuild) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            Player playerentity = (Player)livingEntity;
            if (!playerentity.getInventory().add(itemstack)) {
                playerentity.drop(itemstack, false);
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack p_41452_) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, components, flag);
        components.add((Component)((MobEffect)this.getEffect().value()).getDisplayName().copy().withStyle(ChatFormatting.BLUE));
    }

    public Holder<MobEffect> getEffect() {
        return this.effect;
    }

    public Holder<MobEffect> getSecondEffect() {
        return this.secondEffect;
    }
}

