/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.network;

import baguchan.tofucraft.client.TofuClientEvents;
import baguchan.tofucraft.network.GuiHooks;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class BossInfoPacket
implements CustomPacketPayload {
    protected final UUID bossEvent;
    protected final int entityID;

    public BossInfoPacket(UUID bossEvent, int entityID) {
        this.bossEvent = bossEvent;
        this.entityID = entityID;
    }

    public UUID getBossEvent() {
        return this.bossEvent;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public static class Remove
    extends BossInfoPacket {
        public static final CustomPacketPayload.Type<Remove> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"remove_custom_bossbar"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Remove> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, BossInfoPacket::getBossEvent, (StreamCodec)ByteBufCodecs.INT, BossInfoPacket::getEntityID, Remove::new);

        public Remove(UUID bossEvent, int entityID) {
            super(bossEvent, entityID);
        }

        public CustomPacketPayload.Type<Remove> type() {
            return TYPE;
        }

        public static void execute(Remove payload, IPayloadContext context) {
            Entity entity;
            GuiHooks.BOSS_EVENTS.remove(payload.bossEvent);
            if (Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().level.getEntity(payload.entityID)) instanceof Mob) {
                Mob mob = (Mob)entity;
                TofuClientEvents.removeBossBar(payload.bossEvent, mob);
            }
        }
    }

    public static class Display
    extends BossInfoPacket {
        public static final CustomPacketPayload.Type<Display> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"add_custom_bossbar"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Display> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, BossInfoPacket::getBossEvent, (StreamCodec)ByteBufCodecs.INT, BossInfoPacket::getEntityID, Display::new);

        public Display(UUID bossEvent, int entityID) {
            super(bossEvent, entityID);
        }

        public CustomPacketPayload.Type<Display> type() {
            return TYPE;
        }

        public static void execute(Display payload, IPayloadContext context) {
            Entity entity;
            GuiHooks.BOSS_EVENTS.put(payload.bossEvent, payload.entityID);
            if (Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().level.getEntity(payload.entityID)) instanceof Mob) {
                Mob mob = (Mob)entity;
                TofuClientEvents.addBossBar(payload.bossEvent, mob);
            }
        }
    }
}

