/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.recipe;

import baguchan.tofucraft.registry.TofuRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class BitternRecipe
implements Recipe<RecipeInput> {
    protected FluidStack fluid;
    protected FluidStack extraFluid;
    final ItemStack result;

    public BitternRecipe(FluidStack fluid, FluidStack extraFluid, ItemStack results) {
        this.fluid = fluid;
        this.extraFluid = extraFluid;
        this.result = results;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public FluidStack getExtraFluid() {
        return this.extraFluid;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        ItemStack stack = recipeInput.getItem(0);
        ItemStack stack2 = recipeInput.getItem(1);
        @Nullable IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        @Nullable IFluidHandlerItem fluidHandler2 = (IFluidHandlerItem)stack2.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null && fluidHandler2 != null) {
            return fluidHandler.isFluidValid(1000, this.fluid) && fluidHandler2.isFluidValid(250, this.extraFluid);
        }
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.getResultItem(provider).copy();
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return p_43999_ > 0 && p_44000_ > 0;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return this.result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return TofuRecipes.RECIPE_BITTERN.get();
    }

    public RecipeType<?> getType() {
        return TofuRecipes.RECIPETYPE_BITTERN.get();
    }
}

