/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.world.gen.placement;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.world.gen.features.ModNetherFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModNetherPlacements {
    public static final PlacementModifier NETHER_SOYBEAN_HEIGHT = HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.belowTop((int)-20));
    public static final ResourceKey<PlacedFeature> PATCH_NETHER_SOYBEAN_NORMAL = ModNetherPlacements.registerKey("patch_nether_soybean");
    public static final ResourceKey<PlacedFeature> PATCH_NETHER_SOYBEAN_CRIMSON = ModNetherPlacements.registerKey("patch_nether_soybean_crimson");
    public static final ResourceKey<PlacedFeature> PATCH_SOUL_SOYBEAN = ModNetherPlacements.registerKey("patch_soul_soybean");

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)TofuCraftReload.prefix(name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeature = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, PATCH_NETHER_SOYBEAN_NORMAL, (Holder)configuredFeature.getOrThrow(ModNetherFeatures.NETHER_SOYBEAN), List.of(RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), NETHER_SOYBEAN_HEIGHT, BiomeFilter.biome()));
        PlacementUtils.register(context, PATCH_NETHER_SOYBEAN_CRIMSON, (Holder)configuredFeature.getOrThrow(ModNetherFeatures.NETHER_SOYBEAN), List.of(RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), NETHER_SOYBEAN_HEIGHT, BiomeFilter.biome()));
        PlacementUtils.register(context, PATCH_SOUL_SOYBEAN, (Holder)configuredFeature.getOrThrow(ModNetherFeatures.SOUL_SOYBEAN), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), NETHER_SOYBEAN_HEIGHT, BiomeFilter.biome()));
    }
}

