/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import baguchan.tofucraft.blockentity.TofuPotBlockEntity;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;

public class TofuPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TofuPotBlock> CODEC = TofuPotBlock.simpleCodec(TofuPotBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public TofuPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack;
        IFluidHandlerItem handler;
        boolean flag = false;
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof TofuPotBlockEntity && (handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)(stack = player.getItemInHand(hand)).copyWithCount(1)).orElse(null)) instanceof FluidBucketWrapper) {
            FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, null);
            return ItemInteractionResult.SUCCESS;
        }
        if (!level.isClientSide) {
            if (tileEntity instanceof TofuPotBlockEntity) {
                TofuPotBlockEntity cookingPotEntity = (TofuPotBlockEntity)tileEntity;
                player.openMenu((MenuProvider)cookingPotEntity, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluid = level.getFluidState(context.getClickedPos());
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        return state;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        Optional cookingPot = level.getBlockEntity(pos, TofuBlockEntitys.TOFU_POT.get());
        if (cookingPot.isPresent()) {
            stack = ((TofuPotBlockEntity)((Object)cookingPot.get())).getAsItem();
        }
        return stack;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof TofuPotBlockEntity) {
                TofuPotBlockEntity cookingPotEntity = (TofuPotBlockEntity)tileEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, cookingPotEntity.inventory);
                cookingPotEntity.getUsedRecipesAndPopExperience(level, Vec3.atCenterOf((Vec3i)pos));
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        TofuPotBlockEntity cookingPotEntity;
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof TofuPotBlockEntity && (cookingPotEntity = (TofuPotBlockEntity)tileEntity).isHeated()) {
            SoundEvent boilSound = !cookingPotEntity.getItem(12).isEmpty() ? SoundEvents.LAVA_POP : SoundEvents.BUBBLE_COLUMN_BUBBLE_POP;
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            if (random.nextInt(10) == 0) {
                level.playLocalSound(x, y, z, boilSound, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return TofuBlockEntitys.TOFU_POT.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide) {
            return TofuPotBlock.createTickerHelper(blockEntity, TofuBlockEntitys.TOFU_POT.get(), TofuPotBlockEntity::animationTick);
        }
        return TofuPotBlock.createTickerHelper(blockEntity, TofuBlockEntitys.TOFU_POT.get(), TofuPotBlockEntity::cookingTick);
    }
}

