/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.screen;

import baguchan.tofucraft.blockentity.tfenergy.TFStorageBlockEntity;
import baguchan.tofucraft.client.ClientProxy;
import baguchan.tofucraft.inventory.TFStorageMenu;
import baguchan.tofucraft.registry.TofuFluids;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

@OnlyIn(value=Dist.CLIENT)
public class TFStorageScreen
extends AbstractContainerScreen<TFStorageMenu> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/tf_storage.png");
    private static final Component MISSING_ITEM_TOOLTIP = Component.translatable((String)"container.tofucraft.tf_storage.missing_item_tooltip_consume");
    private static final Component MISSING_ITEM_TOOLTIP_2 = Component.translatable((String)"container.tofucraft.tf_storage.missing_item_tooltip_repair");

    public TFStorageScreen(TFStorageMenu p_i51104_1_, Inventory p_i51104_3_, Component p_i51104_4_) {
        super((AbstractContainerMenu)p_i51104_1_, p_i51104_3_, p_i51104_4_);
    }

    public void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(GuiGraphics p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        super.render(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.renderTooltip(p_230430_1_, p_230430_2_, p_230430_3_);
        this.renderOnboardingTooltips(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    protected void renderBg(GuiGraphics p_230450_1_, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        FluidTank fluidTank;
        int heightInd;
        int i = this.leftPos;
        int j = this.topPos;
        p_230450_1_.blit(texture, i, j, 0, 0, this.imageWidth, this.imageHeight);
        if (ClientProxy.PROXY.getRefrencedTE() instanceof TFStorageBlockEntity && ((TFStorageBlockEntity)ClientProxy.PROXY.getRefrencedTE()).getTank().getFluid() != null && (heightInd = (int)(44.0f * (float)(fluidTank = ((TFStorageBlockEntity)ClientProxy.PROXY.getRefrencedTE()).getTank()).getFluidAmount() / (float)fluidTank.getCapacity())) > 0) {
            TFStorageScreen.renderFluidStack(i + 145, j + 69 - heightInd, 10, heightInd, 0.0f, fluidTank.getFluid());
        }
        p_230450_1_.pose().pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidStack fluidTank2 = new FluidStack((Fluid)TofuFluids.SOYMILK_FLOW.get(), 1000);
        int heightInd2 = (int)(44.0f * (float)((TFStorageMenu)this.menu).getTFEnergy() / (float)((TFStorageMenu)this.menu).getTFMaxEnergy());
        if (heightInd2 > 0) {
            TFStorageScreen.renderFluidStack(i + 76, j + 69 - heightInd2, 10, heightInd2, 0.0f, fluidTank2);
        }
        p_230450_1_.pose().popPose();
    }

    public static void renderFluidStack(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(props.getStillTexture());
        int col = props.getTintColor(fluidStack);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float u1 = sprite.getU0();
        float v1 = sprite.getV0();
        float u2 = sprite.getU1();
        float v2 = sprite.getV1();
        do {
            int currentHeight = Math.min(sprite.getX(), height);
            height -= currentHeight;
            int x2 = x;
            int width2 = width;
            do {
                int currentWidth = Math.min(sprite.getY(), width2);
                width2 -= currentWidth;
                bufferbuilder.addVertex((float)x2, (float)y, depth).setUv(u1, v1).setColor(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255);
                bufferbuilder.addVertex((float)x2, (float)(y + currentHeight), depth).setUv(u1, v2).setColor(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255);
                bufferbuilder.addVertex((float)(x2 + currentWidth), (float)(y + currentHeight), depth).setUv(u2, v2).setColor(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255);
                bufferbuilder.addVertex((float)(x2 + currentWidth), (float)y, depth).setUv(u2, v1).setColor(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                x2 += currentWidth;
            } while (width2 > 0);
            y += currentHeight;
        } while (height > 0);
        bufferbuilder.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    private void renderOnboardingTooltips(GuiGraphics p_281668_, int p_267192_, int p_266859_) {
        Optional<Component> optional = Optional.empty();
        if (this.hoveredSlot != null) {
            ItemStack itemstack = ((TFStorageMenu)this.menu).getSlot(0).getItem();
            if (itemstack.isEmpty() && this.hoveredSlot.index == 0) {
                optional = Optional.of(MISSING_ITEM_TOOLTIP);
            }
            if (itemstack.isEmpty() && this.hoveredSlot.index == 1) {
                optional = Optional.of(MISSING_ITEM_TOOLTIP_2);
            }
        }
        optional.ifPresent(p_280863_ -> p_281668_.renderTooltip(this.font, this.font.split((FormattedText)p_280863_, 115), p_267192_, p_266859_));
    }
}

