/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.data.generator;

import baguchan.tofucraft.block.CandleTofuCakeBlock;
import baguchan.tofucraft.block.TofuCakeBlock;
import baguchan.tofucraft.registry.TofuBlocks;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockstateGenerator
extends BlockStateProvider {
    private Supplier<CandleTofuCakeBlock> block;

    public BlockstateGenerator(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "tofucraft", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)TofuBlocks.KINUTOFU.get());
        this.simpleBlock((Block)TofuBlocks.MOMENTOFU.get());
        this.simpleBlock((Block)TofuBlocks.ISHITOFU.get());
        this.simpleBlock((Block)TofuBlocks.WAXED_KINUTOFU.get(), this.cubeAll((Block)TofuBlocks.KINUTOFU.get()));
        this.simpleBlock((Block)TofuBlocks.WAXED_MOMENTOFU.get(), this.cubeAll((Block)TofuBlocks.MOMENTOFU.get()));
        this.simpleBlock((Block)TofuBlocks.WAXED_ISHITOFU.get(), this.cubeAll((Block)TofuBlocks.ISHITOFU.get()));
        this.simpleBlock((Block)TofuBlocks.ISHITOFU_BRICK.get());
        this.simpleBlock((Block)TofuBlocks.ISHITOFU_SMOOTH_BRICK.get());
        this.simpleBlock((Block)TofuBlocks.ISHITOFU_CHISELED_BRICK.get());
        this.simpleBlock((Block)TofuBlocks.METALTOFU.get());
        this.cutBlock((Supplier<? extends Block>)TofuBlocks.METAL_TOFU_GRATE);
        this.simpleBlock((Supplier<Block>)TofuBlocks.METAL_TOFU_LUMP);
        this.simpleBlock((Block)TofuBlocks.DIAMONDTOFU.get());
        this.simpleBlock((Block)TofuBlocks.TOFU_GEM_BLOCK.get());
        this.simpleBlock((Block)TofuBlocks.ADVANCE_TOFU_GEM_BLOCK.get());
        this.logBlock((RotatedPillarBlock)TofuBlocks.GRILLEDTOFU.get());
        this.simpleBlock((Block)TofuBlocks.ZUNDATOFU.get());
        this.simpleBlock((Block)TofuBlocks.ZUNDATOFU_BRICK.get());
        this.simpleBlock((Block)TofuBlocks.ZUNDATOFU_SMOOTH_BRICK.get());
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_ZUNDABRICK, (Supplier<Block>)TofuBlocks.ZUNDATOFU_BRICK);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_ZUNDABRICK, (Supplier<Block>)TofuBlocks.ZUNDATOFU_BRICK);
        this.simpleBlock((Block)TofuBlocks.MISOTOFU.get());
        this.simpleBlock((Block)TofuBlocks.DRIEDTOFU.get());
        this.simpleBlock((Supplier<Block>)TofuBlocks.EGGTOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_EGG, (Supplier<Block>)TofuBlocks.EGGTOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_EGG, (Supplier<Block>)TofuBlocks.EGGTOFU);
        this.simpleBlock((Supplier<Block>)TofuBlocks.SESAMETOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_SESAME, (Supplier<Block>)TofuBlocks.SESAMETOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_SESAME, (Supplier<Block>)TofuBlocks.SESAMETOFU);
        this.simpleBlock((Block)TofuBlocks.EGGTOFU_BRICK.get());
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_EGGBRICK, (Supplier<Block>)TofuBlocks.EGGTOFU_BRICK);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_EGGBRICK, (Supplier<Block>)TofuBlocks.EGGTOFU_BRICK);
        this.simpleBlock((Block)TofuBlocks.HELLTOFU.get());
        this.simpleBlock((Block)TofuBlocks.HELLTOFU_BRICK.get());
        this.simpleBlock((Block)TofuBlocks.HELLTOFU_SMOOTH_BRICK.get());
        this.simpleBlock((Block)TofuBlocks.SOULTOFU.get());
        this.simpleBlock((Block)TofuBlocks.SOULTOFU_BRICK.get());
        this.simpleBlock((Block)TofuBlocks.SOULTOFU_SMOOTH_BRICK.get());
        this.simpleBlock((Block)TofuBlocks.MINCEDTOFU.get());
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_KINU, (Supplier<Block>)TofuBlocks.KINUTOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_MOMEN, (Supplier<Block>)TofuBlocks.MOMENTOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_ISHI, (Supplier<Block>)TofuBlocks.ISHITOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_METAL, (Supplier<Block>)TofuBlocks.METALTOFU);
        this.stairsBlock((StairBlock)TofuBlocks.TOFUSTAIR_GRILLED.get(), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.MOMENTOFU)), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.GRILLEDTOFU) + "_top"), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.GRILLEDTOFU) + "_top"));
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_ZUNDA, (Supplier<Block>)TofuBlocks.ZUNDATOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_HELL, (Supplier<Block>)TofuBlocks.HELLTOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_SOUL, (Supplier<Block>)TofuBlocks.SOULTOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_ISHIBRICK, (Supplier<Block>)TofuBlocks.ISHITOFU_BRICK);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_HELLBRICK, (Supplier<Block>)TofuBlocks.HELLTOFU_BRICK);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_SOULBRICK, (Supplier<Block>)TofuBlocks.SOULTOFU_BRICK);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_MISO, (Supplier<Block>)TofuBlocks.MISOTOFU);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFUSTAIR_DRIED, (Supplier<Block>)TofuBlocks.DRIEDTOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_KINU, (Supplier<Block>)TofuBlocks.KINUTOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_MOMEN, (Supplier<Block>)TofuBlocks.MOMENTOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_ISHI, (Supplier<Block>)TofuBlocks.ISHITOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_METAL, (Supplier<Block>)TofuBlocks.METALTOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_GRILLED, this.texture(this.name((Supplier<? extends Block>)TofuBlocks.MOMENTOFU)), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.GRILLEDTOFU) + "_top"), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.GRILLEDTOFU) + "_top"));
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_ZUNDA, (Supplier<Block>)TofuBlocks.ZUNDATOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_HELL, (Supplier<Block>)TofuBlocks.HELLTOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_SOUL, (Supplier<Block>)TofuBlocks.SOULTOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_ISHIBRICK, (Supplier<Block>)TofuBlocks.ISHITOFU_BRICK);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_HELLBRICK, (Supplier<Block>)TofuBlocks.HELLTOFU_BRICK);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_SOULBRICK, (Supplier<Block>)TofuBlocks.SOULTOFU_BRICK);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_MISO, (Supplier<Block>)TofuBlocks.MISOTOFU);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFUSLAB_DRIED, (Supplier<Block>)TofuBlocks.DRIEDTOFU);
        this.wall((Supplier<? extends WallBlock>)TofuBlocks.TOFUFENCE_KINU, (Supplier<? extends Block>)TofuBlocks.KINUTOFU);
        this.wall((Supplier<? extends WallBlock>)TofuBlocks.TOFUFENCE_MOMEN, (Supplier<? extends Block>)TofuBlocks.MOMENTOFU);
        this.wall((Supplier<? extends WallBlock>)TofuBlocks.TOFUFENCE_ISHI, (Supplier<? extends Block>)TofuBlocks.ISHITOFU);
        this.wall((Supplier<? extends WallBlock>)TofuBlocks.TOFUFENCE_METAL, (Supplier<? extends Block>)TofuBlocks.METALTOFU);
        this.wall((Supplier<? extends WallBlock>)TofuBlocks.TOFUFENCE_HELL, (Supplier<? extends Block>)TofuBlocks.HELLTOFU);
        this.wall((Supplier<? extends WallBlock>)TofuBlocks.TOFUFENCE_SOUL, (Supplier<? extends Block>)TofuBlocks.SOULTOFU);
        this.wallBlock((WallBlock)TofuBlocks.TOFUFENCE_GRILLED.get(), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.GRILLEDTOFU) + "_top"));
        this.wall((Supplier<? extends WallBlock>)TofuBlocks.TOFUFENCE_ZUNDA, (Supplier<? extends Block>)TofuBlocks.ZUNDATOFU);
        this.ancientFormatDoor((Supplier<? extends DoorBlock>)TofuBlocks.TOFUDOOR_KINU, "kinu");
        this.ancientFormatDoor((Supplier<? extends DoorBlock>)TofuBlocks.TOFUDOOR_MOMEN, "momen");
        this.ancientFormatDoor((Supplier<? extends DoorBlock>)TofuBlocks.TOFUDOOR_ISHI, "ishi");
        this.ancientFormatDoor((Supplier<? extends DoorBlock>)TofuBlocks.TOFUDOOR_METAL, "metal");
        this.ancientFormatDoor((Supplier<? extends DoorBlock>)TofuBlocks.TOFUDOOR_HELL, "hell");
        this.ancientFormatDoor((Supplier<? extends DoorBlock>)TofuBlocks.TOFUDOOR_SOUL, "soul");
        this.ancientFormatDoor((Supplier<? extends DoorBlock>)TofuBlocks.TOFUDOOR_GRILLED, "grilled");
        this.ancientFormatDoor((Supplier<? extends DoorBlock>)TofuBlocks.TOFUDOOR_ZUNDA, "zunda");
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFUTRAPDOOR_KINU);
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFUTRAPDOOR_MOMEN);
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFUTRAPDOOR_ISHI);
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFUTRAPDOOR_METAL);
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFUTRAPDOOR_HELL);
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFUTRAPDOOR_SOUL);
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFUTRAPDOOR_GRILLED);
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFUTRAPDOOR_ZUNDA);
        this.torchBlock((Supplier<Block>)TofuBlocks.TOFUTORCH_KINU, (Supplier<Block>)TofuBlocks.WALLTOFUTORCH_KINU);
        this.torchBlock((Supplier<Block>)TofuBlocks.TOFUTORCH_MOMEN, (Supplier<Block>)TofuBlocks.WALLTOFUTORCH_MOMEN);
        this.torchBlock((Supplier<Block>)TofuBlocks.TOFUTORCH_ISHI, (Supplier<Block>)TofuBlocks.WALLTOFUTORCH_ISHI);
        this.torchBlock((Supplier<Block>)TofuBlocks.TOFUTORCH_METAL, (Supplier<Block>)TofuBlocks.WALLTOFUTORCH_METAL);
        this.torchBlock((Supplier<Block>)TofuBlocks.TOFUTORCH_GRILLED, (Supplier<Block>)TofuBlocks.WALLTOFUTORCH_GRILLED);
        this.torchBlock((Supplier<Block>)TofuBlocks.TOFUTORCH_ZUNDA, (Supplier<Block>)TofuBlocks.WALLTOFUTORCH_ZUNDA);
        this.torchBlock((Supplier<Block>)TofuBlocks.TOFUTORCH_HELL, (Supplier<Block>)TofuBlocks.WALLTOFUTORCH_HELL);
        this.torchBlock((Supplier<Block>)TofuBlocks.TOFUTORCH_SOUL, (Supplier<Block>)TofuBlocks.WALLTOFUTORCH_SOUL);
        this.simpleBlock((Supplier<Block>)TofuBlocks.TOFU_TERRAIN);
        this.make2LayerCubeAllSidesSame((Block)TofuBlocks.MABOU_TERRAIN.get(), (Block)TofuBlocks.TOFU_TERRAIN.get(), ResourceLocation.withDefaultNamespace((String)"cutout"), 0, 15, false);
        this.simpleBlock((Supplier<Block>)TofuBlocks.TOFUSLATE);
        this.simpleBlock((Supplier<Block>)TofuBlocks.TOFUSLATE_TOFU_DIAMOND_ORE);
        this.simpleBlock((Supplier<Block>)TofuBlocks.ORE_TOFU_DIAMOND);
        this.simpleBlock((Supplier<Block>)TofuBlocks.ORE_TOFUGEM);
        this.simpleBlock((Supplier<Block>)TofuBlocks.TOFU_BEDROCK);
        this.logBlock((RotatedPillarBlock)TofuBlocks.LEEK_GREEN_STEM.get());
        this.simpleBlock((Supplier<Block>)TofuBlocks.LEEK_GREEN_PLANKS);
        this.stairs((Supplier<StairBlock>)TofuBlocks.LEEK_GREEN_PLANKS_STAIR, (Supplier<Block>)TofuBlocks.LEEK_GREEN_PLANKS);
        this.slab((Supplier<SlabBlock>)TofuBlocks.LEEK_GREEN_PLANKS_SLAB, (Supplier<Block>)TofuBlocks.LEEK_GREEN_PLANKS);
        this.fenceBlock((FenceBlock)TofuBlocks.LEEK_GREEN_FENCE.get(), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_PLANKS)));
        this.fenceGateBlock((FenceGateBlock)TofuBlocks.LEEK_GREEN_FENCE_GATE.get(), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_PLANKS)));
        this.door((Supplier<? extends DoorBlock>)TofuBlocks.LEEK_GREEN_DOOR, "leek_green");
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.LEEK_GREEN_TRAPDOOR);
        this.pressurePlate((Supplier<? extends PressurePlateBlock>)TofuBlocks.LEEK_GREEN_PRESSURE_PLATE, (Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_PLANKS);
        this.button((Supplier<? extends ButtonBlock>)TofuBlocks.LEEK_GREEN_BUTTON, (Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_PLANKS);
        this.logBlock((RotatedPillarBlock)TofuBlocks.LEEK_STEM.get());
        this.simpleBlock((Supplier<Block>)TofuBlocks.LEEK_PLANKS);
        this.stairs((Supplier<StairBlock>)TofuBlocks.LEEK_PLANKS_STAIR, (Supplier<Block>)TofuBlocks.LEEK_PLANKS);
        this.slab((Supplier<SlabBlock>)TofuBlocks.LEEK_PLANKS_SLAB, (Supplier<Block>)TofuBlocks.LEEK_PLANKS);
        this.fenceBlock((FenceBlock)TofuBlocks.LEEK_FENCE.get(), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.LEEK_PLANKS)));
        this.fenceGateBlock((FenceGateBlock)TofuBlocks.LEEK_FENCE_GATE.get(), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.LEEK_PLANKS)));
        this.pressurePlate((Supplier<? extends PressurePlateBlock>)TofuBlocks.LEEK_PRESSURE_PLATE, (Supplier<? extends Block>)TofuBlocks.LEEK_PLANKS);
        this.button((Supplier<? extends ButtonBlock>)TofuBlocks.LEEK_BUTTON, (Supplier<? extends Block>)TofuBlocks.LEEK_PLANKS);
        this.crossBlock((Supplier<Block>)TofuBlocks.ZUNDATOFU_MUSHROOM);
        this.simpleBlock((Block)TofuBlocks.ZUNDA_MUSHROOM_BLOCK.get());
        this.make2LayerLogSidesSame((RotatedPillarBlock)TofuBlocks.TOFU_STEM.get(), ResourceLocation.withDefaultNamespace((String)"cutout"), 0, 15, false);
        this.simpleBlock((Supplier<Block>)TofuBlocks.TOFU_STEM_PLANKS);
        this.stairs((Supplier<StairBlock>)TofuBlocks.TOFU_STEM_PLANKS_STAIR, (Supplier<Block>)TofuBlocks.TOFU_STEM_PLANKS);
        this.slab((Supplier<SlabBlock>)TofuBlocks.TOFU_STEM_PLANKS_SLAB, (Supplier<Block>)TofuBlocks.TOFU_STEM_PLANKS);
        this.fenceBlock((FenceBlock)TofuBlocks.TOFU_STEM_FENCE.get(), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.TOFU_STEM_PLANKS)));
        this.fenceGateBlock((FenceGateBlock)TofuBlocks.TOFU_STEM_FENCE_GATE.get(), this.texture(this.name((Supplier<? extends Block>)TofuBlocks.TOFU_STEM_PLANKS)));
        this.door((Supplier<? extends DoorBlock>)TofuBlocks.TOFU_STEM_DOOR, "tofustem");
        this.trapdoor((Supplier<? extends TrapDoorBlock>)TofuBlocks.TOFU_STEM_TRAPDOOR);
        this.pressurePlate((Supplier<? extends PressurePlateBlock>)TofuBlocks.TOFU_STEM_PRESSURE_PLATE, (Supplier<? extends Block>)TofuBlocks.TOFU_STEM_PLANKS);
        this.button((Supplier<? extends ButtonBlock>)TofuBlocks.TOFU_STEM_BUTTON, (Supplier<? extends Block>)TofuBlocks.TOFU_STEM_PLANKS);
        this.sign((Supplier<? extends StandingSignBlock>)TofuBlocks.TOFU_STEM_SIGN, (Supplier<? extends WallSignBlock>)TofuBlocks.TOFU_STEM_WALL_SIGN, "tofustem_planks");
        this.sign((Supplier<? extends StandingSignBlock>)TofuBlocks.LEEK_GREEN_SIGN, (Supplier<? extends WallSignBlock>)TofuBlocks.LEEK_GREEN_WALL_SIGN, "leek_green_planks");
        this.sign((Supplier<? extends StandingSignBlock>)TofuBlocks.LEEK_SIGN, (Supplier<? extends WallSignBlock>)TofuBlocks.LEEK_WALL_SIGN, "leek_planks");
        this.hangingSign((Supplier<? extends CeilingHangingSignBlock>)TofuBlocks.TOFU_STEM_HANGING_SIGN, (Supplier<? extends WallHangingSignBlock>)TofuBlocks.TOFU_STEM_WALL_HANGING_SIGN, "tofustem");
        this.hangingSign((Supplier<? extends CeilingHangingSignBlock>)TofuBlocks.LEEK_GREEN_HANGING_SIGN, (Supplier<? extends WallHangingSignBlock>)TofuBlocks.LEEK_GREEN_WALL_HANGING_SIGN, "leek_green_stem");
        this.hangingSign((Supplier<? extends CeilingHangingSignBlock>)TofuBlocks.LEEK_HANGING_SIGN, (Supplier<? extends WallHangingSignBlock>)TofuBlocks.LEEK_WALL_HANGING_SIGN, "leek_stem");
        this.crossBlock((Supplier<Block>)TofuBlocks.SAPLING_TOFU);
        this.simpleLeavesBlock((Supplier<Block>)TofuBlocks.LEAVES_TOFU);
        this.crossBlock((Supplier<Block>)TofuBlocks.SAPLING_APRICOT);
        this.simpleLeavesBlock((Supplier<Block>)TofuBlocks.LEAVES_APRICOT);
        this.crossBlock((Supplier<Block>)TofuBlocks.TOFU_FLOWER);
        this.crossBlock((Supplier<Block>)TofuBlocks.LEEK);
        this.cake((Supplier<Block>)TofuBlocks.TOFUCAKE, "tofucake");
        this.cake((Supplier<Block>)TofuBlocks.ZUNDATOFUCAKE, "zundatofucake");
        this.cake((Supplier<Block>)TofuBlocks.SOYCHEESE_TART, "soycheese_tart");
        CandleTofuCakeBlock.getCandleCakes().forEach(block -> this.candleCake(() -> (CandleTofuCakeBlock)((Object)block)));
        this.carpet((Supplier<Block>)TofuBlocks.YUBA);
        this.simpleBlock((Supplier<Block>)TofuBlocks.SUSPICIOUS_TOFU_TERRAIN);
        this.chainBlock((Supplier<Block>)TofuBlocks.TOFU_METAL_CHAIN);
        this.lantern((Supplier<Block>)TofuBlocks.TOFU_METAL_LANTERN);
        this.lantern((Supplier<Block>)TofuBlocks.TOFU_METAL_SOUL_LANTERN);
        this.translucentBlock((Supplier<? extends Block>)TofuBlocks.ZUNDAMA_BLOCK);
        this.crossBlock((Supplier<Block>)TofuBlocks.ANTENNA_BASIC);
        this.simpleBlock((Supplier<Block>)TofuBlocks.TF_COLLECTOR);
        this.simpleBlock((Supplier<Block>)TofuBlocks.SALT_BLOCK);
    }

    public void button(Supplier<? extends ButtonBlock> block, Supplier<? extends Block> fullBlock) {
        this.buttonBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void pressurePlate(Supplier<? extends PressurePlateBlock> block, Supplier<? extends Block> fullBlock) {
        this.pressurePlateBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void simpleBlock(Supplier<Block> block) {
        this.simpleBlock(block.get(), this.cubeAll(block.get()));
    }

    public void chainBlock(Supplier<Block> block) {
        ModelBuilder cross = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "tofucraft:block/chain")).texture("all", this.blockTexture(block.get()))).renderType("minecraft:cutout");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block.get()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)cross).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)cross).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)cross).rotationX(90).rotationY(90).addModel();
    }

    public void sign(Supplier<? extends StandingSignBlock> standingBlock, Supplier<? extends WallSignBlock> wallBlock, String name) {
        this.signBlock(standingBlock.get(), wallBlock.get(), this.modLoc("block/" + name));
    }

    public void hangingSign(Supplier<? extends CeilingHangingSignBlock> standingBlock, Supplier<? extends WallHangingSignBlock> wallBlock, String name) {
        ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder(this.name(standingBlock))).texture("particle", this.modLoc("block/" + name));
        this.simpleBlock((Block)standingBlock.get(), (ModelFile)model);
        this.simpleBlock((Block)wallBlock.get(), (ModelFile)model);
    }

    public void lantern(Supplier<Block> block) {
        ModelBuilder nonHanging = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "block/template_lantern")).renderType("minecraft:cutout")).texture("lantern", this.blockTexture(block.get()));
        ModelBuilder hanging = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_hanging", "block/template_hanging_lantern")).renderType("minecraft:cutout")).texture("lantern", this.blockTexture(block.get()));
        this.getVariantBuilder(block.get()).forAllStates(arg_0 -> BlockstateGenerator.lambda$lantern$2((ModelFile)hanging, (ModelFile)nonHanging, arg_0));
    }

    public void carpet(Supplier<Block> block) {
        ModelBuilder carpet = ((BlockModelBuilder)this.models().withExistingParent(this.name(block), "block/carpet")).texture("wool", this.blockTexture(block.get()));
        this.carpetBlock(block, arg_0 -> BlockstateGenerator.lambda$carpet$3((ModelFile)carpet, arg_0));
    }

    public void carpetBlock(Supplier<Block> block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).build());
    }

    public void candleCake(Supplier<CandleTofuCakeBlock> block) {
        Block candle = block.get().getCandle();
        Block cake = block.get().getCake();
        ModelBuilder candleCake = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "block/template_cake_with_candle")).texture("candle", this.blockTexture(candle))).texture("bottom", this.suffix(this.blockTexture(cake), "_bottom"))).texture("side", this.suffix(this.blockTexture(cake), "_side"))).texture("top", this.suffix(this.blockTexture(cake), "_top"))).texture("particle", this.suffix(this.blockTexture(cake), "_side"));
        ModelBuilder candleCakeLit = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_lit", "block/template_cake_with_candle")).texture("candle", this.suffix(this.blockTexture(candle), "_lit"))).texture("bottom", this.suffix(this.blockTexture(cake), "_bottom"))).texture("side", this.suffix(this.blockTexture(cake), "_side"))).texture("top", this.suffix(this.blockTexture(cake), "_top"))).texture("particle", this.suffix(this.blockTexture(cake), "_side"));
        this.candleCakeBlock(block, arg_0 -> BlockstateGenerator.lambda$candleCake$5((ModelFile)candleCakeLit, (ModelFile)candleCake, arg_0));
    }

    public void candleCakeBlock(Supplier<CandleTofuCakeBlock> block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).build());
    }

    private ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }

    public ModelFile cubeLeavesAll(Supplier<Block> block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block.get()))).renderType("minecraft:cutout_mipped");
    }

    public void simpleLeavesBlock(Supplier<Block> block) {
        this.simpleBlock(block.get(), this.cubeLeavesAll(block));
    }

    public void cutBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), this.cutCubeAll(block));
    }

    private ModelFile cutCubeAll(Supplier<? extends Block> block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block.get()))).renderType("minecraft:cutout");
    }

    public void translucentBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), this.translucentCubeAll(block));
    }

    private ModelFile translucentCubeAll(Supplier<? extends Block> block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block.get()))).renderType("minecraft:translucent");
    }

    public void torchBlock(Supplier<Block> block, Supplier<Block> wall) {
        ModelBuilder torch = ((BlockModelBuilder)this.models().torch(this.name(block), this.texture(this.name(block)))).renderType("minecraft:cutout");
        ModelBuilder torchwall = ((BlockModelBuilder)this.models().torchWall(this.name(wall), this.texture(this.name(block)))).renderType("minecraft:cutout");
        this.simpleBlock(block.get(), (ModelFile)torch);
        this.getVariantBuilder(wall.get()).forAllStates(arg_0 -> BlockstateGenerator.lambda$torchBlock$7((ModelFile)torchwall, arg_0));
    }

    public void stairs(Supplier<StairBlock> block, Supplier<Block> fullBlock) {
        this.stairsBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void slab(Supplier<SlabBlock> block, Supplier<Block> fullBlock) {
        this.slabBlock(block.get(), this.texture(this.name(fullBlock)), this.texture(this.name(fullBlock)));
    }

    public void slab(Supplier<SlabBlock> block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlock(block.get(), this.texture(this.name(block)), side, bottom, top);
    }

    public void crossBlock(Supplier<Block> block) {
        this.crossBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(block), this.texture(this.name(block)))).renderType("minecraft:cutout"));
    }

    private void crossBlock(Supplier<Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    public void cake(Supplier<Block> block, String name) {
        this.cakeBlockInternal(block, this.name(block), this.texture(name + "_bottom"), this.texture(name + "_top"), this.texture(name + "_side"), this.texture(name + "_inner"));
    }

    private void cakeBlockInternal(Supplier<Block> block, String baseName, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation inside) {
        ModelBuilder<?> cake = this.cake(baseName + "_uneaten", bottom, top, side);
        ModelBuilder<?> sliced1 = this.slicedCake(baseName + "_slice1", "cake_slice1", bottom, top, side, inside);
        ModelBuilder<?> sliced2 = this.slicedCake(baseName + "_slice2", "cake_slice2", bottom, top, side, inside);
        ModelBuilder<?> sliced3 = this.slicedCake(baseName + "_slice3", "cake_slice3", bottom, top, side, inside);
        ModelBuilder<?> sliced4 = this.slicedCake(baseName + "_slice4", "cake_slice4", bottom, top, side, inside);
        ModelBuilder<?> sliced5 = this.slicedCake(baseName + "_slice5", "cake_slice5", bottom, top, side, inside);
        ModelBuilder<?> sliced6 = this.slicedCake(baseName + "_slice6", "cake_slice6", bottom, top, side, inside);
        this.cakeBlock(block, (ModelFile)cake, (ModelFile)sliced1, (ModelFile)sliced2, (ModelFile)sliced3, (ModelFile)sliced4, (ModelFile)sliced5, (ModelFile)sliced6);
    }

    public void cakeBlock(Supplier<Block> block, ModelFile uneat, ModelFile sliced1, ModelFile sliced2, ModelFile sliced3, ModelFile sliced4, ModelFile sliced5, ModelFile sliced6) {
        this.getVariantBuilder(block.get()).forAllStatesExcept(state -> {
            int bite = (Integer)state.getValue((Property)TofuCakeBlock.BITES);
            return ConfiguredModel.builder().modelFile(switch (bite) {
                case 0 -> uneat;
                case 1 -> sliced1;
                case 2 -> sliced2;
                case 3 -> sliced3;
                case 4 -> sliced4;
                case 5 -> sliced5;
                default -> sliced6;
            }).build();
        }, new Property[]{DoorBlock.POWERED});
    }

    private ModelBuilder<?> slicedCake(String name, String model, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation inside) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/" + model)).texture("particle", top)).texture("bottom", bottom)).texture("top", top)).texture("side", side)).texture("inside", inside);
    }

    private ModelBuilder<?> cake(String name, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/cake")).texture("particle", top)).texture("bottom", bottom)).texture("top", top)).texture("side", side);
    }

    public void door(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.texture(name + "_door_bottom"), this.texture(name + "_door_top"));
    }

    public void ancientFormatDoor(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlockInternal(block.get(), BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).toString(), this.texture("tofudoor_" + name + "_lower"), this.texture("tofudoor_" + name + "_upper"));
    }

    private ModelBuilder<?> door(String name, String model, ResourceLocation bottom, ResourceLocation top) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/" + model)).texture("bottom", bottom)).texture("top", top)).renderType("minecraft:cutout");
    }

    private void doorBlockInternal(DoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation top) {
        ModelBuilder<?> bottomLeft = this.door(baseName + "_bottom_left", "door_bottom_left", bottom, top);
        ModelBuilder<?> bottomLeftOpen = this.door(baseName + "_bottom_left_open", "door_bottom_left_open", bottom, top);
        ModelBuilder<?> bottomRight = this.door(baseName + "_bottom_right", "door_bottom_right", bottom, top);
        ModelBuilder<?> bottomRightOpen = this.door(baseName + "_bottom_right_open", "door_bottom_right_open", bottom, top);
        ModelBuilder<?> topLeft = this.door(baseName + "_top_left", "door_top_left", bottom, top);
        ModelBuilder<?> topLeftOpen = this.door(baseName + "_top_left_open", "door_top_left_open", bottom, top);
        ModelBuilder<?> topRight = this.door(baseName + "_top_right", "door_top_right", bottom, top);
        ModelBuilder<?> topRightOpen = this.door(baseName + "_top_right_open", "door_top_right_open", bottom, top);
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    public void doorBlock(DoorBlock block, ModelFile bottomLeft, ModelFile bottomLeftOpen, ModelFile bottomRight, ModelFile bottomRightOpen, ModelFile topLeft, ModelFile topLeftOpen, ModelFile topRight, ModelFile topRightOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.getValue((Property)DoorBlock.FACING)).toYRot() + 90;
            boolean right = state.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.getValue((Property)DoorBlock.OPEN);
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER ? (right ? (open ? bottomRightOpen : bottomRight) : (open ? bottomLeftOpen : bottomLeft)) : (right ? (open ? topRightOpen : topRight) : (open ? topLeftOpen : topLeft))).rotationY(yRot %= 360).build();
        }, new Property[]{DoorBlock.POWERED});
    }

    public void wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        this.wallBlock(wall.get(), this.texture(this.name(fullBlock)));
    }

    public void trapdoor(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoor(block, this.texture(this.name(block)), true);
    }

    public void trapdoor(Supplier<? extends TrapDoorBlock> block, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockInternal(block.get(), this.name(block), texture, orientable);
    }

    private void trapdoorBlockInternal(TrapDoorBlock block, String baseName, ResourceLocation texture, boolean orientable) {
        ModelBuilder bottom = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableBottom(baseName + "_bottom", texture)).renderType("minecraft:cutout") : ((BlockModelBuilder)this.models().trapdoorBottom(baseName + "_bottom", texture)).renderType("minecraft:cutout");
        ModelBuilder top = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableTop(baseName + "_top", texture)).renderType("minecraft:cutout") : ((BlockModelBuilder)this.models().trapdoorTop(baseName + "_top", texture)).renderType("minecraft:cutout");
        ModelBuilder open = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableOpen(baseName + "_open", texture)).renderType("minecraft:cutout") : ((BlockModelBuilder)this.models().trapdoorOpen(baseName + "_open", texture)).renderType("minecraft:cutout");
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, orientable);
    }

    protected VariantBlockStateBuilder make2LayerCubeAllSidesSame(Block block, Block block2, ResourceLocation renderType, int layer1em, int layer2em, boolean shade) {
        return this.make2LayerCube(block, block2, renderType, layer1em, layer1em, layer1em, layer1em, layer1em, layer1em, layer2em, layer2em, layer2em, layer2em, layer2em, layer2em, shade);
    }

    protected VariantBlockStateBuilder make2LayerCubeAllSidesSame(Block block, ResourceLocation renderType, int layer1em, int layer2em, boolean shade) {
        return this.make2LayerCube(block, block, renderType, layer1em, layer1em, layer1em, layer1em, layer1em, layer1em, layer2em, layer2em, layer2em, layer2em, layer2em, layer2em, shade);
    }

    protected VariantBlockStateBuilder make2LayerCube(Block block, Block block2, ResourceLocation renderType, int layer1emN, int layer1emS, int layer1emW, int layer1emE, int layer1emU, int layer1emD, int layer2emN, int layer2emS, int layer2emW, int layer2emE, int layer2emU, int layer2emD, boolean shade) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockTexture(block).getPath(), "minecraft:block/block")).renderType(renderType)).texture("particle", "#bottom")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(shade).face(Direction.NORTH).texture("#north").cullface(Direction.NORTH).emissivity(layer1emN, layer1emN).end().face(Direction.EAST).texture("#east").cullface(Direction.EAST).emissivity(layer1emE, layer1emE).end().face(Direction.SOUTH).texture("#south").cullface(Direction.SOUTH).emissivity(layer1emS, layer1emS).end().face(Direction.WEST).texture("#west").cullface(Direction.WEST).emissivity(layer1emW, layer1emW).end().face(Direction.UP).texture("#top").cullface(Direction.UP).emissivity(layer1emU, layer1emU).end().face(Direction.DOWN).texture("#bottom").cullface(Direction.DOWN).emissivity(layer1emD, layer1emD).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#north2").cullface(Direction.NORTH).emissivity(layer2emN, layer2emN).tintindex(0).end().face(Direction.EAST).texture("#east2").cullface(Direction.EAST).emissivity(layer2emE, layer2emE).tintindex(0).end().face(Direction.SOUTH).texture("#south2").cullface(Direction.SOUTH).emissivity(layer2emS, layer2emS).tintindex(0).end().face(Direction.WEST).texture("#west2").cullface(Direction.WEST).emissivity(layer2emW, layer2emW).tintindex(0).end().face(Direction.UP).texture("#top2").cullface(Direction.UP).emissivity(layer2emU, layer2emU).tintindex(0).end().face(Direction.DOWN).texture("#bottom2").cullface(Direction.DOWN).emissivity(layer2emD, layer2emD).tintindex(0).end().end()).texture("north", "#all")).texture("south", "#all")).texture("east", "#all")).texture("west", "#all")).texture("top", "#all")).texture("bottom", "#all")).texture("north2", "#all2")).texture("south2", "#all2")).texture("east2", "#all2")).texture("west2", "#all2")).texture("top2", "#all2")).texture("bottom2", "#all2")).texture("all", this.blockTexture(block2))).texture("all2", this.suffix(this.blockTexture(block), "_emissive"));
        return (VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)builder).addModel();
    }

    protected VariantBlockStateBuilder make2LayerLogSidesSame(RotatedPillarBlock block, ResourceLocation renderType, int layer1em, int layer2em, boolean shade) {
        return this.make2LayerLog(block, renderType, layer1em, layer1em, layer1em, layer1em, layer1em, layer1em, layer2em, layer2em, layer2em, layer2em, layer2em, layer2em, shade);
    }

    protected VariantBlockStateBuilder make2LayerLog(RotatedPillarBlock block, ResourceLocation renderType, int layer1emN, int layer1emS, int layer1emW, int layer1emE, int layer1emU, int layer1emD, int layer2emN, int layer2emS, int layer2emW, int layer2emE, int layer2emU, int layer2emD, boolean shade) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockTexture((Block)block).getPath(), "minecraft:block/block")).renderType(renderType)).texture("particle", "#side")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(shade).face(Direction.NORTH).texture("#side").cullface(Direction.NORTH).emissivity(layer1emN, layer1emN).end().face(Direction.EAST).texture("#side").cullface(Direction.EAST).emissivity(layer1emE, layer1emE).end().face(Direction.SOUTH).texture("#side").cullface(Direction.SOUTH).emissivity(layer1emS, layer1emS).end().face(Direction.WEST).texture("#side").cullface(Direction.WEST).emissivity(layer1emW, layer1emW).end().face(Direction.UP).texture("#end").cullface(Direction.UP).emissivity(layer1emU, layer1emU).end().face(Direction.DOWN).texture("#end").cullface(Direction.DOWN).emissivity(layer1emD, layer1emD).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#side2").cullface(Direction.NORTH).emissivity(layer2emN, layer2emN).tintindex(0).end().face(Direction.EAST).texture("#side2").cullface(Direction.EAST).emissivity(layer2emE, layer2emE).tintindex(0).end().face(Direction.SOUTH).texture("#side2").cullface(Direction.SOUTH).emissivity(layer2emS, layer2emS).tintindex(0).end().face(Direction.WEST).texture("#side2").cullface(Direction.WEST).emissivity(layer2emW, layer2emW).tintindex(0).end().face(Direction.UP).texture("#end2").cullface(Direction.UP).emissivity(layer2emU, layer2emU).tintindex(0).end().face(Direction.DOWN).texture("#end2").cullface(Direction.DOWN).emissivity(layer2emD, layer2emD).tintindex(0).end().end()).texture("side", this.blockTexture((Block)block))).texture("side2", this.suffix(this.blockTexture((Block)block), "_emissive"))).texture("end", this.suffix(this.blockTexture((Block)block), "_top"))).texture("end2", this.suffix(this.blockTexture((Block)block), "_top_emissive"));
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)builder).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)builder).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)builder).rotationX(90).rotationY(90).addModel();
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected String name(Supplier<? extends Block> block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath();
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }

    @Nonnull
    public String getName() {
        return "TofuCraftReload blockstates and block models";
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$7(ModelFile torchwall, BlockState state) {
        return ConfiguredModel.builder().modelFile(torchwall).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 90) % 360).build();
    }

    private static /* synthetic */ ModelFile lambda$candleCake$5(ModelFile candleCakeLit, ModelFile candleCake, BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? candleCakeLit : candleCake;
    }

    private static /* synthetic */ ModelFile lambda$carpet$3(ModelFile carpet, BlockState state) {
        return carpet;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$lantern$2(ModelFile hanging, ModelFile nonHanging, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.getValue((Property)LanternBlock.HANGING) != false ? hanging : nonHanging).build();
    }
}

