/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity.goal;

import baguchan.tofucraft.entity.Tofunian;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FindJobBlockGoal
extends MoveToBlockGoal {
    private final Tofunian creature;
    private boolean findBlock;

    public FindJobBlockGoal(Tofunian creature, double speedIn, int length) {
        super((PathfinderMob)creature, speedIn, length);
        this.creature = creature;
    }

    public boolean canUse() {
        return this.creature.level().isDay() && (this.creature.getRole() == Tofunian.Roles.TOFUNIAN || this.creature.getTofunianJobBlock() == null) && !this.creature.isBaby() && super.canUse();
    }

    public boolean canContinueToUse() {
        return !this.findBlock && super.canContinueToUse() && this.creature.level().isDay() && !this.creature.isBaby() && (this.creature.getRole() == Tofunian.Roles.TOFUNIAN || this.creature.getTofunianJobBlock() == null) && this.mob != null;
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            if (!FindJobBlockGoal.findNearbyTofunianHadJob(this.creature, this.blockPos)) {
                Tofunian.Roles role = Tofunian.Roles.getJob(this.creature.level().getBlockState(this.blockPos));
                if (role != null && !this.findBlock) {
                    if (this.creature.level() instanceof ServerLevel) {
                        this.creature.setTofunianJobBlock(this.blockPos);
                        if (this.creature.getRole() == Tofunian.Roles.TOFUNIAN) {
                            this.creature.setRole(role);
                            this.creature.setOffers(null);
                            this.findBlock = true;
                        }
                    }
                    this.creature.swing(InteractionHand.MAIN_HAND);
                    this.creature.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 0.7f);
                }
            } else {
                this.findBlock = true;
            }
        }
    }

    protected boolean findNearestBlock() {
        return super.findNearestBlock() && !FindJobBlockGoal.findNearbyTofunianHadJob(this.creature, this.blockPos);
    }

    public static boolean findNearbyTofunianHadJob(Tofunian tofunian, BlockPos pos) {
        List list = tofunian.level().getEntitiesOfClass(Tofunian.class, tofunian.getBoundingBox().inflate(32.0));
        return list.stream().anyMatch(p_34881_ -> p_34881_ != tofunian && pos.equals((Object)p_34881_.getTofunianJobBlock()));
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        BlockHitResult hitResult;
        BlockState blockstate = worldIn.getBlockState(pos);
        Tofunian.Roles role = Tofunian.Roles.getJob(blockstate);
        return role != null && ((hitResult = worldIn.clip(new ClipContext(this.creature.getEyePosition(), pos.getCenter(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.creature))).getBlockPos().equals((Object)BlockPos.containing((Position)pos.getCenter())) || hitResult.getType() == HitResult.Type.MISS);
    }

    public void start() {
        super.start();
        this.findBlock = false;
    }

    public void stop() {
        super.stop();
    }

    public double acceptedDistance() {
        return 3.0;
    }
}

