/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.recipe;

import baguchan.tofucraft.recipe.TFCraftingCategory;
import baguchan.tofucraft.recipe.TFCraftingRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class TFShapedRecipe
implements TFCraftingRecipe {
    public final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    final TFCraftingCategory category;
    final int tf;
    final boolean showNotification;

    public TFShapedRecipe(String group, TFCraftingCategory category, ShapedRecipePattern pattern, ItemStack result, int tf, boolean showNotification) {
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = result;
        this.tf = tf;
        this.showNotification = showNotification;
    }

    public TFShapedRecipe(String group, TFCraftingCategory category, ShapedRecipePattern pattern, ItemStack result, int tf) {
        this(group, category, pattern, result, tf, true);
    }

    public RecipeSerializer<?> getSerializer() {
        return TofuRecipes.RECIPE_TF_CRAFT_SHAPED.get();
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public TFCraftingCategory category() {
        return this.category;
    }

    @Override
    public int getNeedTF() {
        return this.tf;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.pattern.width() && height >= this.pattern.height();
    }

    public boolean matches(CraftingInput input, Level level) {
        return this.pattern.matches(input);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public boolean isIncomplete() {
        NonNullList<Ingredient> nonnulllist = this.getIngredients();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.isEmpty()).anyMatch(Ingredient::hasNoItems);
    }

    public static class Serializer
    implements RecipeSerializer<TFShapedRecipe> {
        public static final MapCodec<TFShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_311729_ -> p_311729_.group), (App)TFCraftingCategory.CODEC.fieldOf("category").orElse((Object)TFCraftingCategory.MISC).forGetter(p_311732_ -> p_311732_.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.result), (App)Codec.INT.fieldOf("tf").forGetter(tfShapedRecipe -> tfShapedRecipe.tf), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(p_311731_ -> p_311731_.showNotification)).apply((Applicative)p_340778_, TFShapedRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TFShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TFShapedRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TFShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static TFShapedRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            TFCraftingCategory craftingbookcategory = (TFCraftingCategory)buffer.readEnum(TFCraftingCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int i = buffer.readInt();
            boolean flag = buffer.readBoolean();
            return new TFShapedRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, i, flag);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, TFShapedRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeEnum((Enum)recipe.category);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.tf);
            buffer.writeBoolean(recipe.showNotification);
        }
    }
}

