/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block;

import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;

public class TofuFarmlandBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public TofuFarmlandBlock(BlockBehaviour.Properties p_53247_) {
        super(p_53247_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState updateShape(BlockState p_53276_, Direction p_53277_, BlockState p_53278_, LevelAccessor p_53279_, BlockPos p_53280_, BlockPos p_53281_) {
        if (p_53277_ == Direction.UP && !p_53276_.canSurvive((LevelReader)p_53279_, p_53280_) && !p_53279_.getBlockTicks().hasScheduledTick(p_53280_, (Object)this)) {
            p_53279_.scheduleTick(p_53280_, (Block)this, 1);
        }
        return super.updateShape(p_53276_, p_53277_, p_53278_, p_53279_, p_53280_, p_53281_);
    }

    public boolean canSurvive(BlockState p_53272_, LevelReader p_53273_, BlockPos p_53274_) {
        BlockState blockstate = p_53273_.getBlockState(p_53274_.above());
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock || blockstate.getBlock() instanceof MovingPistonBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_53249_) {
        return !this.defaultBlockState().canSurvive((LevelReader)p_53249_.getLevel(), p_53249_.getClickedPos()) ? ((Block)TofuBlocks.TOFU_TERRAIN.get()).defaultBlockState() : super.getStateForPlacement(p_53249_);
    }

    public boolean useShapeForLightOcclusion(BlockState p_53295_) {
        return true;
    }

    public VoxelShape getShape(BlockState p_53290_, BlockGetter p_53291_, BlockPos p_53292_, CollisionContext p_53293_) {
        return SHAPE;
    }

    public void tick(BlockState p_53262_, ServerLevel p_53263_, BlockPos p_53264_, RandomSource p_53265_) {
        if (!p_53262_.canSurvive((LevelReader)p_53263_, p_53264_)) {
            TofuFarmlandBlock.turnToDirt(p_53262_, (Level)p_53263_, p_53264_);
        }
    }

    public void randomTick(BlockState p_53285_, ServerLevel p_53286_, BlockPos p_53287_, RandomSource p_53288_) {
        int i = (Integer)p_53285_.getValue((Property)MOISTURE);
        if (!TofuFarmlandBlock.isNearWater((LevelReader)p_53286_, p_53287_) && !p_53286_.isRainingAt(p_53287_.above())) {
            if (i > 0) {
                p_53286_.setBlock(p_53287_, (BlockState)p_53285_.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!TofuFarmlandBlock.shouldMaintainFarmland((BlockGetter)p_53286_, p_53287_)) {
                TofuFarmlandBlock.turnToDirt(p_53285_, (Level)p_53286_, p_53287_);
            }
        } else if (i < 7) {
            p_53286_.setBlock(p_53287_, (BlockState)p_53285_.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void fallOn(Level p_153227_, BlockState p_153228_, BlockPos p_153229_, Entity p_153230_, float p_153231_) {
        if (!p_153227_.isClientSide && CommonHooks.onFarmlandTrample((Level)p_153227_, (BlockPos)p_153229_, (BlockState)((Block)TofuBlocks.TOFU_TERRAIN.get()).defaultBlockState(), (float)p_153231_, (Entity)p_153230_)) {
            TofuFarmlandBlock.turnToDirt(p_153228_, p_153227_, p_153229_);
        }
        super.fallOn(p_153227_, p_153228_, p_153229_, p_153230_, p_153231_);
    }

    public static void turnToDirt(BlockState p_53297_, Level p_53298_, BlockPos p_53299_) {
        p_53298_.setBlockAndUpdate(p_53299_, TofuFarmlandBlock.pushEntitiesUp((BlockState)p_53297_, (BlockState)((Block)TofuBlocks.TOFU_TERRAIN.get()).defaultBlockState(), (LevelAccessor)p_53298_, (BlockPos)p_53299_));
    }

    private static boolean shouldMaintainFarmland(BlockGetter p_279219_, BlockPos p_279209_) {
        return p_279219_.getBlockState(p_279209_.above()).is(BlockTags.MAINTAINS_FARMLAND);
    }

    private static boolean isNearWater(LevelReader p_53259_, BlockPos p_53260_) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)p_53260_.offset(-4, 0, -4), (BlockPos)p_53260_.offset(4, 1, 4))) {
            if (!p_53259_.getFluidState(blockpos).is(FluidTags.WATER) && !p_53259_.getFluidState(blockpos).is(TofuTags.Fluids.SOYMILK)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)p_53259_, (BlockPos)p_53260_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53283_) {
        p_53283_.add(new Property[]{MOISTURE});
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return false;
    }
}

