/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.crop;

import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LeekCropsBlock
extends CropBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)};

    public LeekCropsBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public boolean canSurvive(BlockState p_51028_, LevelReader p_51029_, BlockPos p_51030_) {
        BlockPos blockpos = p_51030_.below();
        return this.mayPlaceOn(p_51029_.getBlockState(blockpos), (BlockGetter)p_51029_, blockpos);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter p_52303_, BlockPos p_52304_) {
        return state.is((Block)TofuBlocks.TOFU_FARMLAND.get());
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)TofuItems.LEEK.get();
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public void randomTick(BlockState p_49667_, ServerLevel p_49668_, BlockPos p_49669_, RandomSource p_49670_) {
        if (p_49670_.nextInt(3) != 0) {
            super.randomTick(p_49667_, p_49668_, p_49669_, p_49670_);
        }
    }

    public void growCrops(Level p_52264_, BlockPos p_52265_, BlockState p_52266_) {
        int j;
        int i = this.getAge(p_52266_) + this.getBonemealAgeIncrease(p_52264_);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        p_52264_.setBlock(p_52265_, this.getStateForAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level p_49663_) {
        return super.getBonemealAgeIncrease(p_49663_) / 3;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49665_) {
        p_49665_.add(new Property[]{AGE});
    }

    public VoxelShape getShape(BlockState p_49672_, BlockGetter p_49673_, BlockPos p_49674_, CollisionContext p_49675_) {
        return SHAPE_BY_AGE[(Integer)p_49672_.getValue((Property)this.getAgeProperty())];
    }
}

