/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SoymilkCauldronBlock
extends Block {
    public static final BooleanProperty SOYCHEESE = BooleanProperty.create((String)"soycheese");
    private static final VoxelShape INSIDE = SoymilkCauldronBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)SoymilkCauldronBlock.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{SoymilkCauldronBlock.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), SoymilkCauldronBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.ONLY_FIRST);
    private final Supplier<Item> itemSupplier;
    private final Supplier<Item> cheeseSupplier;

    public SoymilkCauldronBlock(BlockBehaviour.Properties p_151946_, Supplier<Item> itemSupplier, Supplier<Item> cheeseSupplier) {
        super(p_151946_);
        this.itemSupplier = itemSupplier;
        this.cheeseSupplier = cheeseSupplier;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SOYCHEESE, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack itemHeld, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_316140_) {
        if (((Boolean)state.getValue((Property)SOYCHEESE)).booleanValue()) {
            ItemStack cheese = new ItemStack((ItemLike)this.cheeseSupplier.get(), 4);
            float f = 0.7f;
            double d0 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
            double d2 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, cheese);
            itemEntity.setPickUpDelay(10);
            worldIn.addFreshEntity((Entity)itemEntity);
            worldIn.setBlock(pos, Blocks.CAULDRON.defaultBlockState(), 2);
            return ItemInteractionResult.SUCCESS;
        }
        if (itemHeld.is(Items.BUCKET)) {
            ItemStack bucket = new ItemStack((ItemLike)this.itemSupplier.get());
            worldIn.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (itemHeld.getCount() == 1) {
                player.setItemInHand(handIn, bucket);
            } else {
                if (!player.getInventory().add(bucket)) {
                    worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, bucket));
                }
                itemHeld.shrink(1);
            }
            worldIn.setBlock(pos, Blocks.CAULDRON.defaultBlockState(), 2);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemHeld, state, worldIn, pos, player, handIn, p_316140_);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)SOYCHEESE)).booleanValue() && random.nextInt(3) == 0) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)SOYCHEESE, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public VoxelShape getShape(BlockState p_151964_, BlockGetter p_151965_, BlockPos p_151966_, CollisionContext p_151967_) {
        return SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState p_151955_, BlockGetter p_151956_, BlockPos p_151957_) {
        return INSIDE;
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.createBlockStateDefinition(p_49915_);
        p_49915_.add(new Property[]{SOYCHEESE});
    }
}

