/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import baguchan.tofucraft.blockentity.TofuBedBlockEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;

public class TofuBedBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    protected static final int HEIGHT = 9;
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final int LEG_WIDTH = 3;
    protected static final VoxelShape LEG_NORTH_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_NORTH_EAST});
    protected static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_SOUTH_EAST});
    protected static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});

    public TofuBedBlock(BlockBehaviour.Properties p_49455_) {
        super(DyeColor.WHITE, p_49455_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState updateShape(BlockState p_49525_, Direction p_49526_, BlockState p_49527_, LevelAccessor p_49528_, BlockPos p_49529_, BlockPos p_49530_) {
        if (p_49526_ == TofuBedBlock.getNeighbourDirection((BedPart)p_49525_.getValue(PART), (Direction)p_49525_.getValue((Property)FACING))) {
            return p_49527_.is((Block)this) && p_49527_.getValue(PART) != p_49525_.getValue(PART) ? (BlockState)p_49525_.setValue((Property)OCCUPIED, (Comparable)((Boolean)p_49527_.getValue((Property)OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_49525_, p_49526_, p_49527_, p_49528_, p_49529_, p_49530_);
    }

    private static Direction getNeighbourDirection(BedPart p_49534_, Direction p_49535_) {
        return p_49534_ == BedPart.FOOT ? p_49535_ : p_49535_.getOpposite();
    }

    public BlockState playerWillDestroy(Level p_49505_, BlockPos p_49506_, BlockState p_49507_, Player p_49508_) {
        BlockPos var6;
        BlockState var7;
        BedPart var5;
        if (!p_49505_.isClientSide && p_49508_.isCreative() && (var5 = (BedPart)p_49507_.getValue(PART)) == BedPart.FOOT && (var7 = p_49505_.getBlockState(var6 = p_49506_.relative(TofuBedBlock.getNeighbourDirection(var5, (Direction)p_49507_.getValue((Property)FACING))))).is((Block)this) && var7.getValue(PART) == BedPart.HEAD) {
            p_49505_.setBlock(var6, Blocks.AIR.defaultBlockState(), 35);
            p_49505_.levelEvent(p_49508_, 2001, var6, Block.getId((BlockState)var7));
        }
        return super.playerWillDestroy(p_49505_, p_49506_, p_49507_, p_49508_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_49479_) {
        Direction var2 = p_49479_.getHorizontalDirection();
        BlockPos var3 = p_49479_.getClickedPos();
        BlockPos var4 = var3.relative(var2);
        return p_49479_.getLevel().getBlockState(var4).canBeReplaced(p_49479_) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)var2) : null;
    }

    public VoxelShape getShape(BlockState p_49547_, BlockGetter p_49548_, BlockPos p_49549_, CollisionContext p_49550_) {
        Direction var5 = TofuBedBlock.getConnectedDirection(p_49547_).getOpposite();
        switch (var5) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public static Direction getConnectedDirection(BlockState p_49558_) {
        Direction var1 = (Direction)p_49558_.getValue((Property)FACING);
        return p_49558_.getValue(PART) == BedPart.HEAD ? var1.getOpposite() : var1;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState p_49560_) {
        BedPart var1 = (BedPart)p_49560_.getValue(PART);
        return var1 == BedPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    private static boolean isBunkBed(BlockGetter p_49542_, BlockPos p_49543_) {
        return p_49542_.getBlockState(p_49543_.below()).getBlock() instanceof BedBlock;
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> p_49459_, CollisionGetter p_49460_, BlockPos p_49461_, float p_49462_) {
        Direction var6;
        Direction var4 = (Direction)p_49460_.getBlockState(p_49461_).getValue((Property)FACING);
        Direction var5 = var4.getClockWise();
        Direction direction = var6 = var5.isFacingAngle(p_49462_) ? var5.getOpposite() : var5;
        if (TofuBedBlock.isBunkBed((BlockGetter)p_49460_, p_49461_)) {
            return TofuBedBlock.findBunkBedStandUpPosition(p_49459_, p_49460_, p_49461_, var4, var6);
        }
        int[][] var7 = TofuBedBlock.bedStandUpOffsets(var4, var6);
        Optional<Vec3> var8 = TofuBedBlock.findStandUpPositionAtOffset(p_49459_, p_49460_, p_49461_, var7, true);
        return var8.isPresent() ? var8 : TofuBedBlock.findStandUpPositionAtOffset(p_49459_, p_49460_, p_49461_, var7, false);
    }

    private static Optional<Vec3> findBunkBedStandUpPosition(EntityType<?> p_49464_, CollisionGetter p_49465_, BlockPos p_49466_, Direction p_49467_, Direction p_49468_) {
        int[][] var5 = TofuBedBlock.bedSurroundStandUpOffsets(p_49467_, p_49468_);
        Optional<Vec3> var6 = TofuBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, p_49466_, var5, true);
        if (var6.isPresent()) {
            return var6;
        }
        BlockPos var7 = p_49466_.below();
        Optional<Vec3> var8 = TofuBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, var7, var5, true);
        if (var8.isPresent()) {
            return var8;
        }
        int[][] var9 = TofuBedBlock.bedAboveStandUpOffsets(p_49467_);
        Optional<Vec3> var10 = TofuBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, p_49466_, var9, true);
        if (var10.isPresent()) {
            return var10;
        }
        Optional<Vec3> var11 = TofuBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, p_49466_, var5, false);
        if (var11.isPresent()) {
            return var11;
        }
        Optional<Vec3> var12 = TofuBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, var7, var5, false);
        return var12.isPresent() ? var12 : TofuBedBlock.findStandUpPositionAtOffset(p_49464_, p_49465_, p_49466_, var9, false);
    }

    private static Optional<Vec3> findStandUpPositionAtOffset(EntityType<?> p_49470_, CollisionGetter p_49471_, BlockPos p_49472_, int[][] p_49473_, boolean p_49474_) {
        BlockPos.MutableBlockPos var5 = new BlockPos.MutableBlockPos();
        int[][] var6 = p_49473_;
        int var7 = p_49473_.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            int[] var9 = var6[var8];
            var5.set(p_49472_.getX() + var9[0], p_49472_.getY(), p_49472_.getZ() + var9[1]);
            Vec3 var10 = DismountHelper.findSafeDismountLocation(p_49470_, (CollisionGetter)p_49471_, (BlockPos)var5, (boolean)p_49474_);
            if (var10 == null) continue;
            return Optional.of(var10);
        }
        return Optional.empty();
    }

    public PushReaction getPistonPushReaction(BlockState p_49556_) {
        return PushReaction.DESTROY;
    }

    public RenderShape getRenderShape(BlockState p_49545_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49532_) {
        p_49532_.add(new Property[]{FACING, PART, OCCUPIED});
    }

    public BlockEntity newBlockEntity(BlockPos p_152175_, BlockState p_152176_) {
        return new TofuBedBlockEntity(p_152175_, p_152176_);
    }

    public void setPlacedBy(Level p_49499_, BlockPos p_49500_, BlockState p_49501_, @Nullable LivingEntity p_49502_, ItemStack p_49503_) {
        super.setPlacedBy(p_49499_, p_49500_, p_49501_, p_49502_, p_49503_);
        if (!p_49499_.isClientSide) {
            BlockPos var6 = p_49500_.relative((Direction)p_49501_.getValue((Property)FACING));
            p_49499_.setBlock(var6, (BlockState)p_49501_.setValue(PART, (Comparable)BedPart.HEAD), 3);
            p_49499_.blockUpdated(p_49500_, Blocks.AIR);
            p_49501_.updateNeighbourShapes((LevelAccessor)p_49499_, p_49500_, 3);
        }
    }

    public long getSeed(BlockState p_49522_, BlockPos p_49523_) {
        BlockPos var3 = p_49523_.relative((Direction)p_49522_.getValue((Property)FACING), p_49522_.getValue(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed((int)var3.getX(), (int)p_49523_.getY(), (int)var3.getZ());
    }

    public boolean isPathfindable(BlockState p_49510_, BlockGetter p_49511_, BlockPos p_49512_, PathComputationType p_49513_) {
        return false;
    }

    private static int[][] bedStandUpOffsets(Direction p_49539_, Direction p_49540_) {
        return (int[][])ArrayUtils.addAll((Object[])TofuBedBlock.bedSurroundStandUpOffsets(p_49539_, p_49540_), (Object[])TofuBedBlock.bedAboveStandUpOffsets(p_49539_));
    }

    private static int[][] bedSurroundStandUpOffsets(Direction p_49552_, Direction p_49553_) {
        return new int[][]{{p_49553_.getStepX(), p_49553_.getStepZ()}, {p_49553_.getStepX() - p_49552_.getStepX(), p_49553_.getStepZ() - p_49552_.getStepZ()}, {p_49553_.getStepX() - p_49552_.getStepX() * 2, p_49553_.getStepZ() - p_49552_.getStepZ() * 2}, {-p_49552_.getStepX() * 2, -p_49552_.getStepZ() * 2}, {-p_49553_.getStepX() - p_49552_.getStepX() * 2, -p_49553_.getStepZ() - p_49552_.getStepZ() * 2}, {-p_49553_.getStepX() - p_49552_.getStepX(), -p_49553_.getStepZ() - p_49552_.getStepZ()}, {-p_49553_.getStepX(), -p_49553_.getStepZ()}, {-p_49553_.getStepX() + p_49552_.getStepX(), -p_49553_.getStepZ() + p_49552_.getStepZ()}, {p_49552_.getStepX(), p_49552_.getStepZ()}, {p_49553_.getStepX() + p_49552_.getStepX(), p_49553_.getStepZ() + p_49552_.getStepZ()}};
    }

    private static int[][] bedAboveStandUpOffsets(Direction p_49537_) {
        return new int[][]{{0, 0}, {-p_49537_.getStepX(), -p_49537_.getStepZ()}};
    }
}

