/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class WeightBaseBlock
extends Block {
    public static final EnumProperty<Stat> STAT = EnumProperty.create((String)"stat", Stat.class);
    public static final IntegerProperty TIME = IntegerProperty.create((String)"time", (int)0, (int)5);

    public WeightBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(STAT, (Comparable)((Object)Stat.USING))).setValue((Property)TIME, (Comparable)Integer.valueOf(0)));
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        Stat stat = this.getStat(state);
        int time = (Integer)state.getValue((Property)TIME);
        if (this.isUnderWeight((Level)worldIn, pos)) {
            if (time < 5 && random.nextInt(4) == 0) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)TIME, (Comparable)Integer.valueOf(time + 1)), 3);
            }
            if (time >= 5 && stat == Stat.USING) {
                worldIn.setBlock(pos, (BlockState)state.setValue(STAT, (Comparable)((Object)Stat.USED)), 3);
            }
        }
    }

    public boolean isUnderWeight(Level world, BlockPos pos) {
        BlockState weightBlock = world.getBlockState(pos.above());
        float weightHardness = weightBlock.getDestroySpeed((BlockGetter)world, pos.above());
        boolean isWeightValid = weightBlock.isFaceSturdy((BlockGetter)world, pos, Direction.DOWN) && (weightHardness >= 1.0f || weightHardness < 0.0f) && !(weightBlock.getBlock() instanceof WeightBaseBlock);
        return isWeightValid;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAT, TIME});
    }

    public Stat getStat(BlockState meta) {
        if (meta.getBlock() == this) {
            return (Stat)((Object)meta.getValue(STAT));
        }
        return Stat.USING;
    }

    public static enum Stat implements StringRepresentable
    {
        USING("using"),
        USED("used");

        private final String name;

        private Stat(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

