/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.blockentity.tfenergy;

import baguchan.tofucraft.api.tfenergy.IEnergyExtractable;
import baguchan.tofucraft.api.tfenergy.IEnergyInsertable;
import baguchan.tofucraft.api.tfenergy.TofuEnergyMap;
import baguchan.tofucraft.block.tfenergy.TFStorageBlock;
import baguchan.tofucraft.blockentity.tfenergy.TFCollectorBlockEntity;
import baguchan.tofucraft.blockentity.tfenergy.base.SenderBaseBlockEntity;
import baguchan.tofucraft.inventory.TFStorageMenu;
import baguchan.tofucraft.network.TFStorageSoymilkPacket;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import baguchan.tofucraft.registry.TofuFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TFStorageBlockEntity
extends SenderBaseBlockEntity
implements StackedContentsCompatible,
Container,
MenuProvider {
    private static final int POWER = 20;
    private FluidTank tank = new TFStorageTank(this, 2000);
    protected NonNullList<ItemStack> inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    private int workload = 0;
    private int current_workload = 0;
    private int prevFluid;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int p_221476_1_) {
            switch (p_221476_1_) {
                case 0: {
                    return TFStorageBlockEntity.this.workload;
                }
                case 1: {
                    return TFStorageBlockEntity.this.current_workload;
                }
                case 2: {
                    return TFStorageBlockEntity.this.energy;
                }
                case 3: {
                    return TFStorageBlockEntity.this.energyMax;
                }
            }
            return 0;
        }

        public void set(int p_221477_1_, int p_221477_2_) {
            switch (p_221477_1_) {
                case 0: {
                    TFStorageBlockEntity.this.workload = p_221477_2_;
                    break;
                }
                case 1: {
                    TFStorageBlockEntity.this.current_workload = p_221477_2_;
                    break;
                }
                case 2: {
                    TFStorageBlockEntity.this.energy = p_221477_2_;
                    break;
                }
                case 3: {
                    TFStorageBlockEntity.this.energyMax = p_221477_2_;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public TFStorageBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(TofuBlockEntitys.TF_STORAGE.get(), p_155229_, p_155230_, 5000);
    }

    @Override
    public boolean canReceive(BlockEntity from) {
        return from instanceof TFCollectorBlockEntity || super.canReceive(from);
    }

    /*
     * Unable to fully structure code
     */
    public static void tick(Level level, BlockPos blockPos, BlockState blockState, TFStorageBlockEntity tfStorageBlockEntity) {
        block11: {
            if (level.isClientSide()) {
                return;
            }
            SenderBaseBlockEntity.senderUpdate(tfStorageBlockEntity);
            worked = false;
            if (tfStorageBlockEntity.workload > 0 && tfStorageBlockEntity.getEnergyStored() < tfStorageBlockEntity.getMaxEnergyStored()) {
                tfStorageBlockEntity.workload -= tfStorageBlockEntity.receive(Math.min(tfStorageBlockEntity.workload, 20), false);
                worked = true;
            }
            if ((Boolean)blockState.getValue((Property)TFStorageBlock.LIT) != worked) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)TFStorageBlock.LIT, (Comparable)Boolean.valueOf(worked)), 2);
            }
            if ((var7_6 = (to = (ItemStack)tfStorageBlockEntity.inventory.get(1)).getItem()) instanceof IEnergyInsertable) {
                symbol = (IEnergyInsertable)var7_6;
                if (tfStorageBlockEntity.getEnergyStored() >= 100) {
                    tfStorageBlockEntity.drain(symbol.fill(to, 20, false), false);
                    tfStorageBlockEntity.setChanged();
                }
            }
            from = (ItemStack)tfStorageBlockEntity.inventory.get(0);
            if (tfStorageBlockEntity.workload != 0) break block11;
            milk = tfStorageBlockEntity.getTank().getFluid();
            var9_8 = from.getItem();
            if (!(var9_8 instanceof IEnergyExtractable)) ** GOTO lbl-1000
            symbol = (IEnergyExtractable)var9_8;
            if (!(from.getItem() instanceof IEnergyInsertable)) {
                tfStorageBlockEntity.workload += symbol.drain(from, 400, false);
                tfStorageBlockEntity.setChanged();
            } else if (TofuEnergyMap.getFuel(from) != -1) {
                tfStorageBlockEntity.workload += TofuEnergyMap.getFuel(from);
                from.shrink(1);
            }
            if (!milk.isEmpty() && (recipe = TofuEnergyMap.getLiquidFuel(milk)) != null) {
                tfStorageBlockEntity.tank.drain(recipe.getValue().intValue(), IFluidHandler.FluidAction.EXECUTE);
                tfStorageBlockEntity.workload += recipe.getValue().intValue();
                tfStorageBlockEntity.setChanged();
            }
            tfStorageBlockEntity.current_workload = tfStorageBlockEntity.workload;
        }
        if (tfStorageBlockEntity.prevFluid != tfStorageBlockEntity.tank.getFluidAmount()) {
            chunk = level.getChunkAt(blockPos);
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunk.getPos(), (CustomPacketPayload)new TFStorageSoymilkPacket(blockPos, tfStorageBlockEntity.tank.getFluid()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                tfStorageBlockEntity.prevFluid = tfStorageBlockEntity.tank.getFluidAmount();
            }
        }
    }

    public void startOpen(Player p_18955_) {
        Level level;
        if (!this.level.isClientSide() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LevelChunk chunk = this.level.getChunkAt(this.getBlockPos());
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunk.getPos(), (CustomPacketPayload)new TFStorageSoymilkPacket(this.getBlockPos(), this.tank.getFluid()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.prevFluid = this.tank.getFluidAmount();
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int getContainerSize() {
        return 2;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack removeItem(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.removeItem(this.inventory, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack removeItemNoUpdate(int p_70304_1_) {
        return ContainerHelper.takeItem(this.inventory, (int)p_70304_1_);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public boolean stillValid(Player p_18946_) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return p_18946_.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int par1) {
        return this.current_workload == 0 ? 0 : (this.current_workload - this.workload) * par1 / this.current_workload;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void saveAdditional(CompoundTag cmp, HolderLookup.Provider provider) {
        super.saveAdditional(cmp, provider);
        ContainerHelper.saveAllItems((CompoundTag)cmp, this.inventory, (HolderLookup.Provider)provider);
        cmp.putInt("workload", this.workload);
        cmp.putInt("current", this.current_workload);
        CompoundTag tankTag = this.tank.writeToNBT((HolderLookup.Provider)this.level.registryAccess(), new CompoundTag());
        cmp.put("Tank", (Tag)tankTag);
    }

    @Override
    protected void loadAdditional(CompoundTag cmp, HolderLookup.Provider provider) {
        super.loadAdditional(cmp, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)cmp, this.inventory, (HolderLookup.Provider)provider);
        this.workload = cmp.getInt("workload");
        this.current_workload = cmp.getInt("current");
        this.tank = this.tank.readFromNBT(provider, cmp.getCompound("Tank"));
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput p_338855_) {
        super.applyImplicitComponents(p_338855_);
        ((ItemContainerContents)p_338855_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getInventory());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder p_338252_) {
        super.collectImplicitComponents(p_338252_);
        p_338252_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getInventory()));
    }

    @Override
    public void removeComponentsFromTag(CompoundTag p_331127_) {
        super.removeComponentsFromTag(p_331127_);
        p_331127_.remove("Items");
        p_331127_.remove("current");
        p_331127_.remove("workload");
        p_331127_.remove("Tank");
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public void fillStackedContents(StackedContents p_40281_) {
        for (ItemStack itemstack : this.inventory) {
            p_40281_.accountStack(itemstack);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.tofucraft.tf_storage");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new TFStorageMenu(p_39954_, p_39955_, this, this.dataAccess);
    }

    private class TFStorageTank
    extends FluidTank {
        TFStorageTank(TFStorageBlockEntity tFStorageBlockEntity, int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid() == TofuFluids.SOYMILK.get();
        }
    }
}

