/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.model;

import bagu_chan.bagus_lib.client.layer.IArmor;
import baguchan.tofucraft.client.animation.definitions.TofunianAnimation;
import baguchan.tofucraft.entity.AbstractTofunian;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class AbstractTofunianModel<T extends AbstractTofunian>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel,
IArmor {
    public final ModelPart realRoot;
    public final ModelPart root;
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart leftLeg;
    public final ModelPart rightLeg;
    public final ModelPart rightArm;
    public final ModelPart leftArm;

    public AbstractTofunianModel(ModelPart p_170688_) {
        this.realRoot = p_170688_;
        this.root = p_170688_.getChild("root");
        this.head = this.root.getChild("head");
        this.hat = this.head.getChild("hat");
        this.body = this.root.getChild("body");
        this.leftLeg = this.root.getChild("left_leg");
        this.rightLeg = this.root.getChild("right_leg");
        this.leftArm = this.root.getChild("left_arm");
        this.rightArm = this.root.getChild("right_arm");
    }

    public ModelPart root() {
        return this.realRoot;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        boolean bl = flag = ((AbstractTofunian)((Object)entity)).getUnhappyCounter() > 0;
        if (flag) {
            this.head.zRot = 0.3f * Mth.sin((float)(0.45f * ageInTicks));
            this.head.xRot = 0.4f;
        } else {
            this.head.zRot = 0.0f;
        }
        if (this.riding) {
            this.rightArm.xRot = -0.62831855f;
            this.leftArm.xRot = -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.leftLeg.xRot = -1.4137167f;
        } else {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        }
        if (this.attackTime > 0.0f) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArm.xRot = this.attackTime * -0.75f;
                this.rightArm.zRot = this.attackTime * -0.5f;
            } else {
                this.rightArm.xRot = this.attackTime * -0.75f;
                this.rightArm.zRot = this.attackTime * 0.5f;
            }
        }
        float f6 = 12.0f;
        if (entity.isBaby()) {
            this.applyStatic(TofunianAnimation.BABY);
            this.rightArm.visible = false;
            this.leftArm.visible = false;
            this.body.visible = false;
        } else {
            this.rightArm.visible = true;
            this.leftArm.visible = true;
            this.body.visible = true;
        }
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHand(HumanoidArm p_102925_, PoseStack p_102926_) {
        if (!this.young) {
            this.root.translateAndRotate(p_102926_);
            this.getArm(p_102925_).translateAndRotate(p_102926_);
            p_102926_.translate(0.0, -0.15, 0.0);
            p_102926_.scale(0.95f, 0.95f, 0.95f);
        }
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(0.75f, 0.75f, 0.75f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(0.5f, 0.5f, 0.5f);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(0.75f, 0.75f, 0.75f);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.rightArm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.leftArm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.rightLeg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.leftLeg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

