/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.render.blockentity;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.registry.TofuBlocks;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;

public class TofuChestRenderer<T extends BlockEntity>
extends ChestRenderer<T> {
    public static final Map<Block, EnumMap<ChestType, Material>> MATERIALS;

    public TofuChestRenderer(BlockEntityRendererProvider.Context p_173607_) {
        super(p_173607_);
    }

    protected Material getMaterial(T blockEntity, ChestType chestType) {
        EnumMap<ChestType, Material> b = MATERIALS.get(blockEntity.getBlockState().getBlock());
        if (b == null) {
            return super.getMaterial(blockEntity, chestType);
        }
        Material material = b.get(chestType);
        return material != null ? material : super.getMaterial(blockEntity, chestType);
    }

    private static EnumMap<ChestType, Material> chestMaterial(String type) {
        EnumMap<ChestType, Material> map = new EnumMap<ChestType, Material>(ChestType.class);
        map.put(ChestType.SINGLE, new Material(Sheets.CHEST_SHEET, TofuCraftReload.prefix("entity/chest/" + type)));
        map.put(ChestType.LEFT, new Material(Sheets.CHEST_SHEET, TofuCraftReload.prefix("entity/chest/" + type + "_left")));
        map.put(ChestType.RIGHT, new Material(Sheets.CHEST_SHEET, TofuCraftReload.prefix("entity/chest/" + type + "_right")));
        return map;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)((Block)TofuBlocks.TOFUCHEST.get()), TofuChestRenderer.chestMaterial("tofuchest"));
        MATERIALS = builder.build();
    }
}

