/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.render.entity;

import baguchan.tofucraft.entity.projectile.FallingTofuEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class FallingTofuRenderer
extends EntityRenderer<FallingTofuEntity> {
    public FallingTofuRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.shadowRadius = 0.5f;
    }

    public void render(FallingTofuEntity entity, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        BlockState blockstate = entity.getBlockState();
        if (blockstate.getRenderShape() == RenderShape.MODEL) {
            Level world = entity.level();
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                ms.pushPose();
                BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
                ms.translate(-0.5, 0.0, -0.5);
                BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                BakedModel model = dispatcher.getBlockModel(blockstate);
                for (RenderType renderType : model.getRenderTypes(blockstate, RandomSource.create((long)blockstate.getSeed(entity.blockPosition())), ModelData.EMPTY)) {
                    dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)world, model, blockstate, blockpos, ms, buffers.getBuffer(renderType), false, entity.level().random, 0L, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
                }
                ms.popPose();
                super.render((Entity)entity, yaw, partialTicks, ms, buffers, light);
            }
        }
    }

    public ResourceLocation getTextureLocation(FallingTofuEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

