/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.render.entity;

import baguchan.tofucraft.client.TofuModelLayers;
import baguchan.tofucraft.client.model.SoyBallModel;
import baguchan.tofucraft.entity.projectile.SoyballEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SoyballRenderer<T extends SoyballEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation LLAMA_SPIT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/entity/soyball.png");
    private final SoyBallModel<T> model;

    public SoyballRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SoyBallModel(context.bakeLayer(TofuModelLayers.SOYBALL));
    }

    public void render(T llamaSpit, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.25f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)g, (float)((SoyballEntity)((Object)llamaSpit)).yRotO, (float)llamaSpit.getYRot()) - 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)g, (float)((SoyballEntity)((Object)llamaSpit)).xRotO, (float)llamaSpit.getXRot())));
        poseStack.translate(0.0f, -1.3135f, -0.15625f);
        this.model.setupAnim((SoyballEntity)((Object)llamaSpit), g, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(this.model.renderType(LLAMA_SPIT_LOCATION));
        this.model.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render(llamaSpit, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(T llamaSpit) {
        return LLAMA_SPIT_LOCATION;
    }
}

