/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.render.layer;

import baguchan.tofucraft.client.model.TofuGandlemModel;
import baguchan.tofucraft.entity.TofuGandlem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TofuGandlemEmissiveLayer<T extends TofuGandlem, M extends TofuGandlemModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation texture;
    private final AlphaFunction<T> alphaFunction;
    private final DrawSelector<T, M> drawSelector;

    public TofuGandlemEmissiveLayer(RenderLayerParent<T, M> p_234885_, ResourceLocation p_234886_, AlphaFunction<T> p_234887_, DrawSelector<T, M> p_234888_) {
        super(p_234885_);
        this.texture = p_234886_;
        this.alphaFunction = p_234887_;
        this.drawSelector = p_234888_;
    }

    public void render(PoseStack p_234902_, MultiBufferSource p_234903_, int p_234904_, T p_234905_, float p_234906_, float p_234907_, float p_234908_, float p_234909_, float p_234910_, float p_234911_) {
        if (!p_234905_.isInvisible()) {
            this.onlyDrawSelectedParts();
            VertexConsumer vertexconsumer = p_234903_.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)this.texture));
            ((TofuGandlemModel)this.getParentModel()).renderToBuffer(p_234902_, vertexconsumer, p_234904_, LivingEntityRenderer.getOverlayCoords(p_234905_, (float)0.0f));
            this.resetDrawForAllParts();
        }
    }

    private void onlyDrawSelectedParts() {
        List<ModelPart> list = this.drawSelector.getPartsToDraw((TofuGandlemModel)this.getParentModel());
        ((TofuGandlemModel)this.getParentModel()).root().getAllParts().forEach(p_234918_ -> {
            p_234918_.skipDraw = true;
        });
        list.forEach(p_234916_ -> {
            p_234916_.skipDraw = false;
        });
    }

    private void resetDrawForAllParts() {
        ((TofuGandlemModel)this.getParentModel()).root().getAllParts().forEach(p_234913_ -> {
            p_234913_.skipDraw = false;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface AlphaFunction<T extends TofuGandlem> {
        public float apply(T var1, float var2, float var3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface DrawSelector<T extends TofuGandlem, M extends EntityModel<T>> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

