/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.screen;

import baguchan.tofucraft.blockentity.SaltFurnaceBlockEntity;
import baguchan.tofucraft.client.ClientProxy;
import baguchan.tofucraft.inventory.SaltFurnaceMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SaltFurnaceScreen
extends AbstractContainerScreen<SaltFurnaceMenu> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/salt_furnace.png");

    public SaltFurnaceScreen(SaltFurnaceMenu p_i51104_1_, Inventory p_i51104_3_, Component p_i51104_4_) {
        super((AbstractContainerMenu)p_i51104_1_, p_i51104_3_, p_i51104_4_);
    }

    public void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(GuiGraphics p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        super.render(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.renderTooltip(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    protected void renderBg(GuiGraphics p_230450_1_, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        FluidTank fluidTank2;
        int heightInd2;
        FluidTank fluidTank;
        int heightInd;
        int i = this.leftPos;
        int j = this.topPos;
        p_230450_1_.blit(texture, i, j, 0, 0, this.imageWidth, this.imageHeight);
        if (((SaltFurnaceMenu)this.menu).isLit()) {
            int k = ((SaltFurnaceMenu)this.menu).getLitProgress();
            p_230450_1_.blit(texture, i + 23, j + 36 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        int l = ((SaltFurnaceMenu)this.menu).getBurnProgress();
        p_230450_1_.blit(texture, i + 54, j + 54, 176, 14, l + 1, 16);
        p_230450_1_.pose().pushPose();
        if (ClientProxy.PROXY.getRefrencedTE() instanceof SaltFurnaceBlockEntity && ((SaltFurnaceBlockEntity)ClientProxy.PROXY.getRefrencedTE()).bitternTank.getFluid() != null && (heightInd = (int)(44.0f * (float)(fluidTank = ((SaltFurnaceBlockEntity)ClientProxy.PROXY.getRefrencedTE()).bitternTank).getFluidAmount() / (float)fluidTank.getCapacity())) > 0) {
            SaltFurnaceScreen.renderFluidStack(p_230450_1_.pose(), i + 145, j + 69, 10, heightInd, fluidTank.getFluid().getFluid());
        }
        p_230450_1_.pose().popPose();
        p_230450_1_.pose().pushPose();
        if (ClientProxy.PROXY.getRefrencedTE() instanceof SaltFurnaceBlockEntity && ((SaltFurnaceBlockEntity)ClientProxy.PROXY.getRefrencedTE()).waterTank.getFluid() != null && (heightInd2 = (int)(44.0f * (float)(fluidTank2 = ((SaltFurnaceBlockEntity)ClientProxy.PROXY.getRefrencedTE()).waterTank).getFluidAmount() / (float)fluidTank2.getCapacity())) > 0) {
            SaltFurnaceScreen.renderFluidStack(p_230450_1_.pose(), i + 158, j + 69, 10, heightInd2, fluidTank2.getFluid().getFluid());
        }
        p_230450_1_.pose().popPose();
    }

    public static void renderFluidStack(PoseStack stack, int xPosition, int yPosition, int desiredWidth, int desiredHeight, Fluid fluid) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
        int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        int xTileCount = desiredWidth / 16;
        int xRemainder = desiredWidth - xTileCount * 16;
        int yTileCount = desiredHeight / 16;
        int yRemainder = desiredHeight - yTileCount * 16;
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        RenderSystem.enableBlend();
        BufferBuilder vertexBuffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f matrix4f = stack.last().pose();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : 16;
            if (width == 0) break;
            int x = xPosition + xTile * 16;
            int maskRight = 16 - width;
            int shiftedX = x + 16 - maskRight;
            float uLocalDif = uDif * (float)maskRight / 16.0f;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : 16;
                if (height == 0) continue block0;
                int y = yPosition - (yTile + 1) * 16;
                int maskTop = 16 - height;
                float vLocalDif = vDif * (float)maskTop / 16.0f;
                vertexBuffer.addVertex(matrix4f, (float)x, (float)(y + 16), 0.0f).setUv(uMin + uLocalDif, vMax).setColor(red, green, blue, alpha);
                vertexBuffer.addVertex(matrix4f, (float)shiftedX, (float)(y + 16), 0.0f).setUv(uMax, vMax).setColor(red, green, blue, alpha);
                vertexBuffer.addVertex(matrix4f, (float)shiftedX, (float)(y + maskTop), 0.0f).setUv(uMax, vMin + vLocalDif).setColor(red, green, blue, alpha);
                vertexBuffer.addVertex(matrix4f, (float)x, (float)(y + maskTop), 0.0f).setUv(uMin + uLocalDif, vMin + vLocalDif).setColor(red, green, blue, alpha);
            }
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

