/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.compat.jei;

import baguchan.tofucraft.compat.jei.BitternCategory;
import baguchan.tofucraft.compat.jei.HardenCategory;
import baguchan.tofucraft.recipe.BitternRecipe;
import baguchan.tofucraft.recipe.HardenRecipe;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuRecipes;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"jei_plugin");
    private static final Minecraft MC = Minecraft.getInstance();
    public static final RecipeType<HardenRecipe> HARDEN_JEI_TYPE = RecipeType.create((String)"tofucraft", (String)"harden", HardenRecipe.class);
    public static final RecipeType<BitternRecipe> BITTERN_JEI_TYPE = RecipeType.create((String)"tofucraft", (String)"bittern", BitternRecipe.class);

    private static <C extends RecipeInput, T extends Recipe<C>> List<T> findRecipesByType(net.minecraft.world.item.crafting.RecipeType<T> type) {
        return JEIPlugin.MC.level.getRecipeManager().getAllRecipesFor(type).stream().map(recipeholder -> recipeholder.value()).toList();
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new HardenCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BitternCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        JEIPlugin.addInfo(registration, (Item)TofuItems.BITTERN_BOTTLE.get());
        JEIPlugin.addInfo(registration, ((Block)TofuBlocks.KINUTOFU.get()).asItem());
        JEIPlugin.addInfo(registration, ((Block)TofuBlocks.MOMENTOFU.get()).asItem());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_APPLE.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_ANNIN.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_PUDDING.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_PUMPKIN.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_STRAWBERRY.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_FRUITS.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_TEA.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_HONEY.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_RAMUNE.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_SAKURA.get(), (Item)TofuItems.SOYMILK.get());
        registration.addRecipes(HARDEN_JEI_TYPE, JEIPlugin.findRecipesByType(TofuRecipes.RECIPETYPE_HARDER.get()));
        registration.addRecipes(BITTERN_JEI_TYPE, JEIPlugin.findRecipesByType(TofuRecipes.RECIPETYPE_BITTERN.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.COBBLESTONE), new RecipeType[]{HARDEN_JEI_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TofuItems.BITTERN_BOTTLE.get()), new RecipeType[]{BITTERN_JEI_TYPE});
    }

    private static void addInfo(IRecipeRegistration registration, Item item) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("tofucraft." + BuiltInRegistries.ITEM.getKey((Object)item).getPath() + ".jei_desc"))});
    }

    private static void addInfo(IRecipeRegistration registration, Item item, Item originalDescItem) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("tofucraft." + BuiltInRegistries.ITEM.getKey((Object)originalDescItem).getPath() + ".jei_desc"))});
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }
}

