/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import baguchan.tofucraft.registry.TofuBiomes;
import baguchan.tofucraft.registry.TofuEntityTypes;
import baguchan.tofucraft.registry.TofuFluids;
import baguchan.tofucraft.registry.TofuTags;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.Nullable;

public class TofuCow
extends Cow {
    private static final EntityDataAccessor<String> TOFUCOW_TYPE = SynchedEntityData.defineId(TofuCow.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public TofuCow(EntityType<? extends Cow> p_28285_, Level p_28286_) {
        super(p_28285_, p_28286_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TOFUCOW_TYPE, (Object)TofuCowType.NORMAL.name());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of(TofuTags.Items.TOFU_COW_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("TofuCowType", this.getTofuCowType().name());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("TofuCowType")) {
            this.setTofuCowType(TofuCowType.get(compound.getString("TofuCowType")));
        }
    }

    public void setTofuCowType(TofuCowType type) {
        this.entityData.set(TOFUCOW_TYPE, (Object)type.name());
    }

    public TofuCowType getTofuCowType() {
        return TofuCowType.get((String)this.entityData.get(TOFUCOW_TYPE));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_) {
        if (p_146746_.getBiome(this.blockPosition()).is(TofuBiomes.ZUNDA_FOREST)) {
            this.setTofuCowType(TofuCowType.ZUNDA);
        }
        return super.finalizeSpawn(p_146746_, p_146747_, p_146748_, p_146749_);
    }

    public static boolean checkTofuAnimalSpawnRules(EntityType<? extends Animal> p_27578_, LevelAccessor p_27579_, MobSpawnType p_27580_, BlockPos p_27581_, RandomSource p_27582_) {
        return p_27579_.getBlockState(p_27581_.below()).is(TofuTags.Blocks.TOFU_TERRAIN) && p_27579_.getRawBrightness(p_27581_, 0) > 8;
    }

    public InteractionResult mobInteract(Player p_28298_, InteractionHand p_28299_) {
        IFluidHandlerItem handler;
        ItemStack itemstack = p_28298_.getItemInHand(p_28299_);
        if (!this.isBaby() && (handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemstack.copyWithCount(1)).orElse(null)) != null && handler instanceof FluidBucketWrapper && ((FluidBucketWrapper)handler).getFluid().isEmpty()) {
            p_28298_.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            AtomicReference<ItemStack> resultItemStack = new AtomicReference<ItemStack>(itemstack.copy());
            FluidUtil.getFluidHandler((ItemStack)resultItemStack.get()).ifPresent(fluidHandler -> {
                fluidHandler.fill(new FluidStack((Fluid)TofuFluids.SOYMILK.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                resultItemStack.set(fluidHandler.getContainer());
            });
            p_28298_.setItemInHand(p_28299_, resultItemStack.get());
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(p_28298_, p_28299_);
    }

    public TofuCow getBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_) {
        TofuCow tofuCow = (TofuCow)TofuEntityTypes.TOFUCOW.get().create((Level)p_148890_);
        if (tofuCow != null) {
            TofuCowType variant = this.random.nextBoolean() ? this.getTofuCowType() : ((TofuCow)p_148891_).getTofuCowType();
            tofuCow.setTofuCowType(variant);
        }
        return tofuCow;
    }

    public boolean isFood(ItemStack p_335696_) {
        return p_335696_.is(TofuTags.Items.TOFU_COW_FOOD);
    }

    public static enum TofuCowType {
        NORMAL,
        ZUNDA;


        public static TofuCowType get(String nameIn) {
            for (TofuCowType role : TofuCowType.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return NORMAL;
        }
    }
}

