/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity.goal;

import baguchan.tofucraft.entity.TofuGandlem;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class SpinAttackGoal
extends Goal {
    private final TofuGandlem gandlem;
    private int attackTime;
    private int cooldown;
    private int maxCooldown;
    private final UniformInt timeBetweenCooldown;

    public SpinAttackGoal(TofuGandlem p_32247_, UniformInt rushCooldown) {
        this.gandlem = p_32247_;
        this.timeBetweenCooldown = rushCooldown;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.gandlem.isInWall() && this.gandlem.hurtMarked) {
            return true;
        }
        if (this.maxCooldown <= 0) {
            this.maxCooldown = this.timeBetweenCooldown.sample(this.gandlem.getRandom());
            return false;
        }
        if (this.cooldown > this.maxCooldown) {
            LivingEntity livingentity = this.gandlem.getTarget();
            if (livingentity != null && livingentity.isAlive() && this.gandlem.canAttack(livingentity) && this.gandlem.hasLineOfSight((Entity)livingentity) && !this.gandlem.isCharging()) {
                this.cooldown = 0;
                this.maxCooldown = this.timeBetweenCooldown.sample(this.gandlem.getRandom());
                return true;
            }
        } else {
            ++this.cooldown;
            return false;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.gandlem.getAction() == TofuGandlem.Actions.START_RUSH;
    }

    public void start() {
        super.start();
        this.attackTime = 0;
        this.gandlem.setAction(TofuGandlem.Actions.START_RUSH);
    }

    public void tick() {
        LivingEntity livingentity;
        super.tick();
        ++this.attackTime;
        if (this.attackTime <= 10 && (livingentity = this.gandlem.getTarget()) != null) {
            this.gandlem.lookAt((Entity)livingentity, 90.0f, 90.0f);
        }
        if (this.attackTime == 24) {
            this.gandlem.setRush(true);
            this.gandlem.playSound((SoundEvent)SoundEvents.TRIDENT_RIPTIDE_3.value(), 3.0f, 1.0f);
        }
        if (this.attackTime < 40 && this.attackTime > 24) {
            float f7 = this.gandlem.getYRot();
            float f = this.gandlem.getXRot();
            float f1 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f2 = -Mth.sin((float)(f * ((float)Math.PI / 180)));
            float f3 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f4 = Mth.sqrt((float)(f1 * f1 + f2 * f2 + f3 * f3));
            float f5 = 0.55f;
            this.gandlem.setDeltaMovement(f1 *= f5 / f4, f2 *= f5 / f4, f3 *= f5 / f4);
        }
        if (this.attackTime == 40) {
            this.gandlem.setRush(false);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

