/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.fluid;

import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuFluidTypes;
import baguchan.tofucraft.registry.TofuFluids;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public abstract class SoyMilkFluid
extends WaterFluid {
    public Fluid getFlowing() {
        return (Fluid)TofuFluids.SOYMILK_FLOW.get();
    }

    public Fluid getSource() {
        return (Fluid)TofuFluids.SOYMILK.get();
    }

    public Item getBucket() {
        return (Item)TofuItems.BUCKET_SOYMILK.get();
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return (ParticleOptions)TofuParticleTypes.DRIP_SOYMILK_HANG.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(Level level, BlockPos blockPos, FluidState fluidState, RandomSource randomSource) {
        if (!fluidState.isSource() && !((Boolean)fluidState.getValue((Property)FALLING)).booleanValue() && randomSource.nextInt(64) == 0) {
            level.playLocalSound((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, randomSource.nextFloat() * 0.25f + 0.75f, randomSource.nextFloat() + 0.5f, false);
        }
        if (fluidState.isSource() && randomSource.nextInt(5) == 0 && level.getBlockState(blockPos.below()).is(Blocks.MAGMA_BLOCK)) {
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, (double)((float)blockPos.getX() + randomSource.nextFloat()), (double)blockPos.getY() + (double)0.95f + (double)(randomSource.nextFloat() * 0.1f), (double)blockPos.getZ() + (double)randomSource.nextFloat(), 0.0, 0.0, 0.0);
            level.playLocalSound((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, randomSource.nextFloat() * 0.25f + 0.75f, randomSource.nextFloat() + 0.5f, false);
        }
    }

    protected void randomTick(Level level, BlockPos blockPos, FluidState fluidState, RandomSource randomSource) {
        if (!level.isClientSide() && randomSource.nextInt(4) == 0 && level.getBlockState(blockPos.above()).isAir() && level.getBlockState(blockPos.below()).is(Blocks.MAGMA_BLOCK)) {
            level.setBlock(blockPos.above(), ((Block)TofuBlocks.YUBA.get()).defaultBlockState(), 3);
        }
    }

    public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return false;
    }

    public BlockState createLegacyBlock(FluidState p_204527_1_) {
        return (BlockState)((Block)TofuBlocks.SOYMILK.get()).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(SoyMilkFluid.getLegacyLevel((FluidState)p_204527_1_)));
    }

    public boolean isSame(Fluid p_207187_1_) {
        return p_207187_1_ == TofuFluids.SOYMILK.get() || p_207187_1_ == TofuFluids.SOYMILK_FLOW.get();
    }

    public boolean canBeReplacedWith(FluidState p_76233_, BlockGetter p_76234_, BlockPos p_76235_, Fluid p_76236_, Direction p_76237_) {
        return !this.isSame(p_76236_);
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public FluidType getFluidType() {
        return TofuFluidTypes.SOYMILK.get();
    }

    public static class Source
    extends SoyMilkFluid {
        public int getAmount(FluidState p_207192_1_) {
            return 8;
        }

        public boolean isSource(FluidState p_207193_1_) {
            return true;
        }

        protected boolean isRandomlyTicking() {
            return true;
        }
    }

    public static class Flowing
    extends SoyMilkFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> p_207184_1_) {
            super.createFluidStateDefinition(p_207184_1_);
            p_207184_1_.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState p_207192_1_) {
            return (Integer)p_207192_1_.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState p_207193_1_) {
            return false;
        }

        protected boolean isRandomlyTicking() {
            return false;
        }
    }
}

