/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.item;

import baguchan.tofucraft.api.IFluidBottle;
import baguchan.tofucraft.capability.wrapper.FluidBottleWrapper;
import baguchan.tofucraft.utils.ContainerUtils;
import baguchan.tofucraft.utils.RecipeHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class BitternItem
extends Item
implements IFluidBottle {
    protected final Holder<Fluid> fluidHolder;

    public BitternItem(Holder<Fluid> fluidHolder, Item.Properties group) {
        super(group);
        this.fluidHolder = fluidHolder;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult blockraytraceresult = BitternItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockHitResult blockraytraceresult1 = blockraytraceresult.withPosition(blockraytraceresult.getBlockPos());
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)itemstack.copyWithCount(1)).orElse(null);
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            if (handler instanceof FluidBottleWrapper) {
                FluidState fluidState;
                ItemStack result;
                FluidBottleWrapper fluidBottleWrapper = (FluidBottleWrapper)handler;
                if (blockraytraceresult.getType() == HitResult.Type.MISS) {
                    return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
                }
                if (blockraytraceresult.getType() == HitResult.Type.BLOCK && (result = RecipeHelper.getBitternResult(serverLevel, (fluidState = worldIn.getFluidState(blockraytraceresult1.getBlockPos())).getType(), fluidBottleWrapper.getFluid())) != null) {
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                        CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockraytraceresult1.getBlockPos(), itemstack);
                    }
                    worldIn.setBlock(blockraytraceresult1.getBlockPos(), Block.byItem((Item)result.getItem()).defaultBlockState(), 11);
                    worldIn.levelEvent(2001, blockraytraceresult1.getBlockPos(), Block.getId((BlockState)worldIn.getBlockState(blockraytraceresult1.getBlockPos())));
                    worldIn.playSound(null, blockraytraceresult1.getBlockPos(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ContainerUtils.addWithContainer(playerIn, handIn, itemstack, new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
                }
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    @Override
    public Holder<Fluid> getFluid() {
        return this.fluidHolder;
    }
}

