/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.item.tool;

import baguchan.tofucraft.api.tfenergy.IEnergyInsertable;
import baguchan.tofucraft.registry.TofuDimensions;
import baguchan.tofucraft.world.TofuPortalShape;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.portal.PortalShape;

public class TofuStickItem
extends Item
implements IEnergyInsertable {
    public TofuStickItem(Item.Properties tab) {
        super(tab);
    }

    public InteractionResult useOn(UseOnContext context) {
        Optional<TofuPortalShape> optional;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        if (TofuStickItem.inPortalDimension(level) && (optional = TofuPortalShape.findEmptyPortalShape((LevelAccessor)level, pos.offset(context.getClickedFace().getNormal()), Direction.Axis.X)).isPresent()) {
            optional.get().createPortalBlocks();
            if (!player.isCreative()) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            }
            level.playSound(player, pos, SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.BLOCKS, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private static boolean inPortalDimension(Level p_49249_) {
        return p_49249_.dimension() == Level.OVERWORLD || p_49249_.dimension() == TofuDimensions.tofu_world;
    }

    private static boolean isPortal(Level p_49270_, BlockPos p_49271_, Direction p_49272_) {
        if (!TofuStickItem.inPortalDimension(p_49270_)) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_49271_.mutable();
        boolean flag = false;
        for (Direction direction : Direction.values()) {
            if (!p_49270_.getBlockState((BlockPos)blockpos$mutableblockpos.set((Vec3i)p_49271_).move(direction)).isPortalFrame((BlockGetter)p_49270_, (BlockPos)blockpos$mutableblockpos)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        Direction.Axis direction$axis = p_49272_.getAxis().isHorizontal() ? p_49272_.getCounterClockWise().getAxis() : Direction.Plane.HORIZONTAL.getRandomAxis(p_49270_.random);
        return PortalShape.findEmptyPortalShape((LevelAccessor)p_49270_, (BlockPos)p_49271_, (Direction.Axis)direction$axis).isPresent();
    }

    public boolean isFoil(ItemStack p_77636_1_) {
        return true;
    }

    @Override
    public int fill(ItemStack inst, int energy, boolean simulate) {
        int calculated = Math.min(energy, inst.getDamageValue());
        if (!simulate && inst.getDamageValue() > 0) {
            inst.setDamageValue(Mth.clamp((int)(inst.getDamageValue() - calculated), (int)0, (int)inst.getMaxDamage()));
            return calculated * 5;
        }
        return 0;
    }
}

