/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.item.tool;

import baguchan.tofucraft.api.tfenergy.IEnergyInsertable;
import baguchan.tofucraft.registry.TofuEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class TofuSwordItem
extends SwordItem
implements IEnergyInsertable {
    public TofuSwordItem(Tier tofuItemTier, Item.Properties properties) {
        super(tofuItemTier, properties);
    }

    public boolean hurtEnemy(ItemStack itemStack, LivingEntity targetEntity, LivingEntity attacker) {
        float healthBeforeAttack = (float)attacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float damage = healthBeforeAttack - targetEntity.getHealth();
        if (damage > 0.0f) {
            int lvl = EnchantmentHelper.getEnchantmentLevel((Holder)attacker.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(TofuEnchantments.DRAIN), (LivingEntity)attacker);
            attacker.heal(damage * ((float)lvl * 0.1f + 0.1f));
        }
        return super.hurtEnemy(itemStack, targetEntity, attacker);
    }

    @Override
    public int fill(ItemStack inst, int energy, boolean simulate) {
        int calculated = Math.min(energy, inst.getDamageValue());
        if (!simulate && inst.getDamageValue() > 0) {
            inst.setDamageValue(Mth.clamp((int)(inst.getDamageValue() - calculated), (int)0, (int)inst.getMaxDamage()));
            return calculated * 5;
        }
        return 0;
    }
}

