/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.registry;

import baguchan.tofucraft.entity.FukumameThower;
import baguchan.tofucraft.entity.ShuDofuSpider;
import baguchan.tofucraft.entity.TofuCow;
import baguchan.tofucraft.entity.TofuCreeper;
import baguchan.tofucraft.entity.TofuFish;
import baguchan.tofucraft.entity.TofuGandlem;
import baguchan.tofucraft.entity.TofuGolem;
import baguchan.tofucraft.entity.TofuPig;
import baguchan.tofucraft.entity.TofuSlime;
import baguchan.tofucraft.entity.TofuSpider;
import baguchan.tofucraft.entity.Tofunian;
import baguchan.tofucraft.entity.TravelerTofunian;
import baguchan.tofucraft.entity.Zundamite;
import baguchan.tofucraft.entity.effect.NattoCobWebEntity;
import baguchan.tofucraft.entity.projectile.FallingTofuEntity;
import baguchan.tofucraft.entity.projectile.FukumameEntity;
import baguchan.tofucraft.entity.projectile.NattoBallEntity;
import baguchan.tofucraft.entity.projectile.NattoStringEntity;
import baguchan.tofucraft.entity.projectile.NetherFukumameEntity;
import baguchan.tofucraft.entity.projectile.SoulFukumameEntity;
import baguchan.tofucraft.entity.projectile.SoyballEntity;
import baguchan.tofucraft.entity.projectile.ZundaArrow;
import baguchan.tofucraft.registry.TofuFluidTypes;
import baguchan.tofucraft.registry.TofuTags;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="tofucraft", bus=EventBusSubscriber.Bus.MOD)
public class TofuEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"tofucraft");
    public static final Supplier<EntityType<Tofunian>> TOFUNIAN = ENTITIES.register("tofunian", () -> EntityType.Builder.of(Tofunian::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.2f).eyeHeight(0.96000004f).passengerAttachments(new float[]{1.2f}).ridingOffset(-0.3f).clientTrackingRange(10).build("tofucraft:tofunian"));
    public static final Supplier<EntityType<TravelerTofunian>> TRAVELER_TOFUNIAN = ENTITIES.register("traveler_tofunian", () -> EntityType.Builder.of(TravelerTofunian::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.2f).eyeHeight(0.96000004f).build("tofucraft:traveler_tofunian"));
    public static final Supplier<EntityType<TofuCow>> TOFUCOW = ENTITIES.register("tofucow", () -> EntityType.Builder.of(TofuCow::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).eyeHeight(1.12f).build("tofucraft:tofucow"));
    public static final Supplier<EntityType<TofuPig>> TOFUPIG = ENTITIES.register("tofupig", () -> EntityType.Builder.of(TofuPig::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 0.9f).eyeHeight(0.71999997f).build("tofucraft:tofupig"));
    public static final Supplier<EntityType<TofuFish>> TOFUFISH = ENTITIES.register("tofufish", () -> EntityType.Builder.of(TofuFish::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.35f).eyeHeight(0.3f).setTrackingRange(4).build("tofucraft:tofufish"));
    public static final Supplier<EntityType<TofuGolem>> TOFU_GOLEM = ENTITIES.register("tofu_golem", () -> EntityType.Builder.of(TofuGolem::new, (MobCategory)MobCategory.MISC).sized(0.8f, 0.9f).eyeHeight(0.495f).clientTrackingRange(10).fireImmune().build("tofucraft:tofu_golem"));
    public static final Supplier<EntityType<TofuGandlem>> TOFU_GANDLEM = ENTITIES.register("tofu_gandlem", () -> EntityType.Builder.of(TofuGandlem::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.6f).eyeHeight(1.2800001f).clientTrackingRange(10).fireImmune().build("tofucraft:tofu_gandlem"));
    public static final Supplier<EntityType<TofuSlime>> TOFUSLIME = ENTITIES.register("tofuslime", () -> EntityType.Builder.of(TofuSlime::new, (MobCategory)MobCategory.MONSTER).sized(0.52f, 0.52f).eyeHeight(0.325f).build("tofucraft:tofuslime"));
    public static final Supplier<EntityType<TofuCreeper>> TOFUCREEPER = ENTITIES.register("tofucreeper", () -> EntityType.Builder.of(TofuCreeper::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.6f).build("tofucraft:tofucreeper"));
    public static final Supplier<EntityType<TofuSpider>> TOFUSPIDER = ENTITIES.register("tofuspider", () -> EntityType.Builder.of(TofuSpider::new, (MobCategory)MobCategory.MONSTER).sized(0.95f, 0.55f).eyeHeight(0.3f).build("tofucraft:tofuspider"));
    public static final Supplier<EntityType<Zundamite>> ZUNDAMITE = ENTITIES.register("zundamite", () -> EntityType.Builder.of(Zundamite::new, (MobCategory)MobCategory.MONSTER).sized(0.4f, 0.3f).eyeHeight(0.13f).clientTrackingRange(8).build("tofucraft:zundamite"));
    public static final Supplier<EntityType<FukumameEntity>> FUKUMAME = ENTITIES.register("fukumame", () -> EntityType.Builder.of(FukumameEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).updateInterval(30).build("tofucraft:fukumame"));
    public static final Supplier<EntityType<NetherFukumameEntity>> NETHER_FUKUMAME = ENTITIES.register("nether_fukumame", () -> EntityType.Builder.of(NetherFukumameEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).updateInterval(30).build("tofucraft:nether_fukumame"));
    public static final Supplier<EntityType<SoulFukumameEntity>> SOUL_FUKUMAME = ENTITIES.register("soul_fukumame", () -> EntityType.Builder.of(SoulFukumameEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).updateInterval(30).build("tofucraft:soul_fukumame"));
    public static final Supplier<EntityType<SoyballEntity>> SOYBALL = ENTITIES.register("soyball", () -> EntityType.Builder.of(SoyballEntity::new, (MobCategory)MobCategory.MISC).sized(0.3f, 0.3f).updateInterval(30).build("tofucraft:soyball"));
    public static final Supplier<EntityType<NattoStringEntity>> NATTO_STRNIG = ENTITIES.register("natto_string", () -> EntityType.Builder.of(NattoStringEntity::new, (MobCategory)MobCategory.MISC).sized(0.2f, 0.2f).updateInterval(40).build("tofucraft:natto_string"));
    public static final Supplier<EntityType<ZundaArrow>> ZUNDA_ARROW = ENTITIES.register("zunda_arrow", () -> EntityType.Builder.of(ZundaArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).updateInterval(40).build("tofucraft:zunda_arrow"));
    public static final Supplier<EntityType<NattoCobWebEntity>> NATTO_COBWEB = ENTITIES.register("natto_cobweb", () -> EntityType.Builder.of(NattoCobWebEntity::new, (MobCategory)MobCategory.MISC).sized(3.0f, 0.1f).updateInterval(10).fireImmune().build("tofucraft:natto_cobweb"));
    public static final Supplier<EntityType<NattoBallEntity>> NATTO_BALL = ENTITIES.register("natto_ball", () -> EntityType.Builder.of(NattoBallEntity::new, (MobCategory)MobCategory.MISC).sized(0.35f, 0.35f).updateInterval(20).build("tofucraft:natto_ball"));
    public static final Supplier<EntityType<FallingTofuEntity>> FALLING_TOFU = ENTITIES.register("falling_tofu", () -> EntityType.Builder.of(FallingTofuEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).updateInterval(20).build("tofucraft:falling_tofu"));
    public static final Supplier<EntityType<ShuDofuSpider>> SHUDOFUSPIDER = ENTITIES.register("shudofuspider", () -> EntityType.Builder.of(ShuDofuSpider::new, (MobCategory)MobCategory.CREATURE).sized(3.5f, 2.9f).eyeHeight(2.0f).clientTrackingRange(10).fireImmune().build("tofucraft:shudofuspider"));
    public static final Supplier<EntityType<FukumameThower>> FUKUMAME_THOWER = ENTITIES.register("fukumame_thower", () -> EntityType.Builder.of(FukumameThower::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.85f).eyeHeight(1.79f).passengerAttachments(new float[]{2.0125f}).ridingOffset(-0.7f).clientTrackingRange(8).build("tofucraft:fukumame_thower"));
    public static final SpawnPlacementType IN_DOUBANJIANG = (p_325672_, p_325673_, p_325674_) -> {
        if (p_325674_ != null && p_325672_.getWorldBorder().isWithinBounds(p_325673_)) {
            BlockPos blockpos = p_325673_.above();
            return p_325672_.getFluidState(p_325673_).getType() == TofuFluidTypes.DOUBANJIANG;
        }
        return false;
    };
    public static final SpawnPlacementType IN_SOYMILK = (p_325672_, p_325673_, p_325674_) -> {
        if (p_325674_ != null && p_325672_.getWorldBorder().isWithinBounds(p_325673_)) {
            BlockPos blockpos = p_325673_.above();
            return p_325672_.getFluidState(p_325673_).is(TofuTags.Fluids.SOYMILK) && !p_325672_.getBlockState(blockpos).isRedstoneConductor((BlockGetter)p_325672_, blockpos);
        }
        return false;
    };

    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        event.put(TOFUCOW.get(), TofuCow.createAttributes().build());
        event.put(TOFUPIG.get(), TofuPig.createAttributes().build());
        event.put(TOFUNIAN.get(), Tofunian.createAttributes().build());
        event.put(TRAVELER_TOFUNIAN.get(), Tofunian.createAttributes().build());
        event.put(TOFUFISH.get(), AbstractFish.createAttributes().build());
        event.put(TOFU_GOLEM.get(), TofuGolem.createAttributes().build());
        event.put(TOFUSLIME.get(), Monster.createMonsterAttributes().build());
        event.put(TOFUCREEPER.get(), TofuCreeper.createAttributes().build());
        event.put(TOFUSPIDER.get(), TofuSpider.createAttributes().build());
        event.put(ZUNDAMITE.get(), Zundamite.createAttributes().build());
        event.put(TOFU_GANDLEM.get(), TofuGandlem.createAttributes().build());
        event.put(SHUDOFUSPIDER.get(), ShuDofuSpider.createAttributes().build());
        event.put(NATTO_COBWEB.get(), NattoCobWebEntity.createAttributes().build());
        event.put(FUKUMAME_THOWER.get(), FukumameThower.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerEntityAttribute(RegisterSpawnPlacementsEvent event) {
        event.register(TOFUCOW.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TofuCow::checkTofuAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUPIG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TofuPig::checkTofuAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUNIAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TRAVELER_TOFUNIAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFU_GOLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUSLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TofuSlime::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUCREEPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUSPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUFISH.get(), IN_SOYMILK, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TofuFish::checkTofuFishSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFU_GANDLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(FUKUMAME_THOWER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FukumameThower::checkFukumameSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ZUNDAMITE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }
}

