/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.utils;

import baguchan.tofucraft.recipe.BitternRecipe;
import baguchan.tofucraft.recipe.HardenRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RecipeHelper {
    @Nullable
    public static ItemStack getTofu(ServerLevel serverLevel, Block block) {
        RecipeManager manager = serverLevel.getRecipeManager();
        if (block.asItem() != null) {
            Stream<RecipeHolder> tofuRecipe = manager.getRecipes().stream().filter(recipe -> {
                HardenRecipe hardenRecipe;
                Recipe patt0$temp = recipe.value();
                return patt0$temp instanceof HardenRecipe && (hardenRecipe = (HardenRecipe)patt0$temp).getType() == TofuRecipes.RECIPETYPE_HARDER.get();
            });
            for (RecipeHolder recipe2 : tofuRecipe.collect(Collectors.toList())) {
                HardenRecipe hardenRecipe;
                Recipe recipe3 = recipe2.value();
                if (!(recipe3 instanceof HardenRecipe) || !(hardenRecipe = (HardenRecipe)recipe3).getTofu().test(new ItemStack((ItemLike)block.asItem()))) continue;
                return ((HardenRecipe)recipe2.value()).getResultItem((HolderLookup.Provider)serverLevel.registryAccess());
            }
        }
        return null;
    }

    @Nullable
    public static ItemStack getBitternResult(ServerLevel serverLevel, Fluid fluid, FluidStack extraFluid) {
        RecipeManager manager = serverLevel.getRecipeManager();
        if (fluid != null) {
            Stream<RecipeHolder> tofuRecipe = manager.getRecipes().stream().filter(recipe -> {
                BitternRecipe bittern;
                Recipe patt0$temp = recipe.value();
                return patt0$temp instanceof BitternRecipe && (bittern = (BitternRecipe)patt0$temp).getType() == TofuRecipes.RECIPETYPE_BITTERN.get();
            });
            for (RecipeHolder recipe2 : tofuRecipe.collect(Collectors.toList())) {
                BitternRecipe bitternRecipe;
                Recipe recipe3 = recipe2.value();
                if (!(recipe3 instanceof BitternRecipe) || !(bitternRecipe = (BitternRecipe)recipe3).getFluid().is(fluid) || bitternRecipe.getExtraFluid().getFluid() != extraFluid.getFluid()) continue;
                return bitternRecipe.getResultItem((HolderLookup.Provider)serverLevel.registryAccess());
            }
        }
        return null;
    }

    public static RecipeManager getManager() {
        return RecipeHelper.getManager(null);
    }

    public static RecipeManager getManager(@Nullable RecipeManager manager) {
        if (manager != null) {
            return manager;
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return Minecraft.getInstance().player.connection.getRecipeManager();
        }
        return ServerLifecycleHooks.getCurrentServer().getRecipeManager();
    }
}

