/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.world.gen.feature;

import baguchan.tofucraft.registry.TofuTags;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class TofuBlobFeature
extends Feature<BlockStateConfiguration> {
    public TofuBlobFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> p_159471_) {
        BlockState blockstate;
        BlockPos blockpos = p_159471_.origin();
        WorldGenLevel worldgenlevel = p_159471_.level();
        RandomSource random = p_159471_.random();
        BlockStateConfiguration blockstateconfiguration = (BlockStateConfiguration)p_159471_.config();
        while (blockpos.getY() > worldgenlevel.getMinBuildHeight() + 3 && (worldgenlevel.isEmptyBlock(blockpos.below()) || !TofuBlobFeature.isTofu(blockstate = worldgenlevel.getBlockState(blockpos.below())))) {
            blockpos = blockpos.below();
        }
        if (blockpos.getY() <= worldgenlevel.getMinBuildHeight() + 3) {
            return false;
        }
        for (int l = 0; l < 3; ++l) {
            int i = random.nextInt(2);
            int j = random.nextInt(2);
            int k = random.nextInt(2);
            float f = (float)(i + j + k) * 0.333f + 0.5f;
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)blockpos.offset(-i, -j, -k), (BlockPos)blockpos.offset(i, j, k))) {
                if (!(blockpos1.distSqr((Vec3i)blockpos) <= (double)(f * f))) continue;
                worldgenlevel.setBlock(blockpos1, blockstateconfiguration.state, 4);
            }
            blockpos = blockpos.offset(-1 + random.nextInt(2), -random.nextInt(2), -1 + random.nextInt(2));
        }
        return true;
    }

    public static boolean isTofu(BlockState p_159760_) {
        return p_159760_.is(TofuTags.Blocks.TOFU_TERRAIN);
    }
}

