/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block.crop;

import baguchi.tofucraft.registry.TofuItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class SoybeanPaleCropsBlock
extends CropBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)};
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final BooleanProperty BLOOM = BooleanProperty.create((String)"bloom");

    public SoybeanPaleCropsBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)BLOOM, (Comparable)Boolean.valueOf(false)));
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public void animateTick(BlockState p_382850_, Level p_382933_, BlockPos p_382838_, RandomSource p_383190_) {
        BlockState blockstate;
        boolean flag = (Boolean)p_382850_.getValue((Property)BLOOM);
        int age = (Integer)p_382850_.getValue((Property)AGE);
        if (flag && age < 3 && p_383190_.nextInt(700) == 0 && (blockstate = p_382933_.getBlockState(p_382838_.below())).is(Blocks.PALE_MOSS_BLOCK)) {
            p_382933_.playLocalSound((double)p_382838_.getX(), (double)p_382838_.getY(), (double)p_382838_.getZ(), SoundEvents.EYEBLOSSOM_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        float f;
        this.tryChangingState(state, worldIn, pos, random);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        int i = this.getAge(state);
        if (i < this.getMaxAge() && CommonHooks.canCropGrow((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = SoybeanPaleCropsBlock.getGrowthSpeed(state, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.setBlock(pos, this.getStateForAge(i + 1), 2);
            CommonHooks.fireCropGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    protected void tick(BlockState p_382808_, ServerLevel p_383005_, BlockPos p_383211_, RandomSource p_383088_) {
        if (this.tryChangingState(p_382808_, p_383005_, p_383211_, p_383088_)) {
            // empty if block
        }
        super.tick(p_382808_, p_383005_, p_383211_, p_383088_);
    }

    private boolean tryChangingState(BlockState p_383235_, ServerLevel p_383091_, BlockPos p_383073_, RandomSource p_383038_) {
        boolean flag = (Boolean)p_383235_.getValue((Property)BLOOM);
        int age = (Integer)p_383235_.getValue((Property)AGE);
        if (age < 3) {
            return false;
        }
        if (!p_383091_.dimensionType().natural()) {
            return false;
        }
        if (p_383091_.isBrightOutside() != flag) {
            return false;
        }
        p_383091_.setBlock(p_383073_, (BlockState)p_383235_.setValue((Property)BLOOM, (Comparable)Boolean.valueOf(!flag)), 3);
        p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
        this.spawnTransformParticle(p_383091_, p_383073_, p_383038_, !flag);
        BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
            BlockState blockstate = p_383091_.getBlockState(p_383198_);
            if (blockstate == p_383235_) {
                double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
            }
        });
        if (flag) {
            p_383091_.playSound(null, p_383073_, SoundEvents.EYEBLOSSOM_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            p_383091_.playSound(null, p_383073_, SoundEvents.EYEBLOSSOM_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public void spawnTransformParticle(ServerLevel p_383084_, BlockPos p_383042_, RandomSource p_382825_, boolean flag) {
        Vec3 vec3 = p_383042_.getCenter();
        double d0 = 0.5 + p_382825_.nextDouble();
        Vec3 vec31 = new Vec3(p_382825_.nextDouble() - 0.5, p_382825_.nextDouble() + 1.0, p_382825_.nextDouble() - 0.5);
        Vec3 vec32 = vec3.add(vec31.scale(d0));
        TrailParticleOption trailparticleoption = new TrailParticleOption(vec32, flag ? 16545810 : 0x5F5F5F, (int)(20.0 * d0));
        p_383084_.sendParticles((ParticleOptions)trailparticleoption, vec3.x, vec3.y, vec3.z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    protected static float getGrowthSpeed(BlockState plant, ServerLevel p_52274_, BlockPos p_52275_) {
        boolean flag1;
        Block p_52273_ = plant.getBlock();
        float f = 1.0f;
        BlockPos blockpos = p_52275_.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = p_52274_.getBlockState(blockpos.offset(i, 0, j));
                TriState soilDecision = blockstate.canSustainPlant((BlockGetter)p_52274_, blockpos.offset(i, 0, j), Direction.UP, plant);
                if (soilDecision.isDefault() ? plant.canSurvive((LevelReader)p_52274_, blockpos.above().offset(i, 0, j)) : soilDecision.isTrue()) {
                    f1 = 1.0f;
                    if (blockstate.is(Blocks.PALE_MOSS_BLOCK)) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = p_52275_.north();
        BlockPos blockpos2 = p_52275_.south();
        BlockPos blockpos3 = p_52275_.west();
        BlockPos blockpos4 = p_52275_.east();
        boolean flag = p_52274_.getBlockState(blockpos3).is(p_52273_) || p_52274_.getBlockState(blockpos4).is(p_52273_);
        boolean bl = flag1 = p_52274_.getBlockState(blockpos1).is(p_52273_) || p_52274_.getBlockState(blockpos2).is(p_52273_);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = p_52274_.getBlockState(blockpos3.north()).is(p_52273_) || p_52274_.getBlockState(blockpos4.north()).is(p_52273_) || p_52274_.getBlockState(blockpos4.south()).is(p_52273_) || p_52274_.getBlockState(blockpos3.south()).is(p_52273_);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)TofuItems.SEEDS_SOYBEANS_PALE.get();
    }

    protected boolean mayPlaceOn(BlockState p_52302_, BlockGetter p_52303_, BlockPos p_52304_) {
        return p_52302_.is(Blocks.GRASS_BLOCK) || p_52302_.is(Blocks.PALE_MOSS_BLOCK);
    }

    public VoxelShape getShape(BlockState p_52297_, BlockGetter p_52298_, BlockPos p_52299_, CollisionContext p_52300_) {
        return SHAPES[(Integer)p_52297_.getValue((Property)AGE)];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_52286_) {
        p_52286_.add(new Property[]{AGE, BLOOM});
    }

    protected boolean isRandomlyTicking(BlockState p_52288_) {
        return true;
    }
}

