/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.blockentity;

import baguchi.tofucraft.block.TofuPotBlock;
import baguchi.tofucraft.blockentity.SyncedBlockEntity;
import baguchi.tofucraft.inventory.TofuPotMenu;
import baguchi.tofucraft.recipe.TofuPotRecipe;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuRecipes;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TofuPotBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
Nameable,
RecipeCraftingHolder,
Container,
StackedContentsCompatible {
    private static final Codec<Map<ResourceKey<Recipe<?>>, Integer>> RECIPES_USED_CODEC = Codec.unboundedMap((Codec)Recipe.KEY_CODEC, (Codec)Codec.INT);
    private static final Codec<ResourceKey<Recipe<?>>> RECIPE_CODEC = ResourceKey.codec((ResourceKey)Registries.RECIPE);
    public static final int CONTAINER_SLOT = 12;
    public static final int OUTPUT_SLOT = 13;
    public static final int INVENTORY_SIZE = 14;
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)14, (Object)ItemStack.EMPTY);
    private int cookTime;
    private int cookTimeTotal;
    private Component customName;
    protected final ContainerData cookingPotData;
    private final Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> recipesUsed = new Reference2IntOpenHashMap();
    private final RecipeManager.CachedCheck<CraftingInput, TofuPotRecipe> quickCheck;
    public FluidTank fluidTank = new FluidTank(3000){

        protected void onContentsChanged() {
            TofuPotBlockEntity.this.inventoryChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return true;
        }
    };

    public TofuPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TofuBlockEntitys.TOFU_POT.get(), pos, state);
        this.cookingPotData = this.createIntArray();
        this.quickCheck = RecipeManager.createCheck(TofuRecipes.RECIPETYPE_TOFU_POT.get());
    }

    public void loadAdditional(ValueInput compound) {
        super.loadAdditional(compound);
        this.inventory = NonNullList.withSize((int)14, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)compound, this.inventory);
        this.cookTime = compound.getIntOr("CookTime", 0);
        this.cookTimeTotal = compound.getIntOr("CookTimeTotal", 0);
        this.customName = TofuPotBlockEntity.parseCustomNameSafe((ValueInput)compound, (String)"CustomName");
        this.recipesUsed.clear();
        this.recipesUsed.putAll(compound.read("RecipesUsed", RECIPES_USED_CODEC).orElse(Map.of()));
        this.fluidTank.deserialize(compound.childOrEmpty("Tank"));
    }

    public void saveAdditional(ValueOutput compound) {
        super.saveAdditional(compound);
        compound.putInt("CookTime", this.cookTime);
        compound.putInt("CookTimeTotal", this.cookTimeTotal);
        compound.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
        ContainerHelper.saveAllItems((ValueOutput)compound, this.inventory);
        compound.store("RecipesUsed", RECIPES_USED_CODEC, this.recipesUsed);
        this.fluidTank.serialize(compound.child("Tank"));
    }

    public ItemStack getAsItem() {
        ItemStack stack = new ItemStack((ItemLike)TofuBlocks.TOFU_POT.get());
        stack.applyComponents(this.collectComponents());
        return stack;
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, TofuPotBlockEntity cookingPot) {
        boolean isHeated = cookingPot.isHeated(level, pos);
        boolean didInventoryChange = false;
        if (isHeated && cookingPot.hasInput()) {
            Optional<RecipeHolder<TofuPotRecipe>> recipe = cookingPot.getMatchingRecipe(CraftingInput.of((int)4, (int)3, cookingPot.inventory));
            if (recipe.isPresent() && cookingPot.canCook((TofuPotRecipe)recipe.get().value()) && (((TofuPotRecipe)recipe.get().value()).fluidIngredient().isEmpty() || ((TofuPotRecipe)recipe.get().value()).fluidIngredient().get().test(cookingPot.fluidTank.getFluid()))) {
                didInventoryChange = cookingPot.processCooking(recipe.get(), cookingPot);
            } else {
                cookingPot.cookTime = 0;
            }
        } else if (cookingPot.cookTime > 0) {
            cookingPot.cookTime = Mth.clamp((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
        }
        if (didInventoryChange) {
            cookingPot.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, TofuPotBlockEntity cookingPot) {
        RandomSource random;
        if (cookingPot.isHeated(level, pos) && (random = level.random).nextFloat() < 0.2f) {
            double x = (double)pos.getX() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
            double y = (double)pos.getY() + 1.2;
            double z = (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private Optional<RecipeHolder<TofuPotRecipe>> getMatchingRecipe(CraftingInput inventoryWrapper) {
        if (this.level == null) {
            return Optional.empty();
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.hasInput() ? this.quickCheck.getRecipeFor((RecipeInput)inventoryWrapper, serverLevel) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean hasInput() {
        for (int i = 0; i < 13; ++i) {
            if (((ItemStack)this.inventory.get(i)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(TofuPotRecipe recipe) {
        int i = this.getMaxStackSize();
        if (this.hasInput()) {
            ItemStack resultStack = recipe.getResult();
            if (resultStack.isEmpty()) {
                return false;
            }
            ItemStack storedMealStack = (ItemStack)this.inventory.get(13);
            if (storedMealStack.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)storedMealStack, (ItemStack)resultStack)) {
                return false;
            }
            if (storedMealStack.getCount() + resultStack.getCount() <= i && storedMealStack.getCount() + resultStack.getCount() <= storedMealStack.getMaxStackSize()) {
                return true;
            }
            return storedMealStack.getCount() + resultStack.getCount() <= resultStack.getMaxStackSize();
        }
        return false;
    }

    private boolean processCooking(RecipeHolder<TofuPotRecipe> recipe, TofuPotBlockEntity cookingPot) {
        if (this.level == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = ((TofuPotRecipe)recipe.value()).getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        ItemStack resultStack = ((TofuPotRecipe)recipe.value()).getResult();
        ItemStack storedMealStack = (ItemStack)this.inventory.get(13);
        if (storedMealStack.isEmpty()) {
            this.inventory.set(13, (Object)resultStack.copy());
        } else if (ItemStack.isSameItem((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            storedMealStack.grow(resultStack.getCount());
        }
        if (((TofuPotRecipe)recipe.value()).fluidIngredient().isPresent()) {
            cookingPot.fluidTank.drain(((TofuPotRecipe)recipe.value()).fluidIngredient().get().amount(), IFluidHandler.FluidAction.EXECUTE);
        }
        cookingPot.setRecipeUsed(recipe);
        for (int i = 0; i < 13; ++i) {
            ItemStack slotStack = (ItemStack)this.inventory.get(i);
            if (!slotStack.getCraftingRemainder().isEmpty()) {
                this.ejectIngredientRemainder(slotStack.getCraftingRemainder().copy());
            }
            if (slotStack.isEmpty()) continue;
            slotStack.shrink(1);
        }
        return true;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.getBlockState().getValue(TofuPotBlock.FACING)).getCounterClockWise();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.25;
        double y = (double)this.worldPosition.getY() + 0.7;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
        ItemEntity entity = new ItemEntity(this.level, x, y, z, remainderStack);
        entity.setDeltaMovement((double)((float)direction.getStepX() * 0.08f), 0.25, (double)((float)direction.getStepZ() * 0.08f));
        this.level.addFreshEntity((Entity)entity);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceKey recipeID = recipe.id();
            this.recipesUsed.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> items) {
        this.recipesUsed.clear();
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer p_155004_) {
        List<RecipeHolder<?>> list = this.getUsedRecipesAndPopExperience(p_155004_.level(), p_155004_.position());
        p_155004_.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            p_155004_.triggerRecipeCrafted(recipeholder, this.inventory);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getUsedRecipesAndPopExperience(ServerLevel level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Reference2IntMap.Entry entry : this.recipesUsed.reference2IntEntrySet()) {
            level.recipeAccess().byKey((ResourceKey)entry.getKey()).ifPresent(p_379268_ -> {
                list.add(p_379268_);
                TofuPotBlockEntity.splitAndSpawnExperience(level, pos, entry.getIntValue(), ((TofuPotRecipe)p_379268_.value()).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.floor((float)((float)craftedAmount * experience));
        float expFraction = Mth.frac((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public void preRemoveSideEffects(BlockPos p_393693_, BlockState p_393780_) {
        super.preRemoveSideEffects(p_393693_, p_393780_);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.getUsedRecipesAndPopExperience(serverlevel, Vec3.atCenterOf((Vec3i)p_393693_));
        }
    }

    public boolean isHeated() {
        if (this.level == null) {
            return false;
        }
        return this.isHeated(this.level, this.worldPosition);
    }

    private boolean isHeated(Level level, BlockPos worldPosition) {
        return level.getBlockState(worldPosition.below()).is(BlockTags.FIRE) || level.getBlockState(worldPosition.below()).is(BlockTags.CAMPFIRES);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < 14; ++i) {
            if (i == 13) continue;
            drops.add((Object)((ItemStack)this.inventory.get(i)));
        }
        return drops;
    }

    public Component getName() {
        return this.customName != null ? this.customName : Component.translatable((String)"container.tofucraft.tofu_pot");
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public AbstractContainerMenu createMenu(int id, Inventory player, Player entity) {
        return new TofuPotMenu(id, player, this, this.cookingPotData);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_324313_) {
        return this.saveCustomOnly(p_324313_);
    }

    protected void applyImplicitComponents(DataComponentGetter p_397929_) {
        super.applyImplicitComponents(p_397929_);
        this.customName = (Component)p_397929_.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void removeComponentsFromTag(ValueOutput p_422208_) {
        super.removeComponentsFromTag(p_422208_);
        p_422208_.discard("CustomName");
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(14){

            protected void onContentsChanged(int slot) {
                TofuPotBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> TofuPotBlockEntity.this.cookTime;
                    case 1 -> TofuPotBlockEntity.this.cookTimeTotal;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        TofuPotBlockEntity.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        TofuPotBlockEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public int getContainerSize() {
        return 14;
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.removeItem(this.inventory, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack removeItemNoUpdate(int p_70304_1_) {
        return ContainerHelper.takeItem(this.inventory, (int)p_70304_1_);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean stillValid(Player p_70300_1_) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)p_70300_1_);
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public void fillStackedContents(StackedItemContents stackedItemContents) {
        for (ItemStack itemstack : this.inventory) {
            stackedItemContents.accountSimpleStack(itemstack);
        }
    }
}

