/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.compat.jei;

import baguchi.tofucraft.compat.jei.JEIPlugin;
import baguchi.tofucraft.recipe.BitternRecipe;
import baguchi.tofucraft.registry.TofuItems;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class BitternCategory
implements IRecipeCategory<BitternRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"bittern");
    protected final IDrawableAnimated arrow;
    private final Component title = Component.translatable((String)"tofucraft.jei.bittern");
    private final IDrawable background;
    private final IDrawable icon;

    public BitternCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/general_jei_recipe.png");
        this.background = helper.createDrawable(backgroundImage, 16, 16, 144, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TofuItems.BITTERN_BOTTLE.get()));
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public int getWidth() {
        return 144;
    }

    public int getHeight() {
        return 54;
    }

    public ResourceLocation getRegistryName(BitternRecipe recipe) {
        return UID;
    }

    public IRecipeType<BitternRecipe> getRecipeType() {
        return JEIPlugin.BITTERN_JEI_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BitternRecipe recipe, IFocusGroup focuses) {
        FluidStack recipeIngredients = recipe.getFluid();
        int borderSlotSize = 18;
        builder.addSlot(RecipeIngredientRole.INPUT, 38, 18).setFluidRenderer(1000L, false, 16, 16).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipeIngredients));
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 18).setFluidRenderer(1000L, false, 16, 16).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.getFluid()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 18).add(recipe.getResult());
    }

    public void draw(BitternRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 55, 18);
    }
}

