/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.compat.jei;

import baguchi.tofucraft.compat.jei.JEIPlugin;
import baguchi.tofucraft.recipe.TofuPotRecipe;
import baguchi.tofucraft.registry.TofuBlocks;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class TofuPotCategory
implements IRecipeCategory<TofuPotRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_pot");
    protected final IDrawableAnimated arrow;
    private final Component title = Component.translatable((String)"tofucraft.jei.tofu_pot");
    private final IDrawable background;
    private final IDrawable icon;

    public TofuPotCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/tofu_pot.png");
        this.background = helper.createDrawable(backgroundImage, 37, 4, 112, 79);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TofuBlocks.TOFU_POT.get()));
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public int getWidth() {
        return 112;
    }

    public int getHeight() {
        return 79;
    }

    public ResourceLocation getRegistryName(TofuPotRecipe recipe) {
        return UID;
    }

    public IRecipeType<TofuPotRecipe> getRecipeType() {
        return JEIPlugin.TOFU_POT_RECIPE_JEI_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TofuPotRecipe recipe, IFocusGroup focuses) {
        List<Optional<Ingredient>> recipeIngredients = recipe.getIngredients();
        int startX = 8;
        int startY = 18;
        int inputStartX = 7;
        int inputStartY = 4;
        int borderSlotSize = 18;
        Iterator<Optional<Ingredient>> ingredients = recipeIngredients.iterator();
        int sizeWidth = 3;
        int sizeHeight = 4;
        for (int row = 0; row < sizeHeight; ++row) {
            for (int column = 0; column < sizeWidth && ingredients.hasNext(); ++column) {
                Optional<Ingredient> ingredient = ingredients.next();
                if (!ingredient.isPresent()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize).add(ingredient.get());
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 33).add(recipe.getResult());
        if (recipe.fluidIngredient().isPresent()) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 93, 15).add((Fluid)((Holder)recipe.fluidIngredient().get().ingredient().fluids().get(0)).value(), (long)recipe.fluidIngredient().get().amount());
        }
    }

    public void draw(TofuPotRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.background.draw(stack);
        this.arrow.draw(stack, 66, 34);
    }
}

