/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.data.generator.recipe;

import baguchi.tofucraft.data.generator.recipe.CraftingDataHelper;
import baguchi.tofucraft.data.generator.recipe.builder.BitternRecipeBuilder;
import baguchi.tofucraft.data.generator.recipe.builder.HardenRecipeBuilder;
import baguchi.tofucraft.data.generator.recipe.builder.TFShapedRecipeBuilder;
import baguchi.tofucraft.data.generator.recipe.builder.TFShapelessRecipeBuilder;
import baguchi.tofucraft.data.generator.recipe.builder.TofuPotShapelessRecipeBuilder;
import baguchi.tofucraft.recipe.TFCraftingCategory;
import baguchi.tofucraft.recipe.TofuPotCategory;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuFluids;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuTags;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class CraftingGenerator
extends CraftingDataHelper {
    public CraftingGenerator(HolderLookup.Provider generator, RecipeOutput completableFuture) {
        super(generator, completableFuture);
    }

    protected void buildRecipes() {
        HolderLookup.RegistryLookup lookup = this.registries.lookupOrThrow(Registries.ITEM);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_SWORD.get(), RecipeCategory.TOOLS, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_SWORD);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_PICKAXE.get(), RecipeCategory.TOOLS, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_PICKAXE);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_AXE.get(), RecipeCategory.TOOLS, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_AXE);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_SHOVEL.get(), RecipeCategory.TOOLS, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_SHOVEL);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_HOE.get(), RecipeCategory.TOOLS, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_HOE);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_HELMET.get(), RecipeCategory.COMBAT, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_HELMET);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_CHESTPLATE.get(), RecipeCategory.COMBAT, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_CHESTPLATE);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_LEGGINGS.get(), RecipeCategory.COMBAT, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_LEGGINGS);
        this.tofuDiamondSmithing(this.output, (ItemLike)TofuItems.TOFU_METAL_BOOTS.get(), RecipeCategory.COMBAT, (Supplier<? extends Item>)TofuItems.TOFU_DIAMOND_BOOTS);
        this.zundaSmithing(this.output, (ItemLike)Items.BOW, RecipeCategory.COMBAT, (Supplier<? extends Item>)TofuItems.ZUNDA_BOW);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TofuBlocks.TOFU_METAL_LANTERN.get()), (int)1).pattern("MMM").pattern("MTM").pattern("MMM").define(Character.valueOf('M'), (ItemLike)TofuItems.TOFU_METAL_NUGGET.get()).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMETAL.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TofuBlocks.TOFU_METAL_SOUL_LANTERN.get()), (int)1).pattern("MMM").pattern("MSM").pattern("MMM").define(Character.valueOf('M'), (ItemLike)TofuItems.TOFU_METAL_NUGGET.get()).define(Character.valueOf('S'), (ItemLike)Items.SOUL_TORCH).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_METAL_NUGGET.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TofuBlocks.TOFU_METAL_CHAIN.get()), (int)1).pattern("N").pattern("M").pattern("N").define(Character.valueOf('M'), (ItemLike)TofuItems.TOFUMETAL.get()).define(Character.valueOf('N'), (ItemLike)TofuItems.TOFU_METAL_NUGGET.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMETAL.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)TofuItems.TOFU_STEM_BOAT.get()), (int)1).pattern("S S").pattern("SSS").define(Character.valueOf('S'), (ItemLike)TofuBlocks.TOFU_STEM_PLANKS.get()).unlockedBy("inside_of", CraftingGenerator.insideOf((Block)Blocks.WATER)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)TofuItems.LEEK_BOAT.get()), (int)1).pattern("S S").pattern("SSS").define(Character.valueOf('S'), (ItemLike)TofuBlocks.LEEK_PLANKS.get()).unlockedBy("inside_of", CraftingGenerator.insideOf((Block)Blocks.WATER)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)TofuItems.LEEK_GREEN_BOAT.get()), (int)1).pattern("S S").pattern("SSS").define(Character.valueOf('S'), (ItemLike)TofuBlocks.LEEK_GREEN_PLANKS.get()).unlockedBy("inside_of", CraftingGenerator.insideOf((Block)Blocks.WATER)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)TofuItems.TOFU_STEM_CHEST_BOAT.get()), (int)1).requires((ItemLike)TofuItems.TOFU_STEM_BOAT.get()).requires(Tags.Items.CHESTS_WOODEN).unlockedBy("inside_of", CraftingGenerator.insideOf((Block)Blocks.WATER)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)TofuItems.LEEK_CHEST_BOAT.get()), (int)1).requires((ItemLike)TofuItems.LEEK_BOAT.get()).requires(Tags.Items.CHESTS_WOODEN).unlockedBy("inside_of", CraftingGenerator.insideOf((Block)Blocks.WATER)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)TofuItems.LEEK_GREEN_CHEST_BOAT.get()), (int)1).requires((ItemLike)TofuItems.LEEK_GREEN_BOAT.get()).requires(Tags.Items.CHESTS_WOODEN).unlockedBy("inside_of", CraftingGenerator.insideOf((Block)Blocks.WATER)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.TOFU_UPGRADE_SMITHING_TEMPLATE.get()), (int)2).pattern("GTG").pattern("G#G").pattern("GDG").define(Character.valueOf('D'), (ItemLike)TofuItems.TOFUDIAMOND.get()).define(Character.valueOf('T'), (ItemLike)TofuBlocks.ISHITOFU.get()).define(Character.valueOf('G'), (ItemLike)Items.DIAMOND).define(Character.valueOf('#'), (ItemLike)TofuItems.TOFU_UPGRADE_SMITHING_TEMPLATE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_UPGRADE_SMITHING_TEMPLATE.get())).save(this.output, this.prefix("copy_tofu_template"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.ZUNDA_UPGRADE_SMITHING_TEMPLATE.get()), (int)2).pattern("ZZZ").pattern("Z#Z").pattern("ZDZ").define(Character.valueOf('Z'), (ItemLike)TofuItems.ZUNDAMA.get()).define(Character.valueOf('D'), (ItemLike)TofuItems.ZUNDA_INGOT.get()).define(Character.valueOf('#'), (ItemLike)TofuItems.ZUNDA_UPGRADE_SMITHING_TEMPLATE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA_UPGRADE_SMITHING_TEMPLATE.get())).save(this.output, this.prefix("copy_zunda_template"));
        this.helmetItem(this.output, "tofu_metal_helmet", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_HELMET, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU);
        this.chestplateItem(this.output, "tofu_metal_chestplate", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_CHESTPLATE, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU);
        this.leggingsItem(this.output, "tofu_metal_leggings", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_LEGGINGS, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU);
        this.bootsItem(this.output, "tofu_metal_boots", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_BOOTS, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU);
        this.swordItem(this.output, "tofu_metal_sword", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_SWORD, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.pickaxeItem(this.output, "tofu_metal_pickaxe", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_PICKAXE, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.axeItem(this.output, "tofu_metal_axe", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_AXE, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.shovelItem(this.output, "tofu_metal_shovel", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_SHOVEL, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.hoeItem(this.output, "tofu_metal_hoe", (Supplier<? extends ItemLike>)TofuItems.TOFU_METAL_HOE, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.helmetItem(this.output, "tofu_solid_helmet", (Supplier<? extends ItemLike>)TofuItems.ARMOR_TOFU_SOLIDHELMET, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.chestplateItem(this.output, "tofu_solid_chestplate", (Supplier<? extends ItemLike>)TofuItems.ARMOR_TOFU_SOLIDCHESTPLATE, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.leggingsItem(this.output, "tofu_solid_leggings", (Supplier<? extends ItemLike>)TofuItems.ARMOR_TOFU_SOLIDLEGGINGS, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.bootsItem(this.output, "tofu_solid_boots", (Supplier<? extends ItemLike>)TofuItems.ARMOR_TOFU_SOLIDBOOTS, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.swordItem(this.output, "tofu_solid_sword", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_SWORD, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.pickaxeItem(this.output, "tofu_solid_pickaxe", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_PICKAXE, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.axeItem(this.output, "tofu_solid_axe", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_AXE, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.shovelItem(this.output, "tofu_solid_shovel", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_SHOVEL, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.hoeItem(this.output, "tofu_solid_hoe", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_HOE, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.swordItem(this.output, "tofu_solid_sword_terrain", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_SWORD, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_TERRAIN_ISHI, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.pickaxeItem(this.output, "tofu_solid_pickaxe_terrain", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_PICKAXE, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_TERRAIN_ISHI, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.axeItem(this.output, "tofu_solid_axe_terrain", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_AXE, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_TERRAIN_ISHI, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.shovelItem(this.output, "tofu_solid_shovel_terrain", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_SHOVEL, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_TERRAIN_ISHI, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.hoeItem(this.output, "tofu_solid_hoe_terrain", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_HOE, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_TERRAIN_ISHI, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.swordItem(this.output, "tofu_solid_sword_slate", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_SWORD, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLATE, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.pickaxeItem(this.output, "tofu_solid_pickaxe_slate", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_PICKAXE, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLATE, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.axeItem(this.output, "tofu_solid_axe_slate", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_AXE, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLATE, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.shovelItem(this.output, "tofu_solid_shovel_slate", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_SHOVEL, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLATE, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.hoeItem(this.output, "tofu_solid_hoe_slate", (Supplier<? extends ItemLike>)TofuItems.TOFU_SOLID_HOE, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLATE, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.helmetItem(this.output, "tofu_momen_helmet", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_HELMET, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU);
        this.chestplateItem(this.output, "tofu_momen_chestplate", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_CHESTPLATE, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU);
        this.leggingsItem(this.output, "tofu_momen_leggings", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_LEGGINGS, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU);
        this.bootsItem(this.output, "tofu_momen_boots", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_BOOTS, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU);
        this.swordItem(this.output, "tofu_momen_sword", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_SWORD, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.pickaxeItem(this.output, "tofu_momen_pickaxe", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_PICKAXE, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.axeItem(this.output, "tofu_momen_axe", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_AXE, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.shovelItem(this.output, "tofu_momen_shovel", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_SHOVEL, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.hoeItem(this.output, "tofu_momen_hoe", (Supplier<? extends ItemLike>)TofuItems.TOFU_MOMEN_HOE, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.TOFU_METAL_SHEARS.get())).pattern(" #").pattern("# ").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUMETAL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMETAL.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.BUGLE.get())).pattern("  #").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_item", this.has((ItemLike)Items.IRON_INGOT)).save(this.output);
        this.helmetItem(this.output, "tofu_kinu_helmet", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_HELMET, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU);
        this.chestplateItem(this.output, "tofu_kinu_chestplate", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_CHESTPLATE, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU);
        this.leggingsItem(this.output, "tofu_kinu_leggings", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_LEGGINGS, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU);
        this.bootsItem(this.output, "tofu_kinu_boots", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_BOOTS, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU);
        this.swordItem(this.output, "tofu_kinu_sword", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_SWORD, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.pickaxeItem(this.output, "tofu_kinu_pickaxe", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_PICKAXE, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.axeItem(this.output, "tofu_kinu_axe", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_AXE, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.shovelItem(this.output, "tofu_kinu_shovel", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_SHOVEL, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.hoeItem(this.output, "tofu_kinu_hoe", (Supplier<? extends ItemLike>)TofuItems.TOFU_KINU_HOE, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_KINU, (Supplier<? extends ItemLike>)TofuItems.TOFUKINU);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_MOMEN, (Supplier<? extends ItemLike>)TofuItems.TOFUMOMEN);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_ISHI, (Supplier<? extends ItemLike>)TofuItems.TOFUISHI);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_ISHIBRICK, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_METAL, (Supplier<? extends ItemLike>)TofuItems.TOFUMETAL);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_GRILLED, (Supplier<? extends ItemLike>)TofuItems.TOFUGRILLED);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_ZUNDA, (Supplier<? extends ItemLike>)TofuItems.TOFUZUNDA);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_HELL, (Supplier<? extends ItemLike>)TofuItems.TOFUHELL);
        this.ladderItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_SOUL, (Supplier<? extends ItemLike>)TofuItems.TOFUSOUL);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUKINU, "tofumomen_from_kinu");
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUMOMEN);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUISHI);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_SMOOTH_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUMETAL);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.DIAMONDTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUDIAMOND);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.TOFU_GEM_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUGEM.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.ADVANCE_TOFU_GEM_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.ADVANCE_TOFUGEM.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ADVANCE_TOFUGEM.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.TOFUGEM.get()), (int)9).requires((ItemLike)TofuBlocks.TOFU_GEM_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output, this.prefix("revert_to_tofu_gem"));
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.ADVANCE_TOFUGEM.get()), (int)9).requires((ItemLike)TofuBlocks.ADVANCE_TOFU_GEM_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ADVANCE_TOFUGEM.get())).save(this.output, this.prefix("revert_to_adv_tofu_gem"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.ZUNDAMA_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.ZUNDAMA.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDAMA.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.ZUNDAMA.get()), (int)9).requires((ItemLike)TofuBlocks.ZUNDAMA_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.ZUNDAMA_BLOCK.get())).save(this.output, this.prefix("revert_to_zundama"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.TOFUDIAMOND.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUDIAMOND_NUGGET.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUDIAMOND_NUGGET.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.TOFUDIAMOND_NUGGET.get()), (int)9).requires((ItemLike)TofuItems.TOFUDIAMOND.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUDIAMOND.get())).save(this.output);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.GRILLEDTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUGRILLED);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUZUNDA);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.MISOTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUMISO);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.DRIEDTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUDRIED);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MISC, Optional.empty(), new ItemStack((ItemLike)TofuItems.TOFUEGG.get(), 4), 200, 0.1f).requires((TagKey<Item>)Tags.Items.EGGS).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.STARCH.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)200)), (ItemLike)TofuItems.YUDOFU.get(), 100, 0.1f).requires(TofuTags.Items.TOFU).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUKINU.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.EDAMAME_RICE.get(), 200, 0.4f).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.EDAMAME.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.EDAMAME.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.BOTTLE_SOYOIL.get()), (int)1).requires(TofuTags.Items.SOYBEAN).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)TofuItems.FILTERCLOTH.get()).unlockedBy("has_item", this.has(TofuTags.Items.SOYBEAN)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUFRIED.get()), (int)1).requires(TofuTags.Items.TOFU).requires((ItemLike)TofuItems.BOTTLE_SOYOIL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYOIL.get())).save(this.output);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)((ItemLike)TofuItems.TOFUDRIED.get())), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUSMOKE.get()), (float)0.1f, (int)600).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUDRIED.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUFRIED_POUCH.get()), (int)1).requires((ItemLike)TofuItems.STARCH.get()).requires((ItemLike)TofuItems.BOTTLE_SOYOIL.get()).requires(TofuTags.Items.TOFU).unlockedBy("has_item", this.has((ItemLike)TofuItems.STARCH.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.AGEDASHI_TOFU.get(), 200, 0.4f).requires((ItemLike)TofuItems.TOFUFRIED_POUCH.get()).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUFRIED_POUCH.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.OAGE.get(), 4, 200, 0.4f).requires((ItemLike)TofuBlocks.TOFUSLAB_MOMEN.get()).requires((ItemLike)TofuItems.BOTTLE_SOYOIL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYOIL.get())).save(this.output);
        this.foodCooking((Supplier<? extends ItemLike>)TofuItems.TOFUISHI, (Supplier<? extends ItemLike>)TofuItems.TOFU_STEAK, 0.1f, this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFU_MINCED.get()), (int)1).requires((ItemLike)TofuItems.TOFUMOMEN.get()).requires((ItemLike)TofuItems.ROLLINGPIN.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ROLLINGPIN.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.STARCH_RAW.get()), (int)1).requires((ItemLike)TofuItems.MINCEDPOTATO.get()).requires((ItemLike)TofuItems.FILTERCLOTH.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.MINCEDPOTATO.get())).save(this.output);
        this.foodCookingButNoCampfire((Supplier<? extends ItemLike>)TofuItems.STARCH_RAW, (Supplier<? extends ItemLike>)TofuItems.STARCH, 0.1f, this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.GELATINRAW.get()), (int)1).requires((ItemLike)Items.BONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER, Items.RABBIT_HIDE})).unlockedBy("has_item", this.has((ItemLike)Items.BONE)).save(this.output);
        this.foodCookingButNoCampfire((Supplier<? extends ItemLike>)TofuItems.GELATINRAW, (Supplier<? extends ItemLike>)TofuItems.GELATIN, 0.1f, this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.APRICOTJERRY_BREAD.get()), (int)1).requires((ItemLike)TofuItems.APRICOTJERRY_BOTTLE.get()).requires((ItemLike)Items.BREAD).unlockedBy("has_item", this.has((ItemLike)TofuItems.APRICOTJERRY_BOTTLE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.APRICOTSEED.get()), (int)1).requires((ItemLike)TofuItems.APRICOT.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.APRICOT.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.KYONINSO.get()), (int)1).requires((ItemLike)TofuItems.APRICOTSEED.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.APRICOT.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.FILTERCLOTH.get()), (int)32).pattern("###").define(Character.valueOf('#'), ItemTags.WOOL).unlockedBy("has_item", this.has((ItemLike)Items.WHITE_WOOL)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.ISHITOFU_CHISELED_BRICK.get())).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)TofuBlocks.TOFUSLAB_ISHIBRICK.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.TOFUSLAB_ISHIBRICK.get())).save(this.output);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_KINU, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_MOMEN, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU);
        this.makeStairsCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_ISHI, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.makeStairsCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_METAL, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_GRILLED, (Supplier<? extends ItemLike>)TofuBlocks.GRILLEDTOFU);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_ZUNDA, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_HELL, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_SOUL, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU);
        this.makeStairsCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_ISHIBRICK, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK);
        this.makeStairsCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_HELLBRICK, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU_BRICK);
        this.makeStairsCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_SOULBRICK, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU_BRICK);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_MISO, (Supplier<? extends ItemLike>)TofuBlocks.MISOTOFU);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_DRIED, (Supplier<? extends ItemLike>)TofuBlocks.DRIEDTOFU);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_KINU, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_MOMEN, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU);
        this.makeSlabCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_ISHI, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.makeSlabCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_METAL, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_GRILLED, (Supplier<? extends ItemLike>)TofuBlocks.GRILLEDTOFU);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_ZUNDA, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_HELL, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_SOUL, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU);
        this.makeSlabCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_ISHIBRICK, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK);
        this.makeSlabCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_HELLBRICK, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU_BRICK);
        this.makeSlabCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_SOULBRICK, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU_BRICK);
        this.makeSlabCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_MISO, (Supplier<? extends ItemLike>)TofuBlocks.MISOTOFU);
        this.makeSlabCraftingOrCutting(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_DRIED, (Supplier<? extends ItemLike>)TofuBlocks.DRIEDTOFU);
        this.makeSolidFence(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_KINU, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU);
        this.makeSolidFence(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_MOMEN, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU);
        this.makeSolidFence(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_ISHI, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.makeSolidFence(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_METAL, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU);
        this.makeSolidFence(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_HELL, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU);
        this.makeSolidFence(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_SOUL, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU);
        this.makeSolidFence(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_GRILLED, (Supplier<? extends ItemLike>)TofuBlocks.GRILLEDTOFU);
        this.makeSolidFence(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_ZUNDA, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU);
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUDOOR_KINU, (Supplier<? extends Block>)TofuBlocks.KINUTOFU);
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUDOOR_MOMEN, (Supplier<? extends Block>)TofuBlocks.MOMENTOFU);
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUDOOR_ISHI, (Supplier<? extends Block>)TofuBlocks.ISHITOFU);
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUDOOR_METAL, (Supplier<? extends Block>)TofuBlocks.METALTOFU);
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUDOOR_HELL, (Supplier<? extends Block>)TofuBlocks.HELLTOFU);
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUDOOR_SOUL, (Supplier<? extends Block>)TofuBlocks.SOULTOFU);
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUDOOR_GRILLED, (Supplier<? extends Block>)TofuBlocks.GRILLEDTOFU);
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUDOOR_ZUNDA, (Supplier<? extends Block>)TofuBlocks.ZUNDATOFU);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUTRAPDOOR_KINU, (Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUTRAPDOOR_MOMEN, (Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUTRAPDOOR_ISHI, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUTRAPDOOR_METAL, (Supplier<? extends ItemLike>)TofuBlocks.METALTOFU);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUTRAPDOOR_HELL, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUTRAPDOOR_SOUL, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUTRAPDOOR_GRILLED, (Supplier<? extends ItemLike>)TofuBlocks.GRILLEDTOFU);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFUTRAPDOOR_ZUNDA, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTRAPDOOR_ISHI, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.TOFUFENCE_ISHI, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.TOFUDOOR_ISHI, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_ISHI, 3);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_ISHIBRICK, 3);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_CHISELED_BRICK, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_SMOOTH_BRICK, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_ISHIBRICK, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_ISHIBRICK, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_ISHI, 3);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.TOFULADDER_ISHIBRICK, 3);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_CHISELED_BRICK, 1);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.ISHITOFU_SMOOTH_BRICK, 1);
        this.makeTorch(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTORCH_KINU, (Supplier<? extends ItemLike>)TofuItems.TOFUKINU);
        this.makeTorch(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTORCH_MOMEN, (Supplier<? extends ItemLike>)TofuItems.TOFUMOMEN);
        this.makeTorch(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTORCH_ISHI, (Supplier<? extends ItemLike>)TofuItems.TOFUISHI);
        this.makeTorch(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTORCH_METAL, (Supplier<? extends ItemLike>)TofuItems.TOFUMETAL);
        this.makeTorch(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTORCH_GRILLED, (Supplier<? extends ItemLike>)TofuItems.TOFUGRILLED);
        this.makeTorch(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTORCH_ZUNDA, (Supplier<? extends ItemLike>)TofuItems.TOFUZUNDA);
        this.makeTorch(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTORCH_HELL, (Supplier<? extends ItemLike>)TofuItems.TOFUHELL);
        this.makeTorch(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUTORCH_SOUL, (Supplier<? extends ItemLike>)TofuItems.TOFUSOUL);
        this.foodCooking((Supplier<? extends ItemLike>)TofuItems.TOFUKINU, (Supplier<? extends ItemLike>)TofuItems.TOFUGRILLED, 0.1f, this.output, "grilled_from_kinu");
        this.foodCooking((Supplier<? extends ItemLike>)TofuItems.TOFUMOMEN, (Supplier<? extends ItemLike>)TofuItems.TOFUGRILLED, 0.1f, this.output, "grilled_from_momen");
        this.foodCooking((Supplier<? extends ItemLike>)TofuBlocks.KINUTOFU, (Supplier<? extends ItemLike>)TofuBlocks.GRILLEDTOFU, 0.1f, this.output, "grilled_block_from_kinu");
        this.foodCooking((Supplier<? extends ItemLike>)TofuBlocks.MOMENTOFU, (Supplier<? extends ItemLike>)TofuBlocks.GRILLEDTOFU, 0.1f, this.output, "grilled_block_from_momen");
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUHELL);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU_SMOOTH_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU_BRICK);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUSOUL);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU_SMOOTH_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU_BRICK);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.HELLTOFU_SMOOTH_BRICK, 2);
        this.cuttingRecipe(this.output, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.SOULTOFU_SMOOTH_BRICK, 2);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.MINCEDTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFU_MINCED);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.EGGTOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUEGG);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_EGG, (Supplier<? extends ItemLike>)TofuBlocks.EGGTOFU);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_EGG, (Supplier<? extends ItemLike>)TofuBlocks.EGGTOFU);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.EGGTOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.EGGTOFU);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_EGGBRICK, (Supplier<? extends ItemLike>)TofuBlocks.EGGTOFU_BRICK);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_EGGBRICK, (Supplier<? extends ItemLike>)TofuBlocks.EGGTOFU_BRICK);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU);
        this.buildingTofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU_SMOOTH_BRICK, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU_BRICK);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_ZUNDABRICK, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU_BRICK);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_ZUNDABRICK, (Supplier<? extends ItemLike>)TofuBlocks.ZUNDATOFU_BRICK);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuItems.TOFUZUNDA.get()), (int)1).requires((ItemLike)TofuItems.ZUNDA.get()).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.STARCH.get()).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.TOFU_STEM_PLANKS.get()), (int)4).requires((ItemLike)TofuBlocks.TOFU_STEM.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.TOFU_STEM.get())).save(this.output);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_STEM_PLANKS_STAIR, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_STEM_PLANKS);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_STEM_PLANKS_SLAB, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_STEM_PLANKS);
        this.makeWoodFence(this.output, (Block)TofuBlocks.TOFU_STEM_FENCE.get(), (Block)TofuBlocks.TOFU_STEM_PLANKS.get());
        this.makeFenceGate(this.output, (Block)TofuBlocks.TOFU_STEM_FENCE_GATE.get(), (Block)TofuBlocks.TOFU_STEM_PLANKS.get());
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFU_STEM_DOOR, (Supplier<? extends Block>)TofuBlocks.TOFU_STEM_PLANKS);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.TOFU_STEM_TRAPDOOR, (Supplier<? extends ItemLike>)TofuBlocks.TOFU_STEM_PLANKS);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.LEEK_PLANKS.get()), (int)4).requires((ItemLike)TofuBlocks.LEEK_STEM.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.LEEK_STEM.get())).save(this.output);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_PLANKS_STAIR, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_PLANKS);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_PLANKS_SLAB, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_PLANKS);
        this.makeWoodFence(this.output, (Block)TofuBlocks.LEEK_FENCE.get(), (Block)TofuBlocks.LEEK_PLANKS.get());
        this.makeFenceGate(this.output, (Block)TofuBlocks.LEEK_FENCE_GATE.get(), (Block)TofuBlocks.LEEK_PLANKS.get());
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.LEEK_DOOR, (Supplier<? extends Block>)TofuBlocks.LEEK_PLANKS);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.LEEK_TRAPDOOR, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_PLANKS);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.LEEK_GREEN_PLANKS.get()), (int)4).requires((ItemLike)TofuBlocks.LEEK_GREEN_STEM.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.LEEK_GREEN_STEM.get())).save(this.output);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_GREEN_PLANKS_STAIR, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_GREEN_PLANKS);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_GREEN_PLANKS_SLAB, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_GREEN_PLANKS);
        this.makeWoodFence(this.output, (Block)TofuBlocks.LEEK_GREEN_FENCE.get(), (Block)TofuBlocks.LEEK_GREEN_PLANKS.get());
        this.makeFenceGate(this.output, (Block)TofuBlocks.LEEK_GREEN_FENCE_GATE.get(), (Block)TofuBlocks.LEEK_GREEN_PLANKS.get());
        this.makeDoor(this.output, (Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_DOOR, (Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_PLANKS);
        this.makeTrapdoor(this.output, (Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_TRAPDOOR, (Supplier<? extends ItemLike>)TofuBlocks.LEEK_GREEN_PLANKS);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.TOFU_METAL_NUGGET.get()), (int)9).requires((ItemLike)TofuItems.TOFUMETAL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMETAL.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuItems.TOFUMETAL.get()), (int)1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFU_METAL_NUGGET.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_METAL_NUGGET.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.METAL_TOFU_GRATE.get()), (int)8).pattern(" # ").pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)TofuBlocks.METALTOFU.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.METALTOFU.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.METAL_TOFU_LUMP.get()), (int)4).pattern(" # ").pattern("#Z#").pattern(" # ").define(Character.valueOf('#'), (ItemLike)TofuBlocks.METALTOFU.get()).define(Character.valueOf('Z'), (ItemLike)TofuItems.ZUNDAMA.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.METALTOFU.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.METAL_TOFU_BARS.get()), (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUMETAL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMETAL.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.SALT_FURNACE.get())).pattern("###").pattern("# #").pattern("SSS").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), Tags.Items.COBBLESTONES).unlockedBy("has_item", this.has((ItemLike)Items.IRON_INGOT)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.MORIJIO.get()), (int)3).pattern("S#S").pattern("#D#").pattern(" W ").define(Character.valueOf('#'), TofuTags.Items.SALT).define(Character.valueOf('S'), (ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get()).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('W'), (ItemLike)Items.BOWL).unlockedBy("has_item", this.has(TofuTags.Items.SALT)).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MISC, Optional.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)250)), (ItemLike)TofuItems.BOTTLE_DASHI.get(), 200, 0.1f).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.DRIED_KELP).unlockedBy("has_item", this.has((ItemLike)Items.KELP)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.BARREL_MISO.get()), (int)1).pattern("SSS").pattern("KKK").pattern(" B ").define(Character.valueOf('S'), TofuTags.Items.SALT).define(Character.valueOf('K'), (ItemLike)TofuItems.KOUJI.get()).define(Character.valueOf('B'), Tags.Items.BARRELS_WOODEN).unlockedBy("has_item", this.has((ItemLike)TofuItems.KOUJI.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.BARREL_MISOTOFU.get()), (int)1).pattern("MMM").pattern("TTT").pattern(" B ").define(Character.valueOf('M'), (ItemLike)TofuItems.MISO.get()).define(Character.valueOf('T'), (ItemLike)TofuItems.TOFUMOMEN.get()).define(Character.valueOf('B'), Tags.Items.BARRELS_WOODEN).unlockedBy("has_item", this.has((ItemLike)TofuItems.MISO.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.BARREL_ADV_TOFUGEM.get()), (int)1).pattern("RRR").pattern("GGG").pattern(" B ").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('G'), (ItemLike)TofuItems.TOFUGEM.get()).define(Character.valueOf('B'), Tags.Items.BARRELS_WOODEN).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.NATTOBED.get()), (int)1).pattern("SSS").pattern("SSS").pattern("WWW").define(Character.valueOf('S'), (ItemLike)TofuItems.SEEDS_SOYBEANS.get()).define(Character.valueOf('W'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.NETHER_NATTOBED.get()), (int)1).pattern("SSS").pattern("SSS").pattern("WWW").define(Character.valueOf('S'), (ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get()).define(Character.valueOf('W'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.TOFU_CHIKUWA_BLOCK.get()), (int)1).pattern(" S ").pattern("S S").pattern(" S ").define(Character.valueOf('S'), (ItemLike)TofuItems.TOFU_CHIKUWA.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_CHIKUWA.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.CHIKUWA_BLOCK.get()), (int)1).pattern(" S ").pattern("S S").pattern(" S ").define(Character.valueOf('S'), (ItemLike)TofuItems.CHIKUWA.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.CHIKUWA.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuBlocks.TOFUCAKE.get())).pattern("###").pattern("SES").pattern("WWW").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUKINU.get()).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('E'), Tags.Items.EGGS).define(Character.valueOf('W'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUKINU.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuBlocks.ZUNDATOFUCAKE.get())).pattern("###").pattern("SES").pattern("WWW").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUZUNDA.get()).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('E'), Tags.Items.EGGS).define(Character.valueOf('W'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUZUNDA.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuBlocks.SOYCHEESE_TART.get())).pattern("###").pattern("SES").pattern("WWW").define(Character.valueOf('#'), (ItemLike)TofuItems.SOY_CHEESE.get()).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('E'), Tags.Items.EGGS).define(Character.valueOf('W'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.SOY_CHEESE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.BUCKET_SOYMILK.get())).requires(TofuTags.Items.SOYBEAN).requires((ItemLike)Items.BUCKET).unlockedBy("has_item", this.has(TofuTags.Items.SOYBEAN)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.BUCKET_SOYMILK.get())).requires(TofuTags.Items.SOYBEAN).requires((ItemLike)Items.BUCKET).requires((ItemLike)TofuItems.FILTERCLOTH.get()).unlockedBy("has_item", this.has(TofuTags.Items.SOYBEAN)).save(this.output, this.prefix("bucket_soymilk_okara"));
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.BUCKET_SOYMILK_NETHER.get())).requires((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get()).requires((ItemLike)Items.BUCKET).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.BUCKET_SOYMILK_SOUL.get())).requires((ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get()).requires((ItemLike)Items.BUCKET).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_OMINOUS_BOTTLE.get()), (int)2).requires((ItemLike)TofuItems.SOYMILK_SOUL_BOTTLE.get()).requires((ItemLike)Items.OMINOUS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE, 2).unlockedBy("has_item", this.has((ItemLike)TofuItems.SOYMILK_SOUL_BOTTLE.get())).save(this.output);
        this.foodCooking((Supplier<? extends ItemLike>)TofuItems.SEEDS_SOYBEANS, (Supplier<? extends ItemLike>)TofuItems.SOYBEAN_PARCHED, 0.1f, this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.KINAKO.get())).requires((ItemLike)TofuItems.SOYBEAN_PARCHED.get()).requires((ItemLike)Items.SUGAR).unlockedBy("has_item", this.has((ItemLike)TofuItems.SOYBEAN_PARCHED.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.CHIKUWA.get()), (int)4).pattern(" X ").pattern("YZI").pattern(" X ").define(Character.valueOf('X'), ItemTags.FISHES).define(Character.valueOf('Y'), TofuTags.Items.DUST_SALT).define(Character.valueOf('Z'), Tags.Items.EGGS).define(Character.valueOf('I'), (ItemLike)TofuItems.STARCH.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.STARCH.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFU_CHIKUWA.get()), (int)1).requires((ItemLike)TofuItems.TOFUMOMEN.get()).requires((ItemLike)Items.COOKED_COD).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMOMEN.get())).save(this.output, this.prefix("tofu_chikuwa"));
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFU_CHIKUWA.get()), (int)1).requires((ItemLike)TofuItems.COOKED_TOFU_FISH.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.RAW_TOFU_FISH.get())).save(this.output, this.prefix("tofu_chikuwa_fish"));
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.ZUNDA.get()), (int)4).requires((ItemLike)TofuItems.BOILED_EDAMAME.get(), 8).requires((ItemLike)Items.SUGAR).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOILED_EDAMAME.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.ZUNDAMA.get())).requires((ItemLike)TofuItems.ZUNDA.get(), 4).requires((ItemLike)Items.GLOWSTONE_DUST).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA.get())).save(this.output);
        this.foodCooking((Supplier<? extends ItemLike>)TofuItems.TOFU_HAMBURG_RAW, (Supplier<? extends ItemLike>)TofuItems.TOFU_HAMBURG, 0.25f, this.output);
        this.foodCooking((Supplier<? extends ItemLike>)TofuItems.RAW_TOFU_FISH, (Supplier<? extends ItemLike>)TofuItems.COOKED_TOFU_FISH, 0.2f, this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.MISODENGAKU.get()), (int)1).pattern(" X ").pattern(" Y ").pattern(" Z ").define(Character.valueOf('X'), (ItemLike)TofuItems.MISO.get()).define(Character.valueOf('Y'), (ItemLike)TofuItems.TOFUMOMEN.get()).define(Character.valueOf('Z'), (ItemLike)Items.STICK).unlockedBy("has_item", this.has((ItemLike)TofuItems.MISO.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.MISO_CHEESE_DENGAKU.get()), (int)1).pattern(" X ").pattern("CYC").pattern(" Z ").define(Character.valueOf('X'), (ItemLike)TofuItems.MISO.get()).define(Character.valueOf('Y'), (ItemLike)TofuItems.TOFUMOMEN.get()).define(Character.valueOf('C'), (ItemLike)TofuItems.SOY_CHEESE.get()).define(Character.valueOf('Z'), (ItemLike)Items.STICK).unlockedBy("has_item", this.has((ItemLike)TofuItems.MISO.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUCOOKIE.get()), (int)8).pattern("X#X").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUKINU.get()).define(Character.valueOf('X'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUKINU.get())).save(this.output, this.prefix("tofucookie_kinu"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUCOOKIE.get()), (int)8).pattern("X#X").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUMOMEN.get()).define(Character.valueOf('X'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMOMEN.get())).save(this.output, this.prefix("tofucookie_momen"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TTTBURGER.get()), (int)1).pattern(" X ").pattern("###").pattern(" X ").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUFRIED_POUCH.get()).define(Character.valueOf('X'), (ItemLike)Items.BREAD).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUKINU.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.MEAT_WRAPPED_YUBA.get())).requires((ItemLike)Items.COOKED_CHICKEN).requires((ItemLike)TofuItems.YUBA.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.YUBA.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYSTICK.get())).requires(TofuTags.Items.SOYBEAN).requires(Tags.Items.CROPS_WHEAT).requires(TofuTags.Items.SALT).unlockedBy("has_item", this.has(TofuTags.Items.SALT)).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)200)), (ItemLike)TofuItems.MISOSOUP.get(), 300, 0.4f).requires(TofuTags.Items.TOFU).requires((ItemLike)TofuItems.MISO.get()).requires((ItemLike)Items.BOWL).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.MISO.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.MOYASHIITAME.get(), 300, 0.6f).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires(TofuTags.Items.DUST_SALT).requires((ItemLike)TofuItems.SPROUTS.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.SPROUTS.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.MOYASHIOHITASHI.get(), 300, 0.6f).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.SPROUTS.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.SPROUTS.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SALTYMELON.get())).requires(TofuTags.Items.SALT).requires((ItemLike)Items.MELON_SLICE).unlockedBy("has_item", this.has(TofuTags.Items.SALT)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK.get()), (int)3).requires((ItemLike)TofuItems.BUCKET_SOYMILK.get()).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_APPLE.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.APPLE).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_COCOA.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.COCOA_BEANS).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_FRUITS.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.APPLE).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.GLOW_BERRIES).requires((ItemLike)Items.CHORUS_FRUIT).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_HONEY.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_KINAKO.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)TofuItems.KINAKO.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_PUDDING.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.SUGAR).requires(Tags.Items.EGGS).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_PUMPKIN.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.PUMPKIN).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_RAMUNE.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.LIGHT_BLUE_DYE).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_SAKURA.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Blocks.CHERRY_LEAVES).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_ANNIN.get())).requires(TofuTags.Items.MILK_SOYMILK).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)TofuItems.KYONINSO.get()).requires((ItemLike)TofuItems.KYONINSO.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.CRIMSON_BOTTLE.get()), (int)3).requires((ItemLike)TofuItems.SHROOM_BOTTLE.get()).requires((ItemLike)Items.CRIMSON_FUNGUS).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_item", this.has((ItemLike)TofuItems.SHROOM_BOTTLE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.WARPED_BOTTLE.get()), (int)3).requires((ItemLike)TofuItems.SHROOM_BOTTLE.get()).requires((ItemLike)Items.WARPED_FUNGUS).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_item", this.has((ItemLike)TofuItems.SHROOM_BOTTLE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.KINAKO_MANJU.get()), (int)2).requires((ItemLike)TofuItems.KINAKO.get()).requires(Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.KINAKO.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.ZUNDA_MANJU.get()), (int)2).requires((ItemLike)TofuItems.ZUNDA.get()).requires(Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.NETHER_MANJU.get()), (int)2).requires((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get()).requires(Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOUL_MANJU.get()), (int)2).requires((ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get()).requires(Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.KINAKO_MOCHI.get()), (int)1).requires((ItemLike)TofuItems.KINAKO.get()).requires(TofuTags.Items.RICE).unlockedBy("has_item", this.has((ItemLike)TofuItems.KINAKO.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.CRIMSON_SOUP.get()), (int)1).requires((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get(), 2).requires((ItemLike)Items.CRIMSON_FUNGUS).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.ZUNDA_MOCHI.get()), (int)1).requires((ItemLike)TofuItems.ZUNDA.get()).requires(TofuTags.Items.RICE).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA_MOCHI.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.PUDDING.get()), (int)1).requires(Tags.Items.EGGS).requires((ItemLike)TofuItems.GELATIN.get()).requires((ItemLike)Items.MILK_BUCKET).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.GLASS_BOWL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.GELATIN.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.PUDDING_SOYMILK.get()), (int)1).requires(Tags.Items.EGGS).requires((ItemLike)TofuItems.GELATIN.get()).requires((ItemLike)TofuItems.SOYMILK.get()).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.GLASS_BOWL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.GELATIN.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.NIKUJAGA.get(), 400, 0.8f).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.POTATO).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.COOKED_BEEF).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.FAST_FOOD, Optional.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)200)), new ItemStack((ItemLike)TofuItems.ONIGIRI.get(), 2), 100, 0.05f).requires(TofuTags.Items.RICE).unlockedBy("has_item", this.has((ItemLike)TofuItems.RICE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.ONIGIRI_SALT.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.SALT.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SALT.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.YAKIONIGIRI_MISO.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.MISO.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.MISO.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.YAKIONIGIRI_SHOYU.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.RICE_BURGER.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)Items.COOKED_BEEF).unlockedBy("has_item", this.has((ItemLike)TofuItems.ONIGIRI.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.RICE_NATTO.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.NATTO.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.NATTO.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.RICE_NATTO_LEEK.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.NATTO.get()).requires((ItemLike)TofuItems.LEEK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.NATTO.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.RICE_NETHER_NATTO.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.NETHER_NATTO.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.NETHER_NATTO.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.RICE_NETHER_NATTO_LEEK.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.NETHER_NATTO.get()).requires((ItemLike)TofuItems.LEEK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.NETHER_NATTO.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.RICE_TOFU.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires(TofuTags.Items.TOFU).unlockedBy("has_item", this.has((ItemLike)TofuItems.ONIGIRI.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.RICE_SOBORO_TOFU.get()), (int)1).requires((ItemLike)TofuItems.ONIGIRI.get()).requires((ItemLike)TofuItems.TOFU_MINCED.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.LEEK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_MINCED.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.GOHEIMOCHI.get())).pattern("#").pattern("M").pattern("S").define(Character.valueOf('#'), (ItemLike)TofuItems.ONIGIRI.get()).define(Character.valueOf('M'), (ItemLike)TofuItems.MISO.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_item", this.has((ItemLike)TofuItems.MISO.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.INARI.get()), (int)1).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.OAGE.get()).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.ONIGIRI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.OAGE.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.OKARASTICK.get()), (int)3).pattern(" # ").pattern(" E ").pattern(" W ").define(Character.valueOf('#'), (ItemLike)TofuItems.OKARA.get()).define(Character.valueOf('E'), Tags.Items.EGGS).define(Character.valueOf('W'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.OKARA.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.OKARA_DONUT.get()), (int)4).pattern("#W#").pattern("WEW").pattern("#W#").define(Character.valueOf('#'), (ItemLike)TofuItems.OKARA.get()).define(Character.valueOf('E'), Tags.Items.EGGS).define(Character.valueOf('W'), Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has((ItemLike)TofuItems.OKARA.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOBOROTOFUSAUTE.get()), (int)1).requires((ItemLike)TofuItems.TOFU_MINCED.get()).requires((ItemLike)Items.COOKED_PORKCHOP).requires((ItemLike)Items.CARROT).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).requires((ItemLike)TofuItems.BOTTLE_SOYOIL.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_MINCED.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOY_CHOCOLATE.get()), (int)6).requires((ItemLike)TofuItems.BUCKET_SOYMILK.get()).requires((ItemLike)Items.COCOA_BEANS).requires((ItemLike)Items.SUGAR).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUNIAN_SOY_CHOCOLATE.get()), (int)6).requires((ItemLike)TofuItems.BUCKET_SOYMILK.get()).requires((ItemLike)Items.COCOA_BEANS).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.LEEK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.MINCEDPOTATO.get()), (int)1).requires((ItemLike)Items.POTATO).requires((ItemLike)TofuItems.FILTERCLOTH.get()).unlockedBy("has_item", this.has((ItemLike)Items.POTATO)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SEEDS_CHILI.get()), (int)1).requires((ItemLike)TofuItems.CHILI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.CHILI.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.DOUBANJIANG.get()), (int)1).requires((ItemLike)TofuItems.CHILI.get()).requires(Tags.Items.CROPS_WHEAT).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.SALT.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.CHILI.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.MABODOFU.get(), 400, 0.8f).requires(TofuTags.Items.TOFU).requires((ItemLike)TofuItems.STARCH.get()).requires((ItemLike)Items.PORKCHOP).requires((ItemLike)Items.BOWL).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.DOUBANJIANG.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.DOUBANJIANG.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.NANBAN.get(), 400, 0.8f).requires((ItemLike)Items.COOKED_CHICKEN).requires((TagKey<Item>)Tags.Items.EGGS).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((ItemLike)Items.BOWL).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.CHILI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.NANBANTOFU.get(), 400, 0.8f).requires(TofuTags.Items.TOFU).requires((TagKey<Item>)Tags.Items.EGGS).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((ItemLike)Items.BOWL).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.CHILI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.FUKUMENI.get()), (int)8).requires((ItemLike)TofuItems.SALT.get()).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).requires((ItemLike)TofuItems.TOFUDRIED.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUDRIED.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)500)), (ItemLike)TofuItems.KOYADOFUSTEW.get(), 400, 0.8f).requires((ItemLike)TofuItems.TOFUDRIED.get()).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).requires((ItemLike)Items.BOWL).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.GLASS_BOWL.get()), (int)2).pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.GLASS_PANE).unlockedBy("has_item", this.has((ItemLike)Items.GLASS)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUSOMEN.get()), (int)4).requires((ItemLike)TofuItems.TOFUKINU.get()).requires((ItemLike)TofuItems.ROLLINGPIN.get()).requires((ItemLike)TofuItems.SALT.get()).requires((ItemLike)TofuItems.STARCH.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ROLLINGPIN.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUSOMENBOWL_GLASS.get()), (int)1).requires((ItemLike)TofuItems.TOFUSOMEN.get()).requires((ItemLike)TofuItems.GLASS_BOWL.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.BOTTLE_DASHI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUSOMEN.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.TASTYBEEFSTEW.get(), 300, 0.6f).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)Items.RED_MUSHROOM).requires((ItemLike)Items.COOKED_BEEF).requires(TofuTags.Items.DUST_SALT).requires((ItemLike)Items.MILK_BUCKET).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.SALT.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.TASTYSTEW.get(), 300, 0.6f).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)Items.RED_MUSHROOM).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.COOKED_CHICKEN, Items.COOKED_MUTTON, Items.COOKED_PORKCHOP, Items.COOKED_RABBIT})).requires(TofuTags.Items.DUST_SALT).requires((ItemLike)Items.MILK_BUCKET).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.SALT.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOUL_HIYAYAKKO_GLASS.get()), (int)1).requires((ItemLike)TofuItems.TOFUSOUL.get()).requires((ItemLike)TofuItems.LEEK.get()).requires((ItemLike)TofuItems.GLASS_BOWL.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.HIYAYAKKO_GLASS.get()), (int)1).requires((ItemLike)TofuItems.TOFUKINU.get()).requires((ItemLike)TofuItems.LEEK.get()).requires((ItemLike)TofuItems.GLASS_BOWL.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.NATTOHIYAYAKKO_GLASS.get()), (int)1).requires((ItemLike)TofuItems.NATTO.get()).requires((ItemLike)TofuItems.TOFUKINU.get()).requires((ItemLike)TofuItems.LEEK.get()).requires((ItemLike)TofuItems.GLASS_BOWL.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.WARABI_MOCHI.get()), (int)1).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.KINAKO.get()).requires((ItemLike)TofuItems.STARCH.get()).requires((ItemLike)TofuItems.GLASS_BOWL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.STARCH.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFUANNIN.get()), (int)1).requires((ItemLike)TofuItems.KYONINSO.get()).requires((ItemLike)TofuItems.KYONINSO.get()).requires((ItemLike)TofuItems.GELATIN.get()).requires((ItemLike)Items.MILK_BUCKET).unlockedBy("has_item", this.has((ItemLike)TofuItems.APRICOT.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.SALTPAN.get())).pattern("# #").pattern(" X ").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)Blocks.COBBLESTONE_SLAB).unlockedBy("has_item", this.has((ItemLike)Blocks.COBBLESTONE_SLAB)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.SALTPAN.get())).pattern("# #").pattern(" X ").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)Blocks.COBBLED_DEEPSLATE_SLAB).unlockedBy("has_item", this.has((ItemLike)Blocks.COBBLED_DEEPSLATE_SLAB)).save(this.output, this.prefix("deepslate_saltpan"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.SALTPAN.get())).pattern("# #").pattern(" X ").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)Blocks.BLACKSTONE_SLAB).unlockedBy("has_item", this.has((ItemLike)Blocks.BLACKSTONE_SLAB)).save(this.output, this.prefix("blackstone_saltpan"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.TOFUCHEST.get())).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUISHI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUISHI.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.TOFUSCOOP.get())).pattern("#").pattern("X").pattern("X").define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('#'), (ItemLike)Blocks.IRON_BARS).unlockedBy("has_item", this.has((ItemLike)Blocks.IRON_BARS)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.TOFUSCOOP.get())).pattern("#").pattern("X").pattern("X").define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('#'), TofuBlocks.METAL_TOFU_BARS).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.METAL_TOFU_BARS)).save(this.output, this.prefix("metal_tofu_scoop"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.FUKUMAME.get())).pattern("###").pattern("###").pattern(" X ").define(Character.valueOf('X'), (ItemLike)Items.BOWL).define(Character.valueOf('#'), (ItemLike)TofuItems.SOYBEAN_PARCHED.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SOYBEAN_PARCHED.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.NETHER_FUKUMAME.get())).pattern("###").pattern("###").pattern(" X ").define(Character.valueOf('X'), (ItemLike)Items.BOWL).define(Character.valueOf('#'), (ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.INFERNO_NETHER_FUKUMAME.get()), (int)1).requires((ItemLike)TofuItems.NETHER_FUKUMAME.get()).requires((ItemLike)Items.BLAZE_POWDER).unlockedBy("has_item", this.has((ItemLike)TofuItems.NETHER_FUKUMAME.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.SOUL_FUKUMAME.get())).pattern("###").pattern("###").pattern(" X ").define(Character.valueOf('X'), (ItemLike)Items.BOWL).define(Character.valueOf('#'), (ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.ZUNDA_ARROW.get()), (int)8).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('X'), (ItemLike)TofuItems.ZUNDAMA.get()).define(Character.valueOf('#'), (ItemLike)Items.ARROW).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDAMA.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TofuItems.ZUNDAMUSHROOM_ON_A_STICK.get())).pattern("# ").pattern(" M").define(Character.valueOf('#'), (ItemLike)Items.FISHING_ROD).define(Character.valueOf('M'), (ItemLike)TofuBlocks.ZUNDATOFU_MUSHROOM.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.ZUNDATOFU_MUSHROOM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.TOFUBED.get())).pattern("###").pattern("PPP").define(Character.valueOf('#'), (ItemLike)TofuItems.YUBA.get()).define(Character.valueOf('P'), ItemTags.PLANKS).unlockedBy("has_item", this.has((ItemLike)TofuItems.YUBA.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.FOODPLATE.get())).pattern("CCC").define(Character.valueOf('C'), (ItemLike)Items.CLAY_BALL).unlockedBy("has_item", this.has((ItemLike)Items.CLAY_BALL)).save(this.output);
        this.tofuBlockItem(this.output, (Supplier<? extends ItemLike>)TofuBlocks.SESAMETOFU, (Supplier<? extends ItemLike>)TofuItems.TOFUSESAME);
        this.makeStairs(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSTAIR_SESAME, (Supplier<? extends ItemLike>)TofuBlocks.SESAMETOFU);
        this.makeSlab(this.output, (Supplier<? extends ItemLike>)TofuBlocks.TOFUSLAB_SESAME, (Supplier<? extends ItemLike>)TofuBlocks.SESAMETOFU);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.KOUJI_BASE.get()), (int)1).requires(TofuTags.Items.SOYBEAN).requires(Tags.Items.CROPS_WHEAT).unlockedBy("has_item", this.has(TofuTags.Items.SOYBEAN)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.TOFU_SHIELD.get())).pattern("###").pattern("###").pattern(" # ").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUMETAL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMETAL.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.ROLLINGPIN.get())).pattern("  S").pattern(" # ").pattern("S  ").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", this.has((ItemLike)Items.STICK)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.RICE_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.RICE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.RICE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.RICE.get()), (int)9).requires(TofuTags.Items.RICE_BLOCK).unlockedBy("has_item", this.has(TofuTags.Items.RICE_BLOCK)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.SOYBEANS_SEEDS_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.SEEDS_SOYBEANS.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.SEEDS_SOYBEANS.get()), (int)9).requires((ItemLike)TofuBlocks.SOYBEANS_SEEDS_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.SOYBEANS_SEEDS_BLOCK.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.NETHER_SOYBEANS_SEEDS_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.SEEDS_SOYBEANS_NETHER.get()), (int)9).requires((ItemLike)TofuBlocks.NETHER_SOYBEANS_SEEDS_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.NETHER_SOYBEANS_SEEDS_BLOCK.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.SOUL_SOYBEANS_SEEDS_BLOCK.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.SEEDS_SOYBEANS_SOUL.get()), (int)9).requires((ItemLike)TofuBlocks.SOUL_SOYBEANS_SEEDS_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.SOUL_SOYBEANS_SEEDS_BLOCK.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.KINAKO_BREAD.get()), (int)3).requires((ItemLike)TofuItems.KINAKO.get()).requires((ItemLike)Items.BREAD).requires((ItemLike)Items.BREAD).requires((ItemLike)Items.BREAD).requires((ItemLike)TofuItems.BOTTLE_SOYOIL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYOIL.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MISC, Optional.empty(), (ItemLike)TofuItems.EDAMAME_TEMPLA.get(), 6, 300, 0.3f).requires((ItemLike)TofuItems.BOILED_EDAMAME.get()).requires((ItemLike)TofuItems.BOILED_EDAMAME.get()).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((ItemLike)TofuItems.SALT.get()).requires((ItemLike)TofuItems.BOTTLE_SOYOIL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_SOYOIL.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.NEGIMA.get()), (int)1).requires((ItemLike)TofuItems.LEEK.get()).requires((ItemLike)TofuItems.SOYMEAT.get()).requires((ItemLike)Items.STICK).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SOYMEAT.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOY_KARAAGE.get()), (int)1).requires((ItemLike)TofuItems.SOYMEAT.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.BOTTLE_SOYOIL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SOYMEAT.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMEATDON.get()), (int)1).requires((ItemLike)TofuItems.SOYMEAT.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.LEEK.get()).requires((ItemLike)TofuItems.RICE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SOYMEAT.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.SPROUTSJAR.get())).pattern("G").pattern("W").define(Character.valueOf('G'), (ItemLike)Blocks.TINTED_GLASS).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy("has_item", this.has((ItemLike)Blocks.TINTED_GLASS)).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.HELL_MABOU.get())).requires((ItemLike)TofuItems.TOFUHELL.get()).requires((ItemLike)TofuItems.DOUBANJIANG.get()).requires((ItemLike)TofuItems.CHILI.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.DOUBANJIANG.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.RED_SOUP.get())).requires((ItemLike)TofuItems.TOFUHELL.get()).requires((ItemLike)Items.COOKED_COD).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.BEETROOT).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUHELL.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.HELL_RED_SOUP.get())).requires((ItemLike)TofuItems.TOFUHELL.get()).requires((ItemLike)Items.COOKED_COD).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.BEETROOT).requires((ItemLike)Items.BOWL).requires((ItemLike)TofuItems.DOUBANJIANG.get()).requires((ItemLike)TofuItems.CHILI.get(), 2).unlockedBy("has_item", this.has((ItemLike)TofuItems.DOUBANJIANG.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SUKIYAKI.get())).requires((ItemLike)TofuItems.TOFUGRILLED.get(), 2).requires((ItemLike)Items.COOKED_BEEF).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGRILLED.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFU_BUNS_BURGER.get())).pattern("G").pattern("M").pattern("G").define(Character.valueOf('G'), (ItemLike)TofuItems.TOFUGRILLED.get()).define(Character.valueOf('M'), (ItemLike)TofuItems.TOFU_HAMBURG.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_HAMBURG.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.FAST_FOOD, Optional.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)50)), ((Item)TofuItems.STEAMED_BREAD.get()).getDefaultInstance()).requires(TofuTags.Items.MILK_SOYMILK).requires((TagKey<Item>)Tags.Items.EGGS).requires((ItemLike)Items.SUGAR).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy("has_item", this.has(TofuTags.Items.MILK_SOYMILK)).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.FAST_FOOD, Optional.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)50)), ((Item)TofuItems.STEAMED_BREAD_COCOA.get()).getDefaultInstance()).requires(TofuTags.Items.MILK_SOYMILK).requires((TagKey<Item>)Tags.Items.EGGS).requires((ItemLike)Items.SUGAR).requires((TagKey<Item>)Tags.Items.CROPS_WHEAT).requires((ItemLike)Items.COCOA_BEANS).unlockedBy("has_item", this.has(TofuTags.Items.MILK_SOYMILK)).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.FAST_FOOD, (Item)TofuItems.SANBUZHAN.get()).requires((TagKey<Item>)Tags.Items.EGGS).requires((ItemLike)TofuItems.STARCH.get()).requires((ItemLike)Items.SUGAR).requires((ItemLike)TofuItems.BOTTLE_SOYOIL.get()).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.STARCH.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_SOUL_BOTTLE.get()), (int)3).requires((ItemLike)TofuItems.BUCKET_SOYMILK_SOUL.get()).requires((ItemLike)Items.GLASS_BOTTLE, 3).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK_SOUL.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_HELL_BOTTLE.get()), (int)3).requires((ItemLike)TofuItems.BUCKET_SOYMILK_NETHER.get()).requires((ItemLike)Items.GLASS_BOTTLE, 3).unlockedBy("has_item", this.has((ItemLike)TofuItems.BUCKET_SOYMILK_NETHER.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_PALE_BOTTLE.get()), (int)3).requires((ItemLike)TofuItems.SEEDS_SOYBEANS_PALE.get()).requires((ItemLike)Items.GLASS_BOTTLE, 3).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_PALE.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SOYMILK_PALE_GLOW_BOTTLE.get()), (int)3).requires((ItemLike)TofuItems.SEEDS_SOYBEANS_PALE_GLOW.get()).requires((ItemLike)Items.GLASS_BOTTLE, 3).unlockedBy("has_item", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS_PALE_GLOW.get())).save(this.output);
        this.makeSign((Supplier<? extends SignBlock>)TofuBlocks.TOFU_STEM_SIGN, (Supplier<? extends Block>)TofuBlocks.TOFU_STEM_PLANKS).save(this.output);
        this.makeSign((Supplier<? extends SignBlock>)TofuBlocks.LEEK_SIGN, (Supplier<? extends Block>)TofuBlocks.LEEK_PLANKS).save(this.output);
        this.makeSign((Supplier<? extends SignBlock>)TofuBlocks.LEEK_GREEN_SIGN, (Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_PLANKS).save(this.output);
        this.makeHangingSign((Supplier<? extends CeilingHangingSignBlock>)TofuBlocks.TOFU_STEM_HANGING_SIGN, (Supplier<? extends Block>)TofuBlocks.TOFU_STEM).save(this.output);
        this.makeHangingSign((Supplier<? extends CeilingHangingSignBlock>)TofuBlocks.LEEK_HANGING_SIGN, (Supplier<? extends Block>)TofuBlocks.LEEK_STEM).save(this.output);
        this.makeHangingSign((Supplier<? extends CeilingHangingSignBlock>)TofuBlocks.LEEK_GREEN_HANGING_SIGN, (Supplier<? extends Block>)TofuBlocks.LEEK_GREEN_STEM).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BREWING, (ItemLike)Blocks.CAULDRON, (int)1).pattern("# #").pattern("# #").pattern("###").define(Character.valueOf('#'), (ItemLike)TofuBlocks.METALTOFU.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.METALTOFU.get())).save(this.output, this.prefix("tofumetal_with_cauldron"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.SMITHING_TABLE, (int)1).pattern("##").pattern("PP").pattern("PP").define(Character.valueOf('#'), (ItemLike)TofuBlocks.METALTOFU.get()).define(Character.valueOf('P'), ItemTags.PLANKS).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.METALTOFU.get())).save(this.output, this.prefix("tofumetal_with_smithing_table"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.BLAST_FURNACE, (int)1).pattern("###").pattern("#F#").pattern("SSS").define(Character.valueOf('#'), (ItemLike)TofuBlocks.METALTOFU.get()).define(Character.valueOf('S'), (ItemLike)Blocks.SMOOTH_STONE).define(Character.valueOf('F'), (ItemLike)Blocks.FURNACE).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.METALTOFU.get())).save(this.output, this.prefix("tofumetal_with_blast_furnace"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuBlocks.TOFU_DETECTOR.get()), (int)1).pattern("BBB").pattern("GRR").pattern("BBB").define(Character.valueOf('G'), (ItemLike)TofuItems.TOFUGEM.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('B'), Tags.Items.COBBLESTONES).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuItems.TF_CAPACITOR.get())).pattern(" M ").pattern("RGR").pattern(" M ").define(Character.valueOf('M'), (ItemLike)TofuItems.TOFUMETAL.get()).define(Character.valueOf('R'), (ItemLike)TofuItems.TOFU_GEM_DUST.get()).define(Character.valueOf('G'), (ItemLike)TofuItems.TOFUGEM.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuItems.TF_CIRCUIT.get())).pattern("RIR").pattern("TTT").define(Character.valueOf('T'), (ItemLike)TofuBlocks.ISHITOFU.get()).define(Character.valueOf('R'), (ItemLike)TofuItems.TOFU_GEM_DUST.get()).define(Character.valueOf('I'), (ItemLike)TofuItems.TOFUISHI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuItems.TF_COIL.get())).pattern("RRR").pattern("TTT").pattern("RRR").define(Character.valueOf('T'), (ItemLike)TofuItems.TOFUISHI.get()).define(Character.valueOf('R'), (ItemLike)TofuItems.TOFU_GEM_DUST.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuItems.TF_OSCILLATOR.get())).pattern("TCT").pattern("M M").define(Character.valueOf('M'), (ItemLike)TofuItems.TOFUMETAL.get()).define(Character.valueOf('T'), (ItemLike)TofuItems.TOFUKINU.get()).define(Character.valueOf('C'), (ItemLike)Items.QUARTZ).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.TOFU_GEM_DUST.get()), (int)2).requires((ItemLike)TofuItems.TOFUGEM.get()).requires((ItemLike)TofuItems.TOFU_MINCED.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuBlocks.ANTENNA_BASIC.get())).pattern(" P ").pattern("LCO").pattern("TTT").define(Character.valueOf('P'), (ItemLike)TofuItems.LEEK.get()).define(Character.valueOf('O'), (ItemLike)TofuItems.TF_OSCILLATOR.get()).define(Character.valueOf('L'), (ItemLike)TofuItems.TF_COIL.get()).define(Character.valueOf('C'), (ItemLike)TofuItems.TOFU_CORE.get()).define(Character.valueOf('T'), (ItemLike)TofuItems.TOFUMETAL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuBlocks.TF_STORAGE.get())).pattern("CCC").pattern("GTG").define(Character.valueOf('G'), (ItemLike)Blocks.GLASS).define(Character.valueOf('T'), (ItemLike)TofuBlocks.METALTOFU.get()).define(Character.valueOf('C'), (ItemLike)TofuItems.TF_CAPACITOR.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuBlocks.TF_COLLECTOR.get())).pattern("HCH").pattern("AMA").define(Character.valueOf('A'), (ItemLike)TofuItems.ADVANCE_TOFUGEM.get()).define(Character.valueOf('M'), (ItemLike)TofuBlocks.METALTOFU.get()).define(Character.valueOf('C'), (ItemLike)TofuItems.TF_CIRCUIT.get()).define(Character.valueOf('H'), (ItemLike)Blocks.HOPPER).unlockedBy("has_item", this.has((ItemLike)TofuItems.ADVANCE_TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuItems.TOFU_CORE.get())).pattern("MCM").pattern("TTT").pattern("MRM").define(Character.valueOf('M'), (ItemLike)TofuItems.TOFUMETAL.get()).define(Character.valueOf('C'), (ItemLike)TofuItems.TF_CIRCUIT.get()).define(Character.valueOf('T'), (ItemLike)TofuItems.TOFU_GEM_DUST.get()).define(Character.valueOf('R'), (ItemLike)TofuItems.TF_CAPACITOR.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_GEM_DUST.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuItems.TF_BATTERY.get())).pattern("MRM").pattern("MTM").pattern("MTM").define(Character.valueOf('M'), (ItemLike)TofuItems.TOFUMETAL.get()).define(Character.valueOf('T'), (ItemLike)TofuItems.TOFUGEM.get()).define(Character.valueOf('R'), (ItemLike)TofuItems.TOFU_GEM_DUST.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuBlocks.TF_OVEN.get())).pattern(" C ").pattern("LML").pattern(" T ").define(Character.valueOf('M'), (ItemLike)TofuBlocks.METALTOFU.get()).define(Character.valueOf('T'), (ItemLike)TofuBlocks.HELLTOFU_BRICK.get()).define(Character.valueOf('C'), (ItemLike)TofuItems.TOFU_CORE.get()).define(Character.valueOf('L'), (ItemLike)TofuItems.TF_COIL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_CORE.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TofuBlocks.TOFU_WORK_STATION.get())).pattern("MM").pattern("TT").pattern("TT").define(Character.valueOf('T'), (ItemLike)TofuBlocks.ISHITOFU.get()).define(Character.valueOf('M'), (ItemLike)TofuItems.TOFUMETAL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUGEM.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.SALT_BLOCK.get())).pattern("SSS").pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)TofuItems.SALT.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SALT.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.SALT.get()), (int)9).requires((ItemLike)TofuBlocks.SALT_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.SALT.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.OKARA_BLOCK.get())).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)TofuItems.OKARA.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.OKARA.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TofuItems.OKARA.get()), (int)4).requires((ItemLike)TofuBlocks.OKARA_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.OKARA.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), new ItemStack((ItemLike)TofuBlocks.GIANT_OKARA_DONUT.get(), 2), 400, 1.0f).requires((ItemLike)TofuBlocks.OKARA_BLOCK.get(), 2).requires((ItemLike)Blocks.HAY_BLOCK, 1).requires(Ingredient.of((HolderSet)lookup.getOrThrow(Tags.Items.EGGS)), 2).unlockedBy("has_item", this.has((ItemLike)TofuItems.OKARA.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.TOFU_CRAFTERS_BOOK.get()), (int)1).requires((ItemLike)TofuItems.SEEDS_SOYBEANS.get()).requires((ItemLike)Items.BOOK).unlockedBy("inside_of", this.has((ItemLike)TofuItems.SEEDS_SOYBEANS.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.TOFU_POT.get())).pattern("S S").pattern("# #").pattern("###").define(Character.valueOf('S'), (ItemLike)TofuItems.TOFUISHI.get()).define(Character.valueOf('#'), (ItemLike)TofuBlocks.METALTOFU.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.METALTOFU.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.TF_CRAFTING_TABLE.get())).pattern("B").pattern("T").pattern("E").define(Character.valueOf('T'), TofuBlocks.METALTOFU).define(Character.valueOf('B'), (ItemLike)Blocks.CRAFTING_TABLE).define(Character.valueOf('E'), (ItemLike)TofuItems.TOFU_CORE.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_CORE.get())).save(this.output);
        TFShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TFCraftingCategory.MISC, (ItemLike)TofuItems.ZUNDAMA.get(), 1, 100).requires((ItemLike)TofuItems.ZUNDA.get(), 4).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA.get())).save(this.output, this.prefix("zundama_with_tf"));
        TFShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TFCraftingCategory.MISC, (ItemLike)TofuItems.ZUNDA_INGOT.get(), 1, 400).requires((ItemLike)TofuItems.ZUNDAMA.get(), 4).requires((ItemLike)TofuItems.TOFUISHI.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDAMA.get())).save(this.output);
        TFShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TFCraftingCategory.MISC, (ItemLike)TofuItems.ZUNDA_ALLOY_TOFU.get(), 1, 400).requires((ItemLike)TofuItems.ZUNDA_INGOT.get(), 2).requires((ItemLike)TofuItems.TOFUMETAL.get(), 2).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA_INGOT.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuBlocks.ZUNDA_ALLOY_TOFU_BLOCK.get())).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)TofuItems.ZUNDA_ALLOY_TOFU.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA_ALLOY_TOFU.get())).save(this.output, "zunda_alloy_to_block");
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.ZUNDA_ALLOY_TOFU.get()), (int)9).requires((ItemLike)TofuBlocks.ZUNDA_ALLOY_TOFU_BLOCK.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA_ALLOY_TOFU.get())).save(this.output, this.prefix("revert_to_zunda_alloy"));
        TFShapedRecipeBuilder.shaped((HolderGetter<Item>)lookup, TFCraftingCategory.MISC, ((Item)TofuItems.ZUNDA_BOW.get()).getDefaultInstance(), 1000).define(Character.valueOf('S'), (ItemLike)TofuItems.ZUNDAMA.get()).define(Character.valueOf('Z'), (ItemLike)TofuItems.ZUNDA_INGOT.get()).define(Character.valueOf('G'), (ItemLike)TofuItems.TOFUGEM.get()).pattern(" ZS").pattern("ZGS").pattern(" ZS").unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA_INGOT.get())).save(this.output);
        TFShapedRecipeBuilder.shaped((HolderGetter<Item>)lookup, TFCraftingCategory.MISC, ((Item)TofuItems.ZUNDA_TOTEM.get()).getDefaultInstance(), 1000).define(Character.valueOf('D'), (ItemLike)TofuItems.TOFUDIAMOND_NUGGET.get()).define(Character.valueOf('Z'), (ItemLike)TofuItems.ZUNDA_INGOT.get()).define(Character.valueOf('G'), (ItemLike)TofuItems.SOY_FORCE_SHARD.get()).pattern("ZDZ").pattern("ZGZ").pattern(" Z ").unlockedBy("has_item", this.has((ItemLike)TofuItems.SOY_FORCE_SHARD.get())).save(this.output);
        TFShapedRecipeBuilder.shaped((HolderGetter<Item>)lookup, TFCraftingCategory.MISC, ((Item)TofuItems.ZUNDA_ALLOY_TOFU_SWORD.get()).getDefaultInstance(), 1000).define(Character.valueOf('Z'), (ItemLike)TofuItems.ZUNDA_ALLOY_TOFU.get()).define(Character.valueOf('G'), (ItemLike)TofuItems.SOY_FORCE_SHARD.get()).pattern("Z").pattern("Z").pattern("G").unlockedBy("has_item", this.has((ItemLike)TofuItems.ZUNDA_ALLOY_TOFU.get())).save(this.output);
        TFShapedRecipeBuilder.shaped((HolderGetter<Item>)lookup, TFCraftingCategory.MISC, ((Item)TofuItems.TOFUSTICK.get()).getDefaultInstance(), 1000).define(Character.valueOf('T'), (ItemLike)TofuItems.TOFUMETAL.get()).define(Character.valueOf('G'), (ItemLike)TofuItems.TOFUGEM.get()).pattern("G").pattern("T").pattern("T").unlockedBy("has_item", this.has((ItemLike)TofuBlocks.TF_CRAFTING_TABLE.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.ISHITOFU_BRICK.get()), (int)4).pattern("MM").pattern("MM").define(Character.valueOf('M'), (ItemLike)TofuBlocks.TOFU_TERRAIN_ISHI.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.TOFU_TERRAIN_ISHI.get())).save(this.output, this.prefix("terrain_tofu_ishi"));
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.ISHITOFU_BRICK.get()), (int)4).pattern("MM").pattern("MM").define(Character.valueOf('M'), (ItemLike)TofuBlocks.TOFUSLATE.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.TOFUSLATE.get())).save(this.output, this.prefix("slate_tofu_ishi"));
        this.cuttingRecipe(this.output, () -> TofuBlocks.TOFUSLATE, () -> TofuBlocks.ISHITOFU_BRICK, 1);
        this.cuttingRecipe(this.output, () -> TofuBlocks.TOFU_TERRAIN_ISHI, () -> TofuBlocks.ISHITOFU_BRICK, 1);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.FAST_FOOD, Optional.empty(), (ItemLike)TofuItems.MONSTER_JERKY.get(), 340, 0.1f).requires((ItemLike)Items.ROTTEN_FLESH).requires((ItemLike)TofuItems.SALT.get(), 4).unlockedBy("has_item", this.has((ItemLike)TofuItems.SALT.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.FAST_FOOD, Optional.empty(), (ItemLike)TofuItems.MONSTER_PORK_JERKY.get(), 340, 0.1f).requires((ItemLike)TofuItems.ROTTEN_PORK.get()).requires((ItemLike)TofuItems.SALT.get(), 4).unlockedBy("has_item", this.has((ItemLike)TofuItems.SALT.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MISC, Optional.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)200)), (ItemLike)TofuItems.BOILED_EDAMAME.get(), 6, 200, 0.2f).requires((ItemLike)TofuItems.EDAMAME.get(), 6).unlockedBy("has_item", this.has((ItemLike)TofuItems.EDAMAME.get())).save(this.output);
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.KINUTOFU.get()), (int)1).requires((ItemLike)TofuBlocks.WAXED_KINUTOFU.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.WAXED_KINUTOFU.get())).save(this.output, this.prefix("wax_out_kinu"));
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.MOMENTOFU.get()), (int)1).requires((ItemLike)TofuBlocks.WAXED_MOMENTOFU.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.WAXED_MOMENTOFU.get())).save(this.output, this.prefix("wax_out_momen"));
        ShapelessRecipeBuilder.shapeless((HolderGetter)lookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TofuBlocks.ISHITOFU.get()), (int)1).requires((ItemLike)TofuBlocks.WAXED_ISHITOFU.get()).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.WAXED_ISHITOFU.get())).save(this.output, this.prefix("wax_out_ishi"));
        ShapedRecipeBuilder.shaped((HolderGetter)lookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TofuItems.TOFU_METAL_BOWL.get()), (int)3).pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)TofuItems.TOFUMETAL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFUMETAL.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.GRATIN.get(), 1, 300, 0.6f).requires((ItemLike)TofuItems.SOY_CHEESE.get()).requires((ItemLike)TofuItems.TOFUKINU.get()).requires((ItemLike)Items.POTATO).requires((ItemLike)Items.CHICKEN).requires((ItemLike)TofuItems.TOFU_METAL_BOWL.get()).unlockedBy("has_item", this.has((ItemLike)TofuItems.TOFU_METAL_BOWL.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.MUSHROOM_ANKAKE.get(), 1, 300, 0.8f).requires((ItemLike)TofuItems.BOTTLE_MIRIN.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.SALT.get()).requires((ItemLike)TofuItems.STARCH.get()).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_MIRIN.get())).save(this.output);
        TofuPotShapelessRecipeBuilder.shapeless((HolderGetter<Item>)lookup, TofuPotCategory.MEAL, Optional.empty(), (ItemLike)TofuItems.TOFU_ANKAKE.get(), 1, 300, 0.8f).requires((ItemLike)TofuItems.BOTTLE_MIRIN.get()).requires((ItemLike)TofuItems.BOTTLE_SOYSAUSE.get()).requires((ItemLike)TofuItems.SALT.get()).requires((ItemLike)TofuItems.STARCH.get()).requires(TofuTags.Items.TOFU).requires((ItemLike)Items.BOWL).unlockedBy("has_item", this.has((ItemLike)TofuItems.BOTTLE_MIRIN.get())).save(this.output);
        BitternRecipeBuilder.bittern(((Block)TofuBlocks.KINUTOFU.get()).asItem().getDefaultInstance(), new FluidStack((Fluid)TofuFluids.SOYMILK.get(), 1000), Ingredient.of((ItemLike)((ItemLike)TofuItems.BITTERN_BOTTLE.get()))).unlockedBy("has_item", this.has((ItemLike)TofuItems.BITTERN_BOTTLE.get())).save(this.output, this.prefix("bittern_to_kinu"));
        BitternRecipeBuilder.bittern(((Block)TofuBlocks.HELLTOFU.get()).asItem().getDefaultInstance(), new FluidStack((Fluid)TofuFluids.SOYMILK_HELL.get(), 1000), Ingredient.of((ItemLike)((ItemLike)TofuItems.WARPED_BOTTLE.get()))).unlockedBy("has_item", this.has((ItemLike)TofuItems.WARPED_BOTTLE.get())).save(this.output, this.prefix("bittern_to_hell"));
        BitternRecipeBuilder.bittern(((Block)TofuBlocks.SOULTOFU.get()).asItem().getDefaultInstance(), new FluidStack((Fluid)TofuFluids.SOYMILK_SOUL.get(), 1000), Ingredient.of((ItemLike)((ItemLike)TofuItems.CRIMSON_BOTTLE.get()))).unlockedBy("has_item", this.has((ItemLike)TofuItems.CRIMSON_BOTTLE.get())).save(this.output, this.prefix("bittern_to_soul"));
        HardenRecipeBuilder.harden(((Block)TofuBlocks.ISHITOFU.get()).asItem().getDefaultInstance(), Ingredient.of((ItemLike)((ItemLike)TofuBlocks.MOMENTOFU.get()))).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.MOMENTOFU.get())).save(this.output, this.prefix("harden_to_ishi"));
        HardenRecipeBuilder.harden(((Block)TofuBlocks.METALTOFU.get()).asItem().getDefaultInstance(), Ingredient.of((ItemLike)((ItemLike)TofuBlocks.ISHITOFU.get()))).unlockedBy("has_item", this.has((ItemLike)TofuBlocks.ISHITOFU.get())).save(this.output, this.prefix("harden_to_metal"));
    }
}

