/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity;

import baguchi.tofucraft.entity.projectile.FallingTofuEntity;
import baguchi.tofucraft.registry.TofuBlocks;
import java.util.Collection;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TofuCreeper
extends Creeper {
    public TofuCreeper(EntityType<? extends Creeper> p_32278_, Level p_32279_) {
        super(p_32278_, p_32279_);
    }

    public void explodeCreeper() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            float f = this.isPowered() ? 1.8f : 0.8f;
            this.dead = true;
            serverlevel.explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)this.explosionRadius * f, Level.ExplosionInteraction.NONE);
            this.spawnTofu();
            this.spawnLingeringCloud();
            this.triggerOnDeathMobEffects(serverlevel, Entity.RemovalReason.KILLED);
            this.discard();
        }
    }

    private void spawnTofu() {
        float f = this.isPowered() ? 1.0f : 0.5f;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = this.isPowered() ? (Block)TofuBlocks.ZUNDATOFU.get() : (Block)TofuBlocks.KINUTOFU.get();
            for (int i = 0; i < 6; ++i) {
                FallingTofuEntity fallingBlock = new FallingTofuEntity((Level)serverLevel, (LivingEntity)this, block.defaultBlockState());
                fallingBlock.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * f, this.random.nextFloat() * 0.5f + f * 0.35f, (this.random.nextFloat() - this.random.nextFloat()) * f);
                fallingBlock.setCanPlace(false);
                serverLevel.addFreshEntityWithPassengers((Entity)fallingBlock);
            }
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.getActiveEffects();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            areaeffectcloud.setRadius(2.5f);
            areaeffectcloud.setRadiusOnUse(-0.5f);
            areaeffectcloud.setWaitTime(10);
            areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.addEffect(new MobEffectInstance(mobeffectinstance));
            }
            this.level().addFreshEntity((Entity)areaeffectcloud);
        }
    }
}

