/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.projectile;

import baguchi.tofucraft.registry.TofuDamageTypes;
import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuParticleTypes;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SoyballEntity
extends ThrowableProjectile {
    public float damage = 2.0f;
    @Nullable
    protected ItemStack firedFromWeapon = null;

    public SoyballEntity(EntityType<? extends SoyballEntity> p_i50154_1_, Level p_i50154_2_) {
        super(p_i50154_1_, p_i50154_2_);
    }

    public SoyballEntity(Level worldIn, LivingEntity thrower) {
        super(TofuEntityTypes.SOYBALL.get(), thrower.getX(), thrower.getEyeY(), thrower.getZ(), worldIn);
        this.setOwner((Entity)thrower);
    }

    public SoyballEntity(Level level, LivingEntity thrower, ItemStack stack) {
        super(TofuEntityTypes.SOYBALL.get(), thrower.getX(), thrower.getEyeY(), thrower.getZ(), level);
        this.setOwner((Entity)thrower);
        this.firedFromWeapon = stack.copy();
    }

    public SoyballEntity(Level worldIn, double x, double y, double z) {
        super(TofuEntityTypes.SOYBALL.get(), x, y, z, worldIn);
    }

    public SoyballEntity(EntityType<? extends SoyballEntity> p_i50154_1_, Level worldIn, double x, double y, double z) {
        super(p_i50154_1_, x, y, z, worldIn);
    }

    public SoyballEntity(EntityType<? extends SoyballEntity> entityType, LivingEntity thrower, Level level) {
        super(entityType, thrower.getX(), thrower.getY(), thrower.getZ(), level);
        this.setOwner((Entity)thrower);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 6; ++i) {
                this.level().addParticle((ParticleOptions)TofuParticleTypes.SOYMILK_SPLASH.get(), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult p_37404_) {
        ServerLevel serverLevel;
        Level target;
        Entity entity;
        Level level;
        super.onHitEntity(p_37404_);
        Entity entity2 = p_37404_.getEntity();
        DamageSource damagesource = this.damageSources().source(TofuDamageTypes.SOY_SPLASH, (Entity)this, this.getOwner());
        double d0 = this.damage;
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity2, (DamageSource)damagesource, (float)((float)d0));
        }
        if ((entity = this.getOwner()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity2 instanceof LivingEntity && livingEntity.isAlliedTo((Entity)(target = (LivingEntity)entity2))) {
                return;
            }
        }
        if ((target = this.level()) instanceof ServerLevel && entity2.hurtServer(serverLevel = (ServerLevel)target, damagesource, (float)d0) && (entity = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)entity;
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity2, (DamageSource)damagesource);
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                this.discard();
            }
        }
    }

    protected void hitBlockEnchantmentEffects(ServerLevel p_345462_, BlockHitResult p_345204_, ItemStack p_345083_) {
        LivingEntity livingentity;
        Vec3 vec3 = p_345204_.getBlockPos().clampLocationWithin(p_345204_.getLocation());
        Entity entity = this.getOwner();
        EnchantmentHelper.onHitBlock((ServerLevel)p_345462_, (ItemStack)p_345083_, (LivingEntity)(entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : null), (Entity)this, null, (Vec3)vec3, (BlockState)p_345462_.getBlockState(p_345204_.getBlockPos()), p_348569_ -> {
            this.firedFromWeapon = null;
        });
    }

    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected void onHit(HitResult p_37406_) {
        super.onHit(p_37406_);
        this.playSound(SoundEvents.GENERIC_SPLASH, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        ItemStack itemstack = this.getWeaponItem();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (itemstack != null) {
                this.hitBlockEnchantmentEffects(serverlevel, result, itemstack);
            }
        }
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public void addAdditionalSaveData(ValueOutput p_37222_) {
        super.addAdditionalSaveData(p_37222_);
        p_37222_.putFloat("Damage", (float)((byte)this.damage));
        if (this.firedFromWeapon != null) {
            p_37222_.store("weapon", ItemStack.CODEC, (Object)this.firedFromWeapon);
        }
    }

    public void readAdditionalSaveData(ValueInput p_37220_) {
        super.readAdditionalSaveData(p_37220_);
        this.damage = p_37220_.getFloatOr("Damage", 1.0f);
        this.firedFromWeapon = p_37220_.read("weapon", ItemStack.CODEC).orElse(null);
    }
}

