/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.utils;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class JigsawHelper {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"));

    public static void registerJigsaw(MinecraftServer server, ResourceLocation poolLocation, ResourceLocation nbtLocation, int weight) {
        RegistryAccess.Frozen manager = server.registryAccess();
        Registry templatePoolRegistry = manager.lookupOrThrow(Registries.TEMPLATE_POOL);
        Registry processorListRegistry = manager.lookupOrThrow(Registries.PROCESSOR_LIST);
        Optional pool = templatePoolRegistry.get(poolLocation);
        if (pool.isEmpty()) {
            return;
        }
        ObjectArrayList elements = ((StructureTemplatePool)((Holder.Reference)pool.get()).value()).templates;
        Holder.Reference processorListHolder = processorListRegistry.getOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        StructurePoolElement element = (StructurePoolElement)SinglePoolElement.legacy((String)nbtLocation.toString(), (Holder)processorListHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            elements.add((Object)element);
        }
        ArrayList elementCounts = new ArrayList(((StructureTemplatePool)((Holder.Reference)pool.get()).value()).rawTemplates);
        elements.addAll((ObjectList)((StructureTemplatePool)((Holder.Reference)pool.get()).value()).templates);
        elementCounts.addAll(((StructureTemplatePool)((Holder.Reference)pool.get()).value()).rawTemplates);
        ((StructureTemplatePool)((Holder.Reference)pool.get()).value()).templates = elements;
        ((StructureTemplatePool)((Holder.Reference)pool.get()).value()).rawTemplates = elementCounts;
    }
}

